/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.Properties;
import org.exist.scheduler.impl.ShutdownTask;
import org.exist.scheduler.impl.SystemTaskJobImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.xmldb.AbstractLocalService;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.DatabaseStatus;
import org.xmldb.api.base.XMLDBException;

public class LocalDatabaseInstanceManager
extends AbstractLocalService
implements DatabaseInstanceManager {
    public LocalDatabaseInstanceManager(Subject user, BrokerPool pool) {
        super(user, pool, null);
    }

    public String getName() throws XMLDBException {
        return "DatabaseInstanceManager";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    @Override
    public void shutdown() throws XMLDBException {
        this.brokerPool.shutdown();
    }

    @Override
    public void shutdown(long delay) throws XMLDBException {
        if (!this.user.hasDbaRole()) {
            throw new XMLDBException(4, "only users in group dba may shut down the database");
        }
        SystemTaskJobImpl shutdownJob = new SystemTaskJobImpl("xmldb:local-api.shutdown", new ShutdownTask());
        this.brokerPool.getScheduler().createPeriodicJob(0L, shutdownJob, delay, new Properties(), 0);
    }

    @Override
    public boolean enterServiceMode() throws XMLDBException {
        try {
            this.brokerPool.enterServiceMode(this.user);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public void exitServiceMode() throws XMLDBException {
        try {
            this.brokerPool.exitServiceMode(this.user);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DatabaseStatus getStatus() throws XMLDBException {
        return new DatabaseStatus(this.brokerPool);
    }

    @Override
    public boolean isLocalInstance() {
        return true;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }
}

