/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.SortedNodeSet;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.AbstractLocal;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.LocalBinaryResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Base64BinaryDocument;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class LocalResourceSet
extends AbstractLocal
implements ResourceSet {
    private static final Logger LOG = LogManager.getLogger(LocalResourceSet.class);
    private final List<Object> resources = new ArrayList<Object>();
    private final Properties outputProperties;

    public LocalResourceSet(Subject user, BrokerPool pool, LocalCollection col, Properties properties, Sequence val, String sortExpr) throws XMLDBException {
        super(user, pool, col);
        Sequence seq;
        this.outputProperties = properties;
        if (val.isEmpty()) {
            return;
        }
        if (Type.subTypeOf(val.getItemType(), -1) && sortExpr != null) {
            SortedNodeSet sorted = new SortedNodeSet(this.brokerPool, user, sortExpr);
            try {
                sorted.addAll(val);
            }
            catch (XPathException e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
            seq = sorted;
        } else {
            seq = val;
        }
        try {
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                this.resources.add(item);
            }
        }
        catch (XPathException e) {
            throw new XMLDBException(301, e.getMessage(), (Throwable)e);
        }
    }

    public void addResource(Resource resource) throws XMLDBException {
        this.resources.add(resource);
    }

    public void clear() throws XMLDBException {
        this.resources.stream().filter(resource -> resource instanceof BinaryValue).forEach(resource -> {
            try {
                ((BinaryValue)resource).close();
            }
            catch (IOException ioe) {
                LOG.warn("Unable to cleanup BinaryValue: " + resource.hashCode(), (Throwable)ioe);
            }
        });
        this.resources.clear();
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new NewResourceIterator();
    }

    public ResourceIterator getIterator(long start) throws XMLDBException {
        return new NewResourceIterator(start);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        SAXSerializer handler = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        StringWriter writer = new StringWriter();
        handler.setOutput(writer, this.outputProperties);
        return this.withDb((broker, transaction) -> {
            try {
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                this.collection.setProperty("sax-document-events", "false");
                serializer.setProperties(this.outputProperties);
                serializer.setUser(this.user);
                serializer.setSAXHandlers(handler, handler);
                handler.startDocument();
                handler.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
                AttributesImpl attribs = new AttributesImpl();
                attribs.addAttribute("", "hitCount", "hitCount", "CDATA", Integer.toString(this.resources.size()));
                handler.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", attribs);
                for (Item item : this.resources) {
                    if (Type.subTypeOf(item.getType(), -1)) {
                        ((NodeValue)item).toSAX(broker, handler, this.outputProperties);
                        continue;
                    }
                    char[] value = item.toString().toCharArray();
                    handler.characters(value, 0, value.length);
                }
                handler.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
                handler.endPrefixMapping("exist");
                handler.endDocument();
                LocalXMLResource res = new LocalXMLResource(this.user, this.brokerPool, this.collection, XmldbURI.EMPTY_URI);
                res.setContent(writer.toString());
                SerializerPool.getInstance().returnObject(handler);
                return res;
            }
            catch (SAXException e) {
                throw new XMLDBException(0, "serialization error", (Throwable)e);
            }
        });
    }

    public Resource getResource(long pos) throws XMLDBException {
        if (pos < 0L || pos >= (long)this.resources.size()) {
            return null;
        }
        Object r = this.resources.get((int)pos);
        EXistResource res = null;
        if (r instanceof NodeProxy) {
            NodeProxy p = (NodeProxy)r;
            LocalCollection coll = this.collection;
            if (p.getOwnerDocument().getCollection() == null || !coll.getPathURI().toCollectionPathURI().equals(p.getOwnerDocument().getCollection().getURI())) {
                coll = new LocalCollection(this.user, this.brokerPool, null, p.getOwnerDocument().getCollection().getURI());
                coll.setProperties(this.outputProperties);
            }
            res = new LocalXMLResource(this.user, this.brokerPool, coll, p);
        } else if (r instanceof Node) {
            res = new LocalXMLResource(this.user, this.brokerPool, this.collection, XmldbURI.EMPTY_URI);
            ((LocalXMLResource)res).setContentAsDOM((Node)r);
        } else if (r instanceof AtomicValue) {
            if (r instanceof BinaryValue) {
                XmldbURI docId = r instanceof Base64BinaryDocument ? Optional.ofNullable(((Base64BinaryDocument)r).getUrl()).filter(s -> !s.isEmpty()).map(XmldbURI::create).orElse(XmldbURI.EMPTY_URI) : XmldbURI.EMPTY_URI;
                res = new LocalBinaryResource(this.user, this.brokerPool, this.collection, docId);
            } else {
                res = new LocalXMLResource(this.user, this.brokerPool, this.collection, XmldbURI.EMPTY_URI);
            }
            res.setContent(r);
        } else if (r instanceof Resource) {
            return (Resource)r;
        }
        res.setProperties(this.outputProperties);
        return res;
    }

    public Sequence toSequence() {
        if (this.resources.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.resources.size() == 1) {
            return ((Item)this.resources.get(0)).toSequence();
        }
        ValueSequence s = new ValueSequence();
        for (Object resource : this.resources) {
            Item item = (Item)resource;
            s.add(item);
        }
        return s;
    }

    public long getSize() throws XMLDBException {
        return this.resources.size();
    }

    public void removeResource(long pos) throws XMLDBException {
        this.resources.remove(pos);
    }

    class NewResourceIterator
    implements ResourceIterator {
        long pos = 0L;

        public NewResourceIterator() {
        }

        public NewResourceIterator(long start) {
            this.pos = start;
        }

        public boolean hasMoreResources() throws XMLDBException {
            return this.pos < LocalResourceSet.this.getSize();
        }

        public Resource nextResource() throws XMLDBException {
            return LocalResourceSet.this.getResource(this.pos++);
        }
    }
}

