/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import com.evolvedbinary.j8fu.function.FunctionE;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.ACLPermission;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.User;
import org.exist.security.internal.aider.ACEAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.storage.BrokerPool;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.AbstractLocalService;
import org.exist.xmldb.EXistUserManagementService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xmldb.function.LocalXmldbCollectionFunction;
import org.exist.xmldb.function.LocalXmldbDocumentFunction;
import org.exist.xmldb.function.LocalXmldbFunction;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class LocalUserManagementService
extends AbstractLocalService
implements EXistUserManagementService {
    public LocalUserManagementService(Subject user, BrokerPool pool, LocalCollection collection) {
        super(user, pool, collection);
    }

    @Override
    public String getName() {
        return "UserManagementService";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public void addAccount(Account u) throws XMLDBException {
        this.onlyAsAdmin(this.user).apply(manager -> {
            if (manager.hasAccount(u.getName())) {
                throw new XMLDBException(1, "user " + u.getName() + " already exists");
            }
            return (broker, transaction) -> manager.addAccount(u);
        });
    }

    @Override
    public void addGroup(Group group) throws XMLDBException {
        this.onlyAsAdmin(this.user).apply(manager -> {
            if (manager.hasGroup(group.getName())) {
                throw new XMLDBException(1, "group '" + group.getName() + "' already exists");
            }
            return (broker, transaction) -> manager.addGroup(broker, group);
        });
    }

    @Override
    public void setUserPrimaryGroup(String username, String groupName) throws XMLDBException {
        this.onlyAsAdmin(this.user).apply(manager -> {
            if (!manager.hasGroup(groupName)) {
                throw new XMLDBException(4, "Group '" + groupName + "' does not exist!");
            }
            return (broker, transaction) -> {
                Account account = manager.getAccount(username);
                Group group = manager.getGroup(groupName);
                account.setPrimaryGroup(group);
                return manager.updateAccount(account);
            };
        });
    }

    @Override
    public void setPermissions(Resource resource, Permission perm) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            document.setPermissions(perm);
            return null;
        });
    }

    @Override
    public void setPermissions(org.xmldb.api.base.Collection child, Permission perm) throws XMLDBException {
        XmldbURI childUri = XmldbURI.create(child.getName());
        this.updateCollection(childUri).apply((collection, broker, transaction) -> {
            collection.setPermissions(perm);
            return null;
        });
    }

    @Override
    public void setPermissions(org.xmldb.api.base.Collection child, String owner, String group, int mode, List<ACEAider> aces) throws XMLDBException {
        XmldbURI childUri = XmldbURI.create(child.getName());
        this.updateCollection(childUri).apply((collection, broker, transaction) -> {
            Permission permission = collection.getPermissionsNoLock();
            permission.setOwner(owner);
            permission.setGroup(group);
            permission.setMode(mode);
            if (permission instanceof ACLPermission) {
                ACLPermission aclPermission = (ACLPermission)((Object)permission);
                aclPermission.clear();
                for (ACEAider ace : aces) {
                    aclPermission.addACE(ace.getAccessType(), ace.getTarget(), ace.getWho(), ace.getMode());
                }
            }
            return null;
        });
    }

    @Override
    public void setPermissions(Resource resource, String owner, String group, int mode, List<ACEAider> aces) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            Permission permission = document.getPermissions();
            permission.setOwner(owner);
            permission.setGroup(group);
            permission.setMode(mode);
            if (permission instanceof ACLPermission) {
                ACLPermission aclPermission = (ACLPermission)((Object)permission);
                aclPermission.clear();
                for (ACEAider ace : aces) {
                    aclPermission.addACE(ace.getAccessType(), ace.getTarget(), ace.getWho(), ace.getMode());
                }
            }
            return null;
        });
    }

    @Override
    public void chmod(String modeStr) throws XMLDBException {
        XmldbURI collUri = this.collection.getPathURI();
        this.updateCollection(collUri).apply((collection, broker, transaction) -> {
            collection.setPermissions(modeStr);
            return null;
        });
    }

    @Override
    public void chmod(Resource resource, int mode) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            document.getPermissions().setMode(mode);
            return null;
        });
    }

    @Override
    public void chmod(int mode) throws XMLDBException {
        XmldbURI collUri = this.collection.getPathURI();
        this.updateCollection(collUri).apply((collection, broker, transaction) -> {
            collection.setPermissions(mode);
            return null;
        });
    }

    @Override
    public void chmod(Resource resource, String modeStr) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            document.getPermissions().setMode(modeStr);
            return null;
        });
    }

    @Override
    public void chgrp(String group) throws XMLDBException {
        XmldbURI collUri = this.collection.getPathURI();
        this.updateCollection(collUri).apply((collection, broker, transaction) -> {
            Permission permission = collection.getPermissionsNoLock();
            permission.setGroup(group);
            return null;
        });
    }

    @Override
    public void chown(Account u) throws XMLDBException {
        XmldbURI collUri = this.collection.getPathURI();
        this.updateCollection(collUri).apply((collection, broker, transaction) -> {
            Permission permission = collection.getPermissionsNoLock();
            permission.setOwner(u);
            return null;
        });
    }

    @Override
    public void chown(Account u, String group) throws XMLDBException {
        XmldbURI collUri = this.collection.getPathURI();
        this.updateCollection(collUri).apply((collection, broker, transaction) -> {
            Permission permission = collection.getPermissionsNoLock();
            permission.setOwner(u);
            permission.setGroup(group);
            return null;
        });
    }

    @Override
    public void chgrp(Resource resource, String group) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            document.getPermissions().setGroup(group);
            return null;
        });
    }

    @Override
    public void chown(Resource resource, Account u) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            document.getPermissions().setOwner(u);
            return null;
        });
    }

    @Override
    public void chown(Resource resource, Account u, String group) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            document.getPermissions().setOwner(u);
            document.getPermissions().setGroup(group);
            return null;
        });
    }

    @Override
    public String hasUserLock(Resource resource) throws XMLDBException {
        return this.withDb((broker, transaction) -> (String)((AbstractEXistResource)resource).read(broker, transaction).apply((document, broker1, transaction1) -> {
            Account lockOwner = document.getUserLock();
            return lockOwner == null ? null : lockOwner.getName();
        }));
    }

    @Override
    public void lockResource(Resource resource, Account u) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            String resourceId = resource.getId();
            if (!document.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + resourceId);
            }
            SecurityManager manager = broker.getBrokerPool().getSecurityManager();
            if (!this.user.equals(u) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("User " + this.user.getName() + " is not allowed to lock resource '" + resourceId + "' for user " + u.getName());
            }
            Account lockOwner = document.getUserLock();
            if (lockOwner != null) {
                if (lockOwner.equals(u)) {
                    return null;
                }
                if (!manager.hasAdminPrivileges(this.user)) {
                    throw new PermissionDeniedException("Resource '" + resourceId + "' is already locked by user " + lockOwner.getName());
                }
            }
            document.setUserLock(u);
            return null;
        });
    }

    @Override
    public void unlockResource(Resource resource) throws XMLDBException {
        this.modify(resource).apply((document, broker, transaction) -> {
            String resourceId = resource.getId();
            if (!document.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("User is not allowed to lock resource '" + resourceId + "'");
            }
            Account lockOwner = document.getUserLock();
            SecurityManager manager = broker.getBrokerPool().getSecurityManager();
            if (lockOwner != null && !lockOwner.equals(this.user) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("Resource '" + resourceId + "' is already locked by user " + lockOwner.getName());
            }
            document.setUserLock(null);
            return null;
        });
    }

    @Override
    public Permission getPermissions(org.xmldb.api.base.Collection coll) throws XMLDBException {
        if (coll instanceof LocalCollection) {
            return (Permission)this.read(((LocalCollection)coll).getPathURI()).apply((collection, broker, transaction) -> collection.getPermissionsNoLock());
        }
        return null;
    }

    @Override
    public Permission getSubCollectionPermissions(org.xmldb.api.base.Collection parent, String name) throws XMLDBException {
        if (parent instanceof LocalCollection) {
            return (Permission)this.read(((LocalCollection)parent).getPathURI()).apply((collection, broker, transaction) -> collection.getChildCollectionEntry(broker, name).getPermissions());
        }
        return null;
    }

    @Override
    public Permission getSubResourcePermissions(org.xmldb.api.base.Collection parent, String name) throws XMLDBException {
        if (parent instanceof LocalCollection) {
            return (Permission)this.read(((LocalCollection)parent).getPathURI()).apply((collection, broker, transaction) -> collection.getResourceEntry(broker, name).getPermissions());
        }
        return null;
    }

    @Override
    public Date getSubCollectionCreationTime(org.xmldb.api.base.Collection parent, String name) throws XMLDBException {
        if (parent instanceof LocalCollection) {
            return (Date)this.read(((LocalCollection)parent).getPathURI()).apply((collection, broker, transaction) -> new Date(collection.getChildCollectionEntry(broker, name).getCreated()));
        }
        return null;
    }

    @Override
    public Permission getPermissions(Resource resource) throws XMLDBException {
        return this.withDb((broker, transaction) -> (Permission)((AbstractEXistResource)resource).read(broker, transaction).apply((document, broker1, transaction1) -> document.getPermissions()));
    }

    @Override
    public Permission[] listResourcePermissions() throws XMLDBException {
        XmldbURI collectionUri = this.collection.getPathURI();
        return (Permission[])this.read(collectionUri).apply((collection, broker, transaction) -> {
            if (!collection.getPermissionsNoLock().validate(this.user, 4)) {
                return new Permission[0];
            }
            Permission[] perms = new Permission[collection.getDocumentCount(broker)];
            Iterator<DocumentImpl> itDocument = collection.iterator(broker);
            int i = 0;
            while (itDocument.hasNext()) {
                DocumentImpl document = itDocument.next();
                perms[i++] = document.getPermissions();
            }
            return perms;
        });
    }

    @Override
    public Permission[] listCollectionPermissions() throws XMLDBException {
        XmldbURI collectionUri = this.collection.getPathURI();
        return (Permission[])this.read(collectionUri).apply((collection, broker, transaction) -> {
            if (!collection.getPermissionsNoLock().validate(this.user, 4)) {
                return new Permission[0];
            }
            Permission[] perms = new Permission[collection.getChildCollectionCount(broker)];
            Iterator<XmldbURI> itChildCollectionUri = collection.collectionIterator(broker);
            int i = 0;
            while (itChildCollectionUri.hasNext()) {
                XmldbURI childCollectionUri = collectionUri.append(itChildCollectionUri.next());
                Permission childPermission = (Permission)this.read(broker, transaction, childCollectionUri).apply((childCollection, broker1, transaction1) -> childCollection.getPermissionsNoLock());
                perms[i++] = childPermission;
            }
            return perms;
        });
    }

    @Override
    public Account getAccount(String name) throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            return sm.getAccount(name);
        });
    }

    @Override
    public Account[] getAccounts() throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Collection<Account> users = sm.getUsers();
            return users.toArray(new Account[users.size()]);
        });
    }

    @Override
    public Group getGroup(String name) throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            return sm.getGroup(name);
        });
    }

    @Override
    public String[] getGroups() throws XMLDBException {
        return this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Collection<Group> groups = sm.getGroups();
            String[] groupNames = new String[groups.size()];
            int i = 0;
            for (Group group : groups) {
                groupNames[i++] = group.getName();
            }
            return groupNames;
        });
    }

    @Override
    public void removeAccount(Account u) throws XMLDBException {
        this.onlyAsAdmin(this.user).apply(manager -> (broker, transaction) -> {
            manager.deleteAccount(u);
            return null;
        });
    }

    @Override
    public void removeGroup(Group group) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            sm.deleteGroup(group.getName());
            return null;
        });
    }

    @Override
    public void updateAccount(Account u) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            sm.updateAccount(u);
            return null;
        });
    }

    @Override
    public void updateGroup(Group g) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            sm.updateGroup(g);
            return null;
        });
    }

    @Override
    public String[] getGroupMembers(String groupName) throws XMLDBException {
        List groupMembers = this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            return sm.findAllGroupMembers(groupName);
        });
        return groupMembers.toArray(new String[groupMembers.size()]);
    }

    @Override
    public void addAccountToGroup(String accountName, String groupName) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Account account = sm.getAccount(accountName);
            account.addGroup(groupName);
            sm.updateAccount(account);
            return null;
        });
    }

    @Override
    public void addGroupManager(String manager, String groupName) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Account account = sm.getAccount(manager);
            Group group = sm.getGroup(groupName);
            group.addManager(account);
            sm.updateGroup(group);
            return null;
        });
    }

    @Override
    public void removeGroupManager(String groupName, String manager) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Group group = sm.getGroup(groupName);
            Account account = sm.getAccount(manager);
            group.removeManager(account);
            sm.updateGroup(group);
            return null;
        });
    }

    @Override
    public void addUserGroup(Account user) throws XMLDBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeGroupMember(String group, String member) throws XMLDBException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Account account = sm.getAccount(member);
            account.remGroup(group);
            sm.updateAccount(account);
            return null;
        });
    }

    @Override
    public void addUser(User user) throws XMLDBException {
        UserAider account = new UserAider(user.getName());
        this.addAccount(account);
    }

    @Override
    public void updateUser(User user) throws XMLDBException {
        UserAider account = new UserAider(user.getName());
        account.setPassword(user.getPassword());
        this.updateAccount(account);
    }

    @Override
    public User getUser(String name) throws XMLDBException {
        return this.getAccount(name);
    }

    @Override
    public User[] getUsers() throws XMLDBException {
        return null;
    }

    @Override
    public void removeUser(User user) throws XMLDBException {
    }

    @Override
    public void lockResource(Resource res, User u) throws XMLDBException {
        UserAider account = new UserAider(u.getName());
        this.lockResource(res, account);
    }

    @Override
    public String getProperty(String property) throws XMLDBException {
        return null;
    }

    @Override
    public void setProperty(String property, String value) throws XMLDBException {
    }

    private <R> FunctionE<FunctionE<SecurityManager, LocalXmldbFunction<R>, XMLDBException>, R, XMLDBException> onlyAsAdmin(Subject user) throws XMLDBException {
        SecurityManager manager = this.brokerPool.getSecurityManager();
        if (!manager.hasAdminPrivileges(user)) {
            throw new XMLDBException(4, " This operation is restricted to Admin users");
        }
        return op -> op.andThen(this::withDb).apply((Object)manager);
    }

    private <R> FunctionE<LocalXmldbDocumentFunction<R>, R, XMLDBException> modify(Resource resource) throws XMLDBException {
        return modifyOp -> this.withDb((broker, transaction) -> ((AbstractEXistResource)resource).modify(broker, transaction).apply(modifyOp));
    }

    private <R> FunctionE<LocalXmldbCollectionFunction<R>, R, XMLDBException> updateCollection(XmldbURI collectionUri) throws XMLDBException {
        return updateOp -> this.modify(collectionUri).apply((collection, broker1, transaction1) -> {
            Object result = updateOp.apply(collection, broker1, transaction1);
            broker1.saveCollection(transaction1, collection);
            return result;
        });
    }
}

