/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.xml.transform.TransformerException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.exist.dom.memtree.AttrImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.XMLUtil;
import org.exist.numbering.NodeId;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.Txn;
import org.exist.util.MimeType;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.DOMStreamer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class LocalXMLResource
extends AbstractEXistResource
implements XMLResource {
    private NodeProxy proxy = null;
    private Properties outputProperties;
    private LexicalHandler lexicalHandler = null;
    protected String content = null;
    protected Path file = null;
    protected InputSource inputSource = null;
    protected Node root = null;
    protected AtomicValue value = null;

    public LocalXMLResource(Subject user, BrokerPool brokerPool, LocalCollection parent, XmldbURI did) throws XMLDBException {
        super(user, brokerPool, parent, did, MimeType.XML_TYPE.getName());
        this.outputProperties = parent != null ? parent.getProperties() : null;
    }

    public LocalXMLResource(Subject user, BrokerPool brokerPool, LocalCollection parent, NodeProxy p) throws XMLDBException {
        this(user, brokerPool, parent, p.getOwnerDocument().getFileURI());
        this.proxy = p;
        this.outputProperties = parent != null ? parent.getProperties() : null;
    }

    public String getDocumentId() throws XMLDBException {
        return this.docId.toString();
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContent() throws XMLDBException {
        if (this.content != null) {
            return this.content;
        }
        if (this.root != null && !(this.root instanceof NodeValue)) {
            try (StringWriter writer = new StringWriter();){
                DOMSerializer serializer = new DOMSerializer(writer, this.getProperties());
                try {
                    serializer.serialize(this.root);
                    this.content = writer.toString();
                }
                catch (TransformerException e) {
                    throw new XMLDBException(301, e.getMessage(), (Throwable)e);
                }
                String string = this.content;
                return string;
            }
            catch (IOException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
        }
        if (this.value != null) {
            try {
                if (!Type.subTypeOf(this.value.getType(), 22)) return this.value.getStringValue();
                return ((StringValue)this.value).getStringValue(true);
            }
            catch (XPathException e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
        }
        if (this.file != null) {
            try {
                this.content = XMLUtil.readFile(this.file);
                return this.content;
            }
            catch (IOException e) {
                throw new XMLDBException(1, "error while reading resource contents", (Throwable)e);
            }
        }
        if (this.inputSource == null) {
            this.content = this.withDb((broker, transaction) -> {
                Serializer serializer = broker.newSerializer();
                serializer.setUser(this.user);
                try {
                    serializer.setProperties(this.getProperties());
                    if (this.root != null) {
                        return serializer.serialize((NodeValue)((Object)this.root));
                    }
                    if (this.proxy != null) {
                        return serializer.serialize(this.proxy);
                    }
                    return (String)this.read(broker, transaction).apply((document, broker1, transaction1) -> {
                        try {
                            return serializer.serialize(document);
                        }
                        catch (SAXException e) {
                            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                        }
                    });
                }
                catch (SAXException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
            });
            return this.content;
        }
        try {
            this.content = XMLUtil.readFile(this.inputSource);
            return this.content;
        }
        catch (IOException e) {
            throw new XMLDBException(1, "error while reading resource contents", (Throwable)e);
        }
    }

    public Node getContentAsDOM() throws XMLDBException {
        Node result;
        if (this.root != null) {
            if (this.root instanceof NodeImpl) {
                this.withDb((broker, transaction) -> {
                    ((NodeImpl)this.root).expand();
                    return null;
                });
            }
            result = this.root;
        } else {
            if (this.value != null) {
                throw new XMLDBException(1, "cannot return an atomic value as DOM node");
            }
            result = this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> {
                if (this.proxy != null) {
                    return document.getNode(this.proxy);
                }
                return document;
            });
        }
        return this.exportInternalNode(result);
    }

    private Node exportInternalNode(final Node node) {
        Optional<Class<? extends Node>> domClazz = this.getW3cNodeInterface(node.getClass());
        if (!domClazz.isPresent()) {
            throw new IllegalArgumentException("Provided node does not implement org.w3c.dom");
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(domClazz.get());
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                Object domResult = method.invoke((Object)node, args);
                if (domResult != null && Node.class.isAssignableFrom(method.getReturnType())) {
                    return LocalXMLResource.this.exportInternalNode((Node)domResult);
                }
                if (domResult != null && method.getReturnType().equals(NodeList.class)) {
                    final NodeList underlying = (NodeList)domResult;
                    return new NodeList(){

                        @Override
                        public Node item(int index) {
                            return Optional.ofNullable(underlying.item(index)).map(n -> LocalXMLResource.this.exportInternalNode(n)).orElse(null);
                        }

                        @Override
                        public int getLength() {
                            return underlying.getLength();
                        }
                    };
                }
                return domResult;
            }
        });
        return (Node)enhancer.create();
    }

    private Optional<Class<? extends Node>> getW3cNodeInterface(Class<? extends Node> nodeClazz) {
        return Stream.of(nodeClazz.getInterfaces()).filter(iface -> iface.getPackage().getName().equals("org.w3c.dom")).findFirst().map(c -> c);
    }

    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        if (this.root != null && !(this.root instanceof NodeValue)) {
            try {
                String option = this.collection.getProperty("sax-document-events", "false");
                DOMStreamer streamer = (DOMStreamer)SerializerPool.getInstance().borrowObject(DOMStreamer.class);
                streamer.setContentHandler(handler);
                streamer.setLexicalHandler(this.lexicalHandler);
                streamer.serialize(this.root, option.equalsIgnoreCase("true"));
                SerializerPool.getInstance().returnObject(streamer);
            }
            catch (Exception e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
        } else {
            this.withDb((broker, transaction) -> {
                try {
                    if (this.value != null) {
                        this.value.toSAX(broker, handler, this.getProperties());
                    } else {
                        Serializer serializer = broker.newSerializer();
                        serializer.setUser(this.user);
                        serializer.setProperties(this.getProperties());
                        serializer.setSAXHandlers(handler, this.lexicalHandler);
                        if (this.root != null) {
                            serializer.toSAX((NodeValue)((Object)this.root));
                        } else if (this.proxy != null) {
                            serializer.toSAX(this.proxy);
                        } else {
                            this.read(broker, transaction).apply((document, broker1, transaction1) -> {
                                try {
                                    serializer.toSAX(document);
                                    return null;
                                }
                                catch (SAXException e) {
                                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                                }
                            });
                        }
                    }
                    return null;
                }
                catch (SAXException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    public void setContent(Object obj) throws XMLDBException {
        this.content = null;
        this.file = null;
        this.value = null;
        this.inputSource = null;
        this.root = null;
        if (obj instanceof Path) {
            this.file = (Path)obj;
        } else if (obj instanceof File) {
            this.file = ((File)obj).toPath();
        } else if (obj instanceof AtomicValue) {
            this.value = (AtomicValue)obj;
        } else if (obj instanceof InputSource) {
            this.inputSource = (InputSource)obj;
        } else {
            this.content = obj instanceof byte[] ? new String((byte[])obj, StandardCharsets.UTF_8) : obj.toString();
        }
    }

    public void setContentAsDOM(Node root) throws XMLDBException {
        if (root instanceof AttrImpl) {
            throw new XMLDBException(3, "SENR0001: can not serialize a standalone attribute");
        }
        this.content = null;
        this.file = null;
        this.value = null;
        this.inputSource = null;
        this.root = root;
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        this.file = null;
        this.value = null;
        this.inputSource = null;
        this.root = null;
        return new InternalXMLSerializer();
    }

    @Override
    public void freeResources() throws XMLDBException {
    }

    public boolean getSAXFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setSAXFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    @Override
    public void setProperties(Properties properties) {
        this.outputProperties = properties;
    }

    @Override
    @Nullable
    public Properties getProperties() {
        return this.outputProperties;
    }

    public NodeProxy getNode() throws XMLDBException {
        if (this.proxy != null) {
            return this.proxy;
        }
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> new NodeProxy(document, NodeId.DOCUMENT_NODE));
    }

    @Override
    public DocumentType getDocType() throws XMLDBException {
        return this.read((DocumentImpl document, DBBroker broker, Txn transaction) -> document.getDoctype());
    }

    @Override
    public void setDocType(DocumentType doctype) throws XMLDBException {
        this.modify((DocumentImpl document, DBBroker broker, Txn transaction) -> {
            if (document == null) {
                throw new XMLDBException(301, "Resource " + this.docId + " not found");
            }
            document.setDocumentType(doctype);
            return null;
        });
    }

    private class InternalXMLSerializer
    extends SAXSerializer {
        public InternalXMLSerializer() {
            super(new StringWriter(), null);
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            LocalXMLResource.this.content = this.getWriter().toString();
        }
    }
}

