/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import org.exist.util.EXistInputSource;
import org.exist.util.MimeType;
import org.exist.xmldb.AbstractRemoteResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.DocumentType;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;

public class RemoteBinaryResource
extends AbstractRemoteResource
implements BinaryResource {
    private String type = null;
    private byte[] content = null;

    public RemoteBinaryResource(RemoteCollection parent, XmldbURI documentName) throws XMLDBException {
        super(parent, documentName, MimeType.BINARY_TYPE.getName());
    }

    public RemoteBinaryResource(RemoteCollection parent, XmldbURI documentName, String type, byte[] content) throws XMLDBException {
        super(parent, documentName, MimeType.BINARY_TYPE.getName());
        this.type = type;
        this.content = content;
    }

    public String getId() throws XMLDBException {
        return this.path.lastSegment().toString();
    }

    public String getResourceType() throws XMLDBException {
        return "BinaryResource";
    }

    @Override
    public Object getExtendedContent() throws XMLDBException {
        return this.getExtendedContentInternal(this.content, false, -1, -1);
    }

    @Override
    public long getStreamLength() throws XMLDBException {
        return this.getStreamLengthInternal(this.content);
    }

    @Override
    public InputStream getStreamContent() throws XMLDBException {
        return this.getStreamContentInternal(this.content, false, -1, -1);
    }

    @Override
    public void getContentIntoAStream(OutputStream os) throws XMLDBException {
        this.getContentIntoAStreamInternal(os, this.content, false, -1, -1);
    }

    protected String getStreamSymbolicPath() {
        String retval = "<streamunknown>";
        if (this.vfile != null) {
            Object content = this.vfile.getContent();
            if (content instanceof File) {
                retval = ((File)content).getAbsolutePath();
            }
        } else if (this.inputSource != null && this.inputSource instanceof EXistInputSource) {
            retval = ((EXistInputSource)this.inputSource).getSymbolicPath();
        }
        return retval;
    }

    public void setContent(Object obj) throws XMLDBException {
        if (!super.setContentInternal(obj)) {
            throw new XMLDBException(1, "don't know how to handle value of type " + obj.getClass().getName());
        }
    }

    @Override
    public void setLexicalHandler(LexicalHandler handler) {
    }

    @Override
    public DocumentType getDocType() throws XMLDBException {
        return null;
    }

    @Override
    public void setDocType(DocumentType doctype) throws XMLDBException {
    }

    @Override
    @Nullable
    public void setProperties(Properties properties) {
    }
}

