/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.exist.xmldb.AbstractRemote;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteCollectionManagementService
extends AbstractRemote
implements EXistCollectionManagementService {
    final XmlRpcClient client;

    public RemoteCollectionManagementService(RemoteCollection parent, XmlRpcClient client) {
        super(parent);
        this.client = client;
    }

    public String getName() throws XMLDBException {
        return "CollectionManagementService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    @Override
    @Deprecated
    public Collection createCollection(String collName) throws XMLDBException {
        return this.createCollection(collName, (Date)null);
    }

    @Override
    public Collection createCollection(XmldbURI collName) throws XMLDBException {
        return this.createCollection(collName, null);
    }

    @Override
    @Deprecated
    public Collection createCollection(String collName, Date created) throws XMLDBException {
        try {
            return this.createCollection(XmldbURI.xmldbUriFor(collName), created);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public Collection createCollection(XmldbURI name, Date created) throws XMLDBException {
        XmldbURI collName = this.resolve(name);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(collName.toString());
        if (created != null) {
            params.add(created);
        }
        try {
            this.client.execute("createCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        return this.collection.getChildCollection(collName);
    }

    @Deprecated
    public Collection createCollection(String path, Document configuration) throws XMLDBException {
        return this.createCollection(path);
    }

    public String getProperty(String property) {
        return null;
    }

    @Override
    @Deprecated
    public void removeCollection(String collName) throws XMLDBException {
        try {
            this.removeCollection(XmldbURI.xmldbUriFor(collName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void removeCollection(XmldbURI name) throws XMLDBException {
        XmldbURI collName = this.resolve(name);
        ArrayList<String> params = new ArrayList<String>();
        params.add(collName.toString());
        try {
            this.client.execute("removeCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    public void setCollection(Collection parent) throws XMLDBException {
        this.collection = (RemoteCollection)parent;
    }

    public void setProperty(String name, String value) {
    }

    @Override
    @Deprecated
    public void move(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.move(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public void move(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        ArrayList<String> params = new ArrayList<String>();
        params.add(srcPath.toString());
        params.add(destPath.toString());
        params.add(newName.toString());
        try {
            this.client.execute("moveCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    @Deprecated
    public void moveResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.moveResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void moveResource(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        ArrayList<String> params = new ArrayList<String>();
        params.add(srcPath.toString());
        params.add(destPath.toString());
        params.add(newName.toString());
        try {
            this.client.execute("moveResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    @Deprecated
    public void copy(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copy(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void copy(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        ArrayList<String> params = new ArrayList<String>();
        params.add(srcPath.toString());
        params.add(destPath.toString());
        params.add(newName.toString());
        try {
            this.client.execute("copyCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    @Deprecated
    public void copyResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copyResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    @Override
    public void copyResource(XmldbURI src, XmldbURI dest, XmldbURI name) throws XMLDBException {
        XmldbURI srcPath = this.resolve(src);
        XmldbURI destPath = dest == null ? srcPath.removeLastSegment() : this.resolve(dest);
        XmldbURI newName = name == null ? srcPath.lastSegment() : name;
        ArrayList<String> params = new ArrayList<String>();
        params.add(srcPath.toString());
        params.add(destPath.toString());
        params.add(newName.toString());
        try {
            this.client.execute("copyResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    public void runCommand(String[] cmdParams) throws XMLDBException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.collection.getPathURI());
        params.add(cmdParams);
        try {
            this.client.execute("runCommand", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }
}

