/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.DatabaseStatus;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteDatabaseInstanceManager
implements DatabaseInstanceManager {
    private final XmlRpcClient client;

    public RemoteDatabaseInstanceManager(XmlRpcClient client) {
        this.client = client;
    }

    public String getName() throws XMLDBException {
        return "DatabaseInstanceManager";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    @Override
    public boolean isLocalInstance() {
        return false;
    }

    @Override
    public void shutdown() throws XMLDBException {
        try {
            this.client.execute("shutdown", Collections.EMPTY_LIST);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "shutdown failed", (Throwable)e);
        }
    }

    @Override
    public void shutdown(long delay) throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>();
        if (delay > 0L) {
            params.add(Long.valueOf(delay).toString());
        }
        try {
            this.client.execute("shutdown", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "shutdown failed", (Throwable)e);
        }
    }

    @Override
    public boolean enterServiceMode() throws XMLDBException {
        try {
            this.client.execute("enterServiceMode", Collections.EMPTY_LIST);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "Failed to switch db to service mode: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public void exitServiceMode() throws XMLDBException {
        try {
            this.client.execute("exitServiceMode", Collections.EMPTY_LIST);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "Failed to switch db to service mode: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setCollection(Collection collection) throws XMLDBException {
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }

    @Override
    public DatabaseStatus getStatus() throws XMLDBException {
        throw new XMLDBException(2, "this method is not available for remote connections");
    }
}

