/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.util.MimeType;
import org.exist.util.VirtualTempFile;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.AbstractRemoteResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class RemoteXMLResource
extends AbstractRemoteResource
implements XMLResource {
    protected static final Logger LOG = LogManager.getLogger(RemoteXMLResource.class);
    private XMLReader xmlReader = null;
    private final Optional<String> id;
    private final int handle;
    private int pos = -1;
    private String content = null;
    private Properties outputProperties = null;
    private LexicalHandler lexicalHandler = null;

    public RemoteXMLResource(RemoteCollection parent, XmldbURI docId, Optional<String> id) throws XMLDBException {
        this(parent, -1, -1, docId, id);
    }

    public RemoteXMLResource(RemoteCollection parent, int handle, int pos, XmldbURI docId, Optional<String> id) throws XMLDBException {
        super(parent, docId, MimeType.XML_TYPE.getName());
        this.handle = handle;
        this.pos = pos;
        this.id = id;
    }

    public String getId() throws XMLDBException {
        return this.id.map(x -> x.equals("1") ? this.getDocumentId() : this.getDocumentId() + '_' + this.id).orElse(this.getDocumentId());
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    @Override
    @Nullable
    public Properties getProperties() {
        return this.outputProperties == null ? super.getProperties() : this.outputProperties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.outputProperties = properties;
    }

    public String getDocumentId() {
        return this.path.lastSegment().toString();
    }

    @Override
    public Object getContent() throws XMLDBException {
        if (this.content != null) {
            return new StringValue(this.content).getStringValue(true);
        }
        Object res = super.getContent();
        if (res != null) {
            if (res instanceof byte[]) {
                return new String((byte[])res, StandardCharsets.UTF_8);
            }
            return res;
        }
        return null;
    }

    public Node getContentAsDOM() throws XMLDBException {
        InputStream cis = null;
        try {
            Document doc;
            InputSource is;
            if (this.content != null) {
                is = new InputSource(new StringReader(this.content));
            } else {
                cis = this.getStreamContent();
                is = new InputSource(cis);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = doc = builder.parse(is);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException ioe) {
                    LOG.warn(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        InputStream cis = null;
        try {
            InputSource is;
            if (this.content != null) {
                is = new InputSource(new StringReader(this.content));
            } else {
                cis = this.getStreamContent();
                is = new InputSource(cis);
            }
            XMLReader reader = this.xmlReader;
            if (reader == null) {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                saxFactory.setNamespaceAware(true);
                saxFactory.setValidating(false);
                SAXParser sax = saxFactory.newSAXParser();
                reader = sax.getXMLReader();
            }
            reader.setContentHandler(handler);
            if (this.lexicalHandler != null) {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
            }
            reader.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException ioe) {
                    LOG.warn(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public Object getExtendedContent() throws XMLDBException {
        return this.getExtendedContentInternal(this.content, this.idIsPresent(), this.handle, this.pos);
    }

    public void setContent(Object value) throws XMLDBException {
        this.content = null;
        if (!super.setContentInternal(value)) {
            this.content = value instanceof String ? (String)value : (value instanceof byte[] ? new String((byte[])value, StandardCharsets.UTF_8) : value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentAsDOM(Node root) throws XMLDBException {
        try {
            VirtualTempFile vtmpfile;
            block22: {
                vtmpfile = new VirtualTempFile();
                vtmpfile.setTempPrefix("eXistRXR");
                vtmpfile.setTempPostfix(".xml");
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)vtmpfile, "UTF-8");){
                    DOMSerializer xmlout = new DOMSerializer(osw, this.getProperties());
                    short type = root.getNodeType();
                    if (type == 1 || type == 11 || type == 9) {
                        xmlout.serialize(root);
                        break block22;
                    }
                    throw new XMLDBException(1, "invalid node type");
                }
                finally {
                    try {
                        vtmpfile.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
            this.setContent(vtmpfile);
        }
        catch (IOException | TransformerException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        this.freeResources();
        this.content = null;
        return new InternalXMLSerializer();
    }

    public boolean idIsPresent() {
        return this.id.isPresent();
    }

    public String getNodeId() {
        return this.id.orElse("1");
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public boolean getSAXFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setSAXFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    @Override
    public DocumentType getDocType() throws XMLDBException {
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(this.path.toString());
        try {
            Object[] request = (Object[])this.collection.getClient().execute("getDocType", params);
            DocumentTypeImpl result = !"".equals(request[0]) ? new DocumentTypeImpl((String)request[0], (String)request[1], (String)request[2]) : null;
            return result;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setDocType(DocumentType doctype) throws XMLDBException {
        if (doctype != null) {
            ArrayList<String> params = new ArrayList<String>(4);
            params.add(this.path.toString());
            params.add(doctype.getName());
            params.add(doctype.getPublicId() == null ? "" : doctype.getPublicId());
            params.add(doctype.getSystemId() == null ? "" : doctype.getSystemId());
            try {
                this.collection.getClient().execute("setDocType", params);
            }
            catch (XmlRpcException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void getContentIntoAStream(OutputStream os) throws XMLDBException {
        this.getContentIntoAStreamInternal(os, this.content, this.idIsPresent(), this.handle, this.pos);
    }

    @Override
    public InputStream getStreamContent() throws XMLDBException {
        return this.getStreamContentInternal(this.content, this.idIsPresent(), this.handle, this.pos);
    }

    @Override
    public long getStreamLength() throws XMLDBException {
        return this.getStreamLengthInternal(this.content);
    }

    private class InternalXMLSerializer
    extends SAXSerializer {
        VirtualTempFile vtmpfile = null;
        OutputStreamWriter writer = null;

        @Override
        public void startDocument() throws SAXException {
            try {
                this.vtmpfile = new VirtualTempFile();
                this.vtmpfile.setTempPrefix("eXistRXR");
                this.vtmpfile.setTempPostfix(".xml");
                this.writer = new OutputStreamWriter((OutputStream)this.vtmpfile, "UTF-8");
                this.setOutput(this.writer, new Properties());
            }
            catch (IOException ioe) {
                throw new SAXException("Unable to create temp file for serialization data", ioe);
            }
            super.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.vtmpfile != null) {
                    this.vtmpfile.close();
                }
                RemoteXMLResource.this.setContent(this.vtmpfile);
            }
            catch (IOException | XMLDBException e) {
                throw new SAXException("Unable to set file content containing serialized data", (Exception)e);
            }
        }
    }
}

