/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.source.Source;
import org.exist.xmldb.AbstractRemote;
import org.exist.xmldb.AbstractRemoteResource;
import org.exist.xmldb.EXistXPathQueryService;
import org.exist.xmldb.EXistXQueryService;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteCompiledExpression;
import org.exist.xmldb.RemoteResourceSet;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xquery.XPathException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class RemoteXPathQueryService
extends AbstractRemote
implements EXistXPathQueryService,
EXistXQueryService {
    private final Map<String, String> namespaceMappings = new HashMap<String, String>();
    private final Map<String, Object> variableDecls = new HashMap<String, Object>();
    private final Properties outputProperties;
    private String moduleLoadPath = null;
    private boolean protectedMode = false;

    public RemoteXPathQueryService(RemoteCollection collection) {
        super(collection);
        this.outputProperties = collection.getProperties();
    }

    public String getName() throws XMLDBException {
        return "XPathQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    @Override
    public ResourceSet query(String query) throws XMLDBException {
        return this.query(query, null);
    }

    @Override
    public ResourceSet query(String query, String sortExpr) throws XMLDBException {
        try {
            HashMap<String, Object> optParams = new HashMap<String, Object>();
            if (sortExpr != null) {
                optParams.put("sort-expr", sortExpr);
            }
            if (this.namespaceMappings.size() > 0) {
                optParams.put("namespaces", this.namespaceMappings);
            }
            if (this.variableDecls.size() > 0) {
                optParams.put("variables", this.variableDecls);
            }
            optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
            if (this.moduleLoadPath != null) {
                optParams.put("module-load-path", this.moduleLoadPath);
            }
            if (this.protectedMode) {
                optParams.put("protected", this.collection.getPath());
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(query.getBytes(StandardCharsets.UTF_8));
            params.add(optParams);
            Map result = (Map)this.collection.getClient().execute("queryPT", params);
            if (result.get("error") != null) {
                this.throwException(result);
            }
            Object[] resources = (Object[])result.get("results");
            int handle = -1;
            int hash = -1;
            if (resources != null && resources.length > 0) {
                handle = (Integer)result.get("id");
                hash = (Integer)result.get("hash");
            }
            return new RemoteResourceSet(this.collection, this.outputProperties, resources, handle, hash);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    public CompiledExpression compile(String query) throws XMLDBException {
        try {
            return this.compileAndCheck(query);
        }
        catch (XPathException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public CompiledExpression compileAndCheck(String query) throws XMLDBException, XPathException {
        try {
            HashMap<String, Object> optParams = new HashMap<String, Object>();
            if (this.namespaceMappings.size() > 0) {
                optParams.put("namespaces", this.namespaceMappings);
            }
            if (this.variableDecls.size() > 0) {
                optParams.put("variables", this.variableDecls);
            }
            if (this.moduleLoadPath != null) {
                optParams.put("module-load-path", this.moduleLoadPath);
            }
            optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(query.getBytes(StandardCharsets.UTF_8));
            params.add(optParams);
            Map result = (Map)this.collection.getClient().execute("compile", params);
            if (result.get("error") != null) {
                this.throwXPathException(result);
            }
            return new RemoteCompiledExpression(query);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    private void throwException(Map result) throws XMLDBException {
        String message = (String)result.get("error");
        Integer lineInt = (Integer)result.get("line");
        Integer columnInt = (Integer)result.get("column");
        int line = lineInt == null ? 0 : lineInt;
        int column = columnInt == null ? 0 : columnInt;
        XPathException cause = new XPathException(line, column, message);
        throw new XMLDBException(1, message, (Throwable)cause);
    }

    private void throwXPathException(Map result) throws XPathException {
        String message = (String)result.get("error");
        Integer lineInt = (Integer)result.get("line");
        Integer columnInt = (Integer)result.get("column");
        int line = lineInt == null ? 0 : lineInt;
        int column = columnInt == null ? 0 : columnInt;
        throw new XPathException(line, column, message);
    }

    @Override
    public ResourceSet execute(Source source) throws XMLDBException {
        try {
            String xq = source.getContent();
            return this.query(xq, null);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ResourceSet executeStoredQuery(String uri) throws XMLDBException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(uri);
        params.add(new HashMap());
        try {
            Map result = (Map)this.collection.getClient().execute("executeT", params);
            if (result.get("error") != null) {
                this.throwException(result);
            }
            Object[] resources = (Object[])result.get("results");
            int handle = -1;
            int hash = -1;
            if (resources != null && resources.length > 0) {
                handle = (Integer)result.get("id");
                hash = (Integer)result.get("hash");
            }
            return new RemoteResourceSet(this.collection, this.outputProperties, resources, handle, hash);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    @Override
    public ResourceSet query(XMLResource res, String query) throws XMLDBException {
        return this.query(res, query, null);
    }

    @Override
    public ResourceSet query(XMLResource res, String query, String sortExpr) throws XMLDBException {
        RemoteXMLResource resource = (RemoteXMLResource)res;
        try {
            HashMap<String, Object> optParams = new HashMap<String, Object>();
            if (this.namespaceMappings.size() > 0) {
                optParams.put("namespaces", this.namespaceMappings);
            }
            if (this.variableDecls.size() > 0) {
                optParams.put("variables", this.variableDecls);
            }
            if (sortExpr != null) {
                optParams.put("sort-expr", sortExpr);
            }
            if (this.moduleLoadPath != null) {
                optParams.put("module-load-path", this.moduleLoadPath);
            }
            optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
            if (this.protectedMode) {
                optParams.put("protected", this.collection.getPath());
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(query.getBytes(StandardCharsets.UTF_8));
            params.add(resource.path.toString());
            params.add(resource.idIsPresent() ? resource.getNodeId() : "");
            params.add(optParams);
            Map result = (Map)this.collection.getClient().execute("queryPT", params);
            if (result.get("error") != null) {
                this.throwException(result);
            }
            Object[] resources = (Object[])result.get("results");
            int handle = -1;
            int hash = -1;
            if (resources != null && resources.length > 0) {
                handle = (Integer)result.get("id");
                hash = (Integer)result.get("hash");
            }
            return new RemoteResourceSet(this.collection, this.outputProperties, resources, handle, hash);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceSet queryResource(String resource, String query) throws XMLDBException {
        Resource res = this.collection.getResource(resource);
        try {
            if (res == null) {
                throw new XMLDBException(301, "Resource " + resource + " not found");
            }
            if (!"XMLResource".equals(res.getResourceType())) {
                throw new XMLDBException(301, "Resource " + resource + " is not an XML resource");
            }
            ResourceSet resourceSet = this.query((XMLResource)res, query);
            return resourceSet;
        }
        finally {
            if (res != null && res instanceof AbstractRemoteResource) {
                ((AbstractRemoteResource)res).freeResources();
            }
        }
    }

    public void setCollection(Collection collection) throws XMLDBException {
    }

    public String getProperty(String name) throws XMLDBException {
        return this.outputProperties.getProperty(name);
    }

    public void setProperty(String property, String value) throws XMLDBException {
        this.outputProperties.setProperty(property, value);
    }

    public void clearNamespaces() throws XMLDBException {
        this.namespaceMappings.clear();
    }

    @Override
    public void removeNamespace(String ns) throws XMLDBException {
        Iterator<String> i = this.namespaceMappings.values().iterator();
        while (i.hasNext()) {
            if (!i.next().equals(ns)) continue;
            i.remove();
        }
    }

    @Override
    public void setNamespace(String prefix, String namespace) throws XMLDBException {
        this.namespaceMappings.put(prefix != null ? prefix : "", namespace);
    }

    @Override
    public String getNamespace(String prefix) throws XMLDBException {
        return this.namespaceMappings.get(prefix != null ? prefix : "");
    }

    @Override
    public void declareVariable(String qname, Object initialValue) throws XMLDBException {
        this.variableDecls.put(qname, initialValue);
    }

    @Override
    public void clearVariables() throws XMLDBException {
        this.variableDecls.clear();
    }

    @Override
    public ResourceSet execute(CompiledExpression expression) throws XMLDBException {
        return this.query(((RemoteCompiledExpression)expression).getQuery());
    }

    @Override
    public ResourceSet execute(XMLResource res, CompiledExpression expression) throws XMLDBException {
        return this.query(res, ((RemoteCompiledExpression)expression).getQuery());
    }

    @Override
    public void setXPathCompatibility(boolean backwardsCompatible) {
    }

    @Override
    public void setModuleLoadPath(String path) {
        this.moduleLoadPath = path;
    }

    @Override
    public void dump(CompiledExpression expression, Writer writer) throws XMLDBException {
        String query = ((RemoteCompiledExpression)expression).getQuery();
        HashMap<String, Object> optParams = new HashMap<String, Object>();
        if (this.namespaceMappings.size() > 0) {
            optParams.put("namespaces", this.namespaceMappings);
        }
        if (this.variableDecls.size() > 0) {
            optParams.put("variables", this.variableDecls);
        }
        optParams.put("base-uri", this.outputProperties.getProperty("base-uri", this.collection.getPath()));
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(query);
        params.add(optParams);
        try {
            String dump = (String)this.collection.getClient().execute("printDiagnostics", params);
            writer.write(dump);
        }
        catch (IOException | XmlRpcException e) {
            throw new XMLDBException(0, e.getMessage(), e);
        }
    }

    @Override
    public void beginProtected() {
        this.protectedMode = true;
    }

    @Override
    public void endProtected() {
        this.protectedMode = false;
    }
}

