/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb.function;

import com.evolvedbinary.j8fu.function.BiFunctionE;
import java.io.IOException;
import org.exist.EXistException;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xquery.XPathException;
import org.xmldb.api.base.XMLDBException;

@FunctionalInterface
public interface LocalXmldbFunction<R>
extends BiFunctionE<DBBroker, Txn, R, XMLDBException> {
    default public R apply(DBBroker broker, Txn transaction) throws XMLDBException {
        try {
            return this.applyXmldb(broker, transaction);
        }
        catch (PermissionDeniedException e) {
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        catch (EXistException | XPathException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public R applyXmldb(DBBroker var1, Txn var2) throws XMLDBException, PermissionDeniedException, IOException, XPathException, EXistException;
}

