/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xmlrpc.AbstractCachedResult;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.Sequence;

public class QueryResult
extends AbstractCachedResult {
    private static final Logger LOG = LogManager.getLogger(QueryResult.class);
    protected Sequence result;
    protected Properties serialization = null;
    protected XPathException exception = null;

    public QueryResult(Sequence result, Properties outputProperties) {
        this(result, outputProperties, 0L);
    }

    public QueryResult(Sequence result, Properties outputProperties, long queryTime) {
        super(queryTime);
        this.serialization = outputProperties;
        this.result = result;
    }

    public QueryResult(XPathException e) {
        this.exception = e;
    }

    public boolean hasErrors() {
        return this.exception != null;
    }

    public XPathException getException() {
        return this.exception;
    }

    @Override
    public Sequence getResult() {
        return this.result;
    }

    @Override
    public void free() {
        if (this.result != null) {
            if (this.result instanceof BinaryValue) {
                try {
                    ((BinaryValue)this.result).close();
                }
                catch (IOException ioe) {
                    LOG.warn("Unable to cleanup BinaryValue: " + this.result.hashCode(), (Throwable)ioe);
                }
            }
            this.result = null;
        }
    }
}

