/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import com.evolvedbinary.j8fu.function.ConsumerE;
import com.evolvedbinary.j8fu.function.Function2E;
import com.evolvedbinary.j8fu.function.Function3E;
import com.evolvedbinary.j8fu.function.SupplierE;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.Version;
import org.exist.backup.Backup;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.IndexInfo;
import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.SortedNodeSet;
import org.exist.numbering.NodeId;
import org.exist.plugin.command.Commands;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.scheduler.impl.ShutdownTask;
import org.exist.scheduler.impl.SystemTaskJobImpl;
import org.exist.security.ACLPermission;
import org.exist.security.AXSchemaType;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.security.SchemaType;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.aider.ACEAider;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.DataBackup;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.Txn;
import org.exist.util.Compressor;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.Occurrences;
import org.exist.util.SyntaxException;
import org.exist.util.VirtualTempFile;
import org.exist.util.VirtualTempFileInputSource;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.validation.ValidationReport;
import org.exist.validation.Validator;
import org.exist.xmldb.XmldbURI;
import org.exist.xmlrpc.QueryResult;
import org.exist.xmlrpc.RpcAPI;
import org.exist.xmlrpc.SerializedResult;
import org.exist.xmlrpc.XmldbRequestProcessorFactory;
import org.exist.xmlrpc.function.XmlRpcCollectionFunction;
import org.exist.xmlrpc.function.XmlRpcCompiledXQueryFunction;
import org.exist.xmlrpc.function.XmlRpcDocumentFunction;
import org.exist.xmlrpc.function.XmlRpcFunction;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Option;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.HTTPUtils;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.base.XMLDBException;

public class RpcConnection
implements RpcAPI {
    private static final Logger LOG = LogManager.getLogger(RpcConnection.class);
    private static final int MAX_DOWNLOAD_CHUNK_SIZE = 262144;
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private final XmldbRequestProcessorFactory factory;
    private final Subject user;

    public RpcConnection(XmldbRequestProcessorFactory factory, Subject user) {
        this.factory = factory;
        this.user = user;
    }

    @Override
    public String getVersion() {
        return Version.getVersion();
    }

    @Override
    public boolean createCollection(String name) throws EXistException, PermissionDeniedException {
        return this.createCollection(name, null);
    }

    @Override
    public boolean createCollection(String name, Date created) throws EXistException, PermissionDeniedException {
        try {
            return this.createCollection(XmldbURI.xmldbUriFor(name), created);
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private boolean createCollection(XmldbURI collUri, Date created) throws PermissionDeniedException, EXistException {
        this.withDb((broker, transaction) -> {
            Collection current = broker.getCollection(collUri);
            if (current != null) {
                return true;
            }
            current = broker.getOrCreateCollection(transaction, collUri);
            if (created != null) {
                current.setCreationTime(created.getTime());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("creating collection " + collUri);
            }
            broker.saveCollection(transaction, current);
            return null;
        });
        LOG.info("collection " + collUri + " has been created");
        return true;
    }

    @Override
    public boolean configureCollection(String collName, String configuration) throws EXistException, PermissionDeniedException {
        try {
            return this.configureCollection(XmldbURI.xmldbUriFor(collName), configuration);
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private boolean configureCollection(XmldbURI collUri, String configuration) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            Collection colRef = (Collection)this.readCollection(broker, transaction, collUri).apply((collection, broker1, transaction1) -> collection);
            CollectionConfigurationManager mgr = this.factory.getBrokerPool().getConfigurationManager();
            try {
                mgr.addConfiguration(transaction, broker, colRef, configuration);
            }
            catch (CollectionConfigurationException e) {
                throw new EXistException(e.getMessage());
            }
            return null;
        });
        LOG.info("Configured '" + collUri + "'");
        return true;
    }

    public String createId(String collName) throws EXistException, URISyntaxException, PermissionDeniedException {
        return this.createId(XmldbURI.xmldbUriFor(collName));
    }

    private String createId(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        return (String)this.readCollection(collUri).apply((collection, broker, transaction) -> {
            XmldbURI id;
            boolean ok;
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(broker, id)) {
                    ok = false;
                }
                if (!collection.hasChildCollection(broker, id)) continue;
                ok = false;
            } while (!ok);
            return id.toString();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResult doQuery(DBBroker broker, CompiledXQuery compiled, NodeSet contextSet, Map<String, Object> parameters) throws XPathException, EXistException, PermissionDeniedException {
        XQuery xquery = broker.getBrokerPool().getXQueryService();
        this.checkPragmas(compiled.getContext(), parameters);
        LockedDocumentMap lockedDocuments = null;
        try {
            long start = System.currentTimeMillis();
            lockedDocuments = this.beginProtected(broker, parameters);
            if (lockedDocuments != null) {
                compiled.getContext().setProtectedDocs(lockedDocuments);
            }
            Properties outputProperties = new Properties();
            Sequence result = xquery.execute(broker, compiled, (Sequence)contextSet, outputProperties);
            HTTPUtils.addLastModifiedHeader(result, compiled.getContext());
            LOG.info("query took " + (System.currentTimeMillis() - start) + "ms.");
            QueryResult queryResult = new QueryResult(result, outputProperties);
            return queryResult;
        }
        catch (XPathException e) {
            QueryResult queryResult = new QueryResult(e);
            return queryResult;
        }
        finally {
            if (lockedDocuments != null) {
                lockedDocuments.unlock();
            }
        }
    }

    protected LockedDocumentMap beginProtected(DBBroker broker, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        String protectColl = (String)parameters.get("protected");
        if (protectColl == null) {
            return null;
        }
        while (true) {
            DefaultDocumentSet docs = null;
            LockedDocumentMap lockedDocuments = new LockedDocumentMap();
            try {
                Collection coll = broker.getCollection(XmldbURI.createInternal(protectColl));
                docs = new DefaultDocumentSet();
                coll.allDocs(broker, docs, true, lockedDocuments, Lock.LockMode.WRITE_LOCK);
                return lockedDocuments;
            }
            catch (LockException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deadlock detected. Starting over again. Docs: " + docs.getDocumentCount() + "; locked: " + lockedDocuments.size());
                }
                lockedDocuments.unlock();
                continue;
            }
            break;
        }
    }

    @Deprecated
    private CompiledXQuery compile(DBBroker broker, Source source, Map<String, Object> parameters) throws XPathException, IOException, PermissionDeniedException {
        Object[] staticDocuments;
        Map variableDecls;
        Map namespaces;
        String moduleLoadPath;
        XQuery xquery = broker.getBrokerPool().getXQueryService();
        XQueryPool pool = broker.getBrokerPool().getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
        XQueryContext context = compiled == null ? new XQueryContext(broker.getBrokerPool()) : compiled.getContext();
        String base = (String)parameters.get("base-uri");
        if (base != null) {
            context.setBaseURI(new AnyURIValue(base));
        }
        if ((moduleLoadPath = (String)parameters.get("module-load-path")) != null) {
            context.setModuleLoadPath(moduleLoadPath);
        }
        if ((namespaces = (Map)parameters.get("namespaces")) != null && namespaces.size() > 0) {
            context.declareNamespaces(namespaces);
        }
        if ((variableDecls = (Map)parameters.get("variables")) != null) {
            for (Map.Entry entry : variableDecls.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("declaring " + (String)entry.getKey() + " = " + entry.getValue());
                }
                context.declareVariable((String)entry.getKey(), entry.getValue());
            }
        }
        if ((staticDocuments = (Object[])parameters.get("static-documents")) != null) {
            try {
                XmldbURI[] d = new XmldbURI[staticDocuments.length];
                for (int i = 0; i < staticDocuments.length; ++i) {
                    XmldbURI next;
                    d[i] = next = XmldbURI.xmldbUriFor((String)staticDocuments[i]);
                }
                context.setStaticallyKnownDocuments(d);
            }
            catch (URISyntaxException e) {
                throw new XPathException(e);
            }
        } else if (context.isBaseURIDeclared()) {
            context.setStaticallyKnownDocuments(new XmldbURI[]{context.getBaseURI().toXmldbURI()});
        }
        if (compiled == null) {
            compiled = xquery.compile(broker, context, source);
        }
        return compiled;
    }

    @Override
    public String printDiagnostics(String query, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        StringSource source = new StringSource(query);
        return this.withDb((broker, transaction) -> {
            try {
                return (String)this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> {
                    StringWriter writer = new StringWriter();
                    compiledQuery.dump(writer);
                    return writer.toString();
                });
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    protected void checkPragmas(XQueryContext context, Map<String, Object> parameters) throws XPathException {
        Option pragma = context.getOption(Option.SERIALIZE_QNAME);
        this.checkPragmas(pragma, parameters);
    }

    protected void checkPragmas(Option pragma, Map<String, Object> parameters) throws XPathException {
        String[] contents;
        if (pragma == null) {
            return;
        }
        for (String content : contents = pragma.tokenizeContents()) {
            String[] pair = Option.parseKeyValuePair(content);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().getStringValue() + ": '" + content + "'");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]);
            }
            parameters.put(pair[0], pair[1]);
        }
    }

    @Override
    public int executeQuery(byte[] xpath, String encoding, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        Charset charset = Optional.ofNullable(encoding).map(Charset::forName).orElse(DEFAULT_ENCODING);
        String xpathString = new String(xpath, charset);
        if (LOG.isDebugEnabled()) {
            LOG.debug("query: " + xpathString);
        }
        return this.executeQuery(xpathString, parameters);
    }

    @Override
    public int executeQuery(String xpath, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> {
            StringSource source = new StringSource(xpath);
            long startTime = System.currentTimeMillis();
            try {
                QueryResult result = (QueryResult)this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> this.doQuery(broker, compiledQuery, null, parameters));
                if (result.hasErrors()) {
                    throw new EXistException(result.getException());
                }
                result.queryTime = System.currentTimeMillis() - startTime;
                return this.factory.resultSets.add(result);
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    protected String formatErrorMsg(String message) {
        return this.formatErrorMsg("error", message);
    }

    protected String formatErrorMsg(String type, String message) {
        return "<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" hitCount=\"0\"><" + type + '>' + message + "</" + type + "></exist:result>";
    }

    @Override
    public boolean existsAndCanOpenCollection(String collectionUri) throws EXistException, PermissionDeniedException {
        XmldbURI uri;
        try {
            uri = XmldbURI.xmldbUriFor(collectionUri);
        }
        catch (URISyntaxException use) {
            throw new EXistException("Collection '" + collectionUri + "' does not indicate a valid collection URI: " + use.getMessage(), use);
        }
        return this.withDb((broker, transaction) -> {
            Collection collection = null;
            try {
                collection = broker.openCollection(uri, Lock.LockMode.READ_LOCK);
                Boolean bl = collection != null;
                return bl;
            }
            finally {
                if (collection != null) {
                    collection.release(Lock.LockMode.READ_LOCK);
                }
            }
        });
    }

    @Override
    public Map<String, Object> getCollectionDesc(String rootCollection) throws EXistException, PermissionDeniedException {
        try {
            return this.getCollectionDesc(rootCollection == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(rootCollection));
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private Map<String, Object> getCollectionDesc(XmldbURI rootUri) throws EXistException, PermissionDeniedException {
        return (Map)this.readCollection(rootUri).apply((collection, broker, transaction) -> {
            HashMap<String, Object> desc = new HashMap<String, Object>();
            ArrayList docs = new ArrayList();
            ArrayList<String> collections = new ArrayList<String>();
            if (collection.getPermissionsNoLock().validate(this.user, 4)) {
                Iterator<Comparable<DocumentImpl>> i = collection.iterator(broker);
                while (i.hasNext()) {
                    DocumentImpl doc = i.next();
                    Permission perms = doc.getPermissions();
                    HashMap<String, Object> hash = new HashMap<String, Object>(5);
                    hash.put("name", doc.getFileURI().toString());
                    hash.put("owner", perms.getOwner().getName());
                    hash.put("group", perms.getGroup().getName());
                    hash.put("permissions", perms.getMode());
                    hash.put("type", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
                    docs.add(hash);
                }
                i = collection.collectionIterator(broker);
                while (i.hasNext()) {
                    collections.add(((XmldbURI)i.next()).toString());
                }
            }
            Permission perms = collection.getPermissionsNoLock();
            desc.put("collections", collections);
            desc.put("documents", docs);
            desc.put("name", collection.getURI().toString());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner().getName());
            desc.put("group", perms.getGroup().getName());
            desc.put("permissions", perms.getMode());
            return desc;
        });
    }

    @Override
    public Map<String, Object> describeResource(String resourceName) throws EXistException, PermissionDeniedException {
        try {
            return this.describeResource(XmldbURI.xmldbUriFor(resourceName));
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private Map<String, Object> describeResource(XmldbURI resourceUri) throws EXistException, PermissionDeniedException {
        try {
            return (Map)this.readDocument(resourceUri).apply((document, broker, transaction) -> {
                HashMap<String, Object> hash = new HashMap<String, Object>(11);
                Permission perms = document.getPermissions();
                hash.put("name", resourceUri.toString());
                hash.put("owner", perms.getOwner().getName());
                hash.put("group", perms.getGroup().getName());
                hash.put("permissions", perms.getMode());
                if (perms instanceof ACLPermission) {
                    hash.put("acl", this.getACEs(perms));
                }
                hash.put("type", document.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
                long resourceLength = document.getContentLength();
                hash.put("content-length", resourceLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)resourceLength);
                hash.put("content-length-64bit", Long.toString(resourceLength));
                hash.put("mime-type", document.getMetadata().getMimeType());
                hash.put("created", new Date(document.getMetadata().getCreated()));
                hash.put("modified", new Date(document.getMetadata().getLastModified()));
                return hash;
            });
        }
        catch (EXistException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return new HashMap<String, Object>();
        }
    }

    @Override
    public Map<String, Object> describeCollection(String rootCollection) throws EXistException, PermissionDeniedException {
        try {
            return this.describeCollection(rootCollection == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(rootCollection));
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private Map<String, Object> describeCollection(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        return (Map)this.readCollection(collUri).apply((collection, broker, transaction) -> {
            HashMap<String, Object> desc = new HashMap<String, Object>();
            ArrayList<String> collections = new ArrayList<String>();
            if (collection.getPermissionsNoLock().validate(this.user, 4)) {
                Iterator<XmldbURI> i = collection.collectionIterator(broker);
                while (i.hasNext()) {
                    collections.add(i.next().toString());
                }
            }
            Permission perms = collection.getPermissionsNoLock();
            desc.put("collections", collections);
            desc.put("name", collection.getURI().toString());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner().getName());
            desc.put("group", perms.getGroup().getName());
            desc.put("permissions", perms.getMode());
            if (perms instanceof ACLPermission) {
                desc.put("acl", this.getACEs(perms));
            }
            return desc;
        });
    }

    @Override
    public byte[] getDocument(String name, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        Charset encoding = this.getEncoding(parameters);
        boolean compression = this.useCompression(parameters);
        String xml = this.getDocumentAsString(name, parameters);
        if (compression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getDocument with compression");
            }
            try {
                return Compressor.compress(xml.getBytes(encoding));
            }
            catch (IOException ioe) {
                throw new EXistException(ioe);
            }
        }
        return xml.getBytes(encoding);
    }

    @Override
    public String getDocumentAsString(String docName, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        try {
            return this.getDocumentAsString(XmldbURI.xmldbUriFor(docName), parameters);
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private String getDocumentAsString(XmldbURI docUri, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return (String)this.readDocument(docUri).apply((document, broker, transaction) -> {
            Serializer serializer = broker.getSerializer();
            serializer.setProperties(this.toProperties(parameters));
            return serializer.serialize(document);
        });
    }

    @Override
    public Map<String, Object> getDocumentData(String docName, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        XmldbURI docUri;
        try {
            docUri = XmldbURI.xmldbUriFor(docName);
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
        return (Map)this.readDocument(docUri).apply((document, broker, transaction) -> {
            VirtualTempFile vtempFile;
            HashMap<String, Object> result;
            block19: {
                Charset encoding = this.getEncoding(parameters);
                result = new HashMap<String, Object>();
                vtempFile = null;
                try {
                    vtempFile = new VirtualTempFile(262144, 262144);
                    vtempFile.setTempPrefix("eXistRPCC");
                    if (document.getResourceType() == 0) {
                        vtempFile.setTempPostfix(".xml");
                        Serializer serializer = broker.getSerializer();
                        serializer.setProperties(this.toProperties(parameters));
                        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)vtempFile, encoding);){
                            serializer.serialize(document, (Writer)writer);
                            break block19;
                        }
                    }
                    vtempFile.setTempPostfix(".bin");
                    broker.readBinaryResource((BinaryDocument)document, vtempFile);
                }
                finally {
                    if (vtempFile != null) {
                        vtempFile.close();
                    }
                }
            }
            byte[] firstChunk = vtempFile.getChunk(0L);
            result.put("data", firstChunk);
            int offset = 0;
            if (vtempFile.length() > 262144L) {
                offset = firstChunk.length;
                int handle = this.factory.resultSets.add(new SerializedResult(vtempFile));
                result.put("handle", Integer.toString(handle));
                result.put("supports-long-offset", Boolean.TRUE);
            } else {
                vtempFile.delete();
            }
            result.put("offset", offset);
            return result;
        });
    }

    @Override
    public Map<String, Object> getNextChunk(String handle, int offset) throws EXistException, PermissionDeniedException {
        try {
            int resultId = Integer.parseInt(handle);
            SerializedResult sr = this.factory.resultSets.getSerializedResult(resultId);
            if (sr == null) {
                throw new EXistException("Invalid handle specified");
            }
            sr.touch();
            VirtualTempFile vfile = sr.result;
            if (offset <= 0 || (long)offset > vfile.length()) {
                this.factory.resultSets.remove(resultId);
                throw new EXistException("No more data available");
            }
            byte[] chunk = vfile.getChunk(offset);
            long nextChunk = offset + chunk.length;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", chunk);
            result.put("handle", handle);
            if (nextChunk > Integer.MAX_VALUE || nextChunk == vfile.length()) {
                this.factory.resultSets.remove(resultId);
                result.put("offset", 0);
            } else {
                result.put("offset", nextChunk);
            }
            return result;
        }
        catch (IOException | NumberFormatException e) {
            throw new EXistException(e);
        }
    }

    @Override
    public Map<String, Object> getNextExtendedChunk(String handle, String offset) throws EXistException, PermissionDeniedException {
        try {
            int resultId = Integer.parseInt(handle);
            SerializedResult sr = this.factory.resultSets.getSerializedResult(resultId);
            if (sr == null) {
                throw new EXistException("Invalid handle specified");
            }
            sr.touch();
            VirtualTempFile vfile = sr.result;
            long longOffset = Long.parseLong(offset);
            if (longOffset < 0L || longOffset > vfile.length()) {
                this.factory.resultSets.remove(resultId);
                throw new EXistException("No more data available");
            }
            byte[] chunk = vfile.getChunk(longOffset);
            long nextChunk = longOffset + (long)chunk.length;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", chunk);
            result.put("handle", handle);
            if (nextChunk == vfile.length()) {
                this.factory.resultSets.remove(resultId);
                result.put("offset", Long.toString(0L));
            } else {
                result.put("offset", Long.toString(nextChunk));
            }
            return result;
        }
        catch (IOException | NumberFormatException e) {
            throw new EXistException(e);
        }
    }

    @Override
    public byte[] getBinaryResource(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getBinaryResource(XmldbURI.xmldbUriFor(name));
    }

    private byte[] getBinaryResource(XmldbURI name) throws EXistException, PermissionDeniedException {
        return this.getBinaryResource(name, 4);
    }

    private byte[] getBinaryResource(XmldbURI name, int requiredPermissions) throws EXistException, PermissionDeniedException {
        return (byte[])this.readDocument(name).apply((document, broker, transaction) -> {
            if (document.getResourceType() != 1) {
                throw new EXistException("Document " + name + " is not a binary resource");
            }
            if (!document.getPermissions().validate(this.user, requiredPermissions)) {
                throw new PermissionDeniedException("Insufficient privileges to access resource");
            }
            try (InputStream is = broker.getBinaryResource((BinaryDocument)document);){
                long resourceSize = broker.getBinaryResourceSize((BinaryDocument)document);
                if (resourceSize > Integer.MAX_VALUE) {
                    throw new EXistException("Resource too big to be read using this method.");
                }
                byte[] data = new byte[(int)resourceSize];
                is.read(data);
                byte[] byArray = data;
                return byArray;
            }
        });
    }

    @Override
    public int xupdate(String collectionName, byte[] xupdate) throws PermissionDeniedException, EXistException {
        try {
            return this.xupdate(XmldbURI.xmldbUriFor(collectionName), new String(xupdate, DEFAULT_ENCODING));
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private int xupdate(XmldbURI collUri, String xupdate) throws PermissionDeniedException, EXistException {
        return this.withDb((broker, transaction) -> {
            Collection collectionRef = (Collection)this.readCollection(collUri).apply((collection, broker1, transaction1) -> collection);
            MutableDocumentSet docs = collectionRef.allDocs(broker, new DefaultDocumentSet(), true);
            try {
                XUpdateProcessor processor = new XUpdateProcessor(broker, docs);
                Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
                long mods = 0L;
                for (Modification modification : modifications) {
                    mods += modification.process(transaction);
                    broker.flush();
                }
                return (int)mods;
            }
            catch (ParserConfigurationException | XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    @Override
    public int xupdateResource(String resource, byte[] xupdate, String encoding) throws PermissionDeniedException, EXistException {
        try {
            return this.xupdateResource(XmldbURI.xmldbUriFor(resource), new String(xupdate, Charset.forName(encoding)));
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    private int xupdateResource(XmldbURI docUri, String xupdate) throws PermissionDeniedException, EXistException {
        return this.withDb((broker, transaction) -> {
            DocumentImpl documentRef = (DocumentImpl)this.readDocument(docUri).apply((document, broker1, transaction1) -> document);
            DefaultDocumentSet docs = new DefaultDocumentSet();
            docs.add(documentRef);
            try {
                XUpdateProcessor processor = new XUpdateProcessor(broker, docs);
                Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
                long mods = 0L;
                for (Modification modification : modifications) {
                    mods += modification.process(transaction);
                    broker.flush();
                }
                return (int)mods;
            }
            catch (ParserConfigurationException | XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    @Override
    public boolean sync() {
        try {
            return this.withDbAsSystem((broker, transaction) -> {
                broker.sync(Sync.MAJOR);
                return true;
            });
        }
        catch (EXistException | PermissionDeniedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean dataBackup(String dest) {
        this.factory.getBrokerPool().triggerSystemTask(new DataBackup(Paths.get(dest, new String[0])));
        return true;
    }

    @Override
    public List<String> getDocumentListing() throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> {
            MutableDocumentSet docs = broker.getAllXMLResources(new DefaultDocumentSet());
            XmldbURI[] names = docs.getNames();
            ArrayList<String> list = new ArrayList<String>();
            for (XmldbURI name : names) {
                list.add(name.toString());
            }
            return list;
        });
    }

    @Override
    public List<String> getCollectionListing(String collName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getCollectionListing(XmldbURI.xmldbUriFor(collName));
    }

    private List<String> getCollectionListing(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        try {
            return (List)this.readCollection(collUri).apply((collection, broker, transaction) -> {
                ArrayList<String> list = new ArrayList<String>();
                Iterator<XmldbURI> i = collection.collectionIterator(broker);
                while (i.hasNext()) {
                    list.add(i.next().toString());
                }
                return list;
            });
        }
        catch (EXistException e) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public List<String> getDocumentListing(String collName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getDocumentListing(XmldbURI.xmldbUriFor(collName));
    }

    private List<String> getDocumentListing(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        try {
            return (List)this.readCollection(collUri).apply((collection, broker, transaction) -> {
                ArrayList<String> list = new ArrayList<String>();
                Iterator<DocumentImpl> i = collection.iterator(broker);
                while (i.hasNext()) {
                    list.add(i.next().getFileURI().toString());
                }
                return list;
            });
        }
        catch (EXistException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public int getResourceCount(String collectionName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getResourceCount(XmldbURI.xmldbUriFor(collectionName));
    }

    private int getResourceCount(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        return (Integer)this.readCollection(collUri).apply((collection, broker, transaction) -> collection.getDocumentCount(broker));
    }

    @Override
    public String createResourceId(String collectionName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.createResourceId(XmldbURI.xmldbUriFor(collectionName));
    }

    private String createResourceId(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        return (String)this.readCollection(collUri).apply((collection, broker, transaction) -> {
            XmldbURI id;
            boolean ok;
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(broker, id)) {
                    ok = false;
                }
                if (!collection.hasChildCollection(broker, id)) continue;
                ok = false;
            } while (!ok);
            return id.toString();
        });
    }

    @Override
    public int getHits(int resultId) throws EXistException {
        QueryResult qr = this.factory.resultSets.getResult(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.touch();
        if (qr.result == null) {
            return 0;
        }
        return qr.result.getItemCount();
    }

    @Override
    public Map<String, Object> getPermissions(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getPermissions(XmldbURI.xmldbUriFor(name));
    }

    private Map<String, Object> getPermissions(XmldbURI uri) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> {
            Collection collection = null;
            try {
                Permission perm;
                collection = broker.openCollection(uri, Lock.LockMode.READ_LOCK);
                if (collection == null) {
                    DocumentImpl doc = null;
                    try {
                        doc = broker.getXMLResource(uri, Lock.LockMode.READ_LOCK);
                        if (doc == null) {
                            throw new EXistException("document or collection " + uri + " not found");
                        }
                        perm = doc.getPermissions();
                    }
                    finally {
                        if (doc != null) {
                            doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                        }
                    }
                } else {
                    perm = collection.getPermissionsNoLock();
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("owner", perm.getOwner().getName());
                result.put("group", perm.getGroup().getName());
                result.put("permissions", perm.getMode());
                if (perm instanceof ACLPermission) {
                    result.put("acl", this.getACEs(perm));
                }
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            finally {
                if (collection != null) {
                    collection.release(Lock.LockMode.READ_LOCK);
                }
            }
        });
    }

    @Override
    public Map<String, Object> getSubCollectionPermissions(String parentPath, String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(parentPath);
        Permission perm = (Permission)this.readCollection(uri).apply((collection, broker, transaction) -> collection.getChildCollectionEntry(broker, name).getPermissions());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("owner", perm.getOwner().getName());
        result.put("group", perm.getGroup().getName());
        result.put("permissions", perm.getMode());
        if (perm instanceof ACLPermission) {
            result.put("acl", this.getACEs(perm));
        }
        return result;
    }

    @Override
    public Map<String, Object> getSubResourcePermissions(String parentPath, String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(parentPath);
        Permission perm = (Permission)this.readCollection(uri).apply((collection, broker, transaction) -> collection.getResourceEntry(broker, name).getPermissions());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("owner", perm.getOwner().getName());
        result.put("group", perm.getGroup().getName());
        result.put("permissions", perm.getMode());
        if (perm instanceof ACLPermission) {
            result.put("acl", this.getACEs(perm));
        }
        return result;
    }

    @Override
    public long getSubCollectionCreationTime(String parentPath, String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(parentPath);
        return (Long)this.readCollection(uri).apply((collection, broker, transaction) -> collection.getChildCollectionEntry(broker, name).getCreated());
    }

    private List<ACEAider> getACEs(Permission perm) {
        ArrayList<ACEAider> aces = new ArrayList<ACEAider>();
        ACLPermission aclPermission = (ACLPermission)((Object)perm);
        for (int i = 0; i < aclPermission.getACECount(); ++i) {
            aces.add(new ACEAider(aclPermission.getACEAccessType(i), aclPermission.getACETarget(i), aclPermission.getACEWho(i), aclPermission.getACEMode(i)));
        }
        return aces;
    }

    @Override
    public Map<String, List> listDocumentPermissions(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.listDocumentPermissions(XmldbURI.xmldbUriFor(name));
    }

    private Map<String, List> listDocumentPermissions(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        return (Map)this.readCollection(collUri).apply((collection, broker, transaction) -> {
            HashMap result = new HashMap(collection.getDocumentCount(broker));
            Iterator<DocumentImpl> i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = i.next();
                Permission perm = doc.getPermissions();
                ArrayList<Object> tmp = new ArrayList<Object>(4);
                tmp.add(perm.getOwner().getName());
                tmp.add(perm.getGroup().getName());
                tmp.add(perm.getMode());
                if (perm instanceof ACLPermission) {
                    tmp.add(this.getACEs(perm));
                }
                result.put(doc.getFileURI().toString(), tmp);
            }
            return result;
        });
    }

    @Override
    public Map<XmldbURI, List> listCollectionPermissions(String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.listCollectionPermissions(XmldbURI.xmldbUriFor(name));
    }

    private Map<XmldbURI, List> listCollectionPermissions(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        return (Map)this.readCollection(collUri).apply((collection, broker, transaction) -> {
            HashMap result = new HashMap(collection.getChildCollectionCount(broker));
            Iterator<XmldbURI> i = collection.collectionIterator(broker);
            while (i.hasNext()) {
                XmldbURI child = i.next();
                XmldbURI path = collUri.append(child);
                Collection childColl = broker.getCollection(path);
                Permission perm = childColl.getPermissionsNoLock();
                ArrayList<Object> tmp = new ArrayList<Object>(4);
                tmp.add(perm.getOwner().getName());
                tmp.add(perm.getGroup().getName());
                tmp.add(perm.getMode());
                if (perm instanceof ACLPermission) {
                    tmp.add(this.getACEs(perm));
                }
                result.put(child, tmp);
            }
            return result;
        });
    }

    @Override
    public Date getCreationDate(String collectionPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getCreationDate(XmldbURI.xmldbUriFor(collectionPath));
    }

    private Date getCreationDate(XmldbURI collUri) throws PermissionDeniedException, EXistException {
        return (Date)this.readCollection(collUri).apply((collection, broker, transaction) -> new Date(collection.getCreationTime()));
    }

    @Override
    public List<Date> getTimestamps(String documentPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getTimestamps(XmldbURI.xmldbUriFor(documentPath));
    }

    private List<Date> getTimestamps(XmldbURI docUri) throws PermissionDeniedException, EXistException {
        return (List)this.readDocument(docUri).apply((document, broker, transaction) -> {
            DocumentMetadata metadata = document.getMetadata();
            ArrayList<Date> list = new ArrayList<Date>(2);
            list.add(new Date(metadata.getCreated()));
            list.add(new Date(metadata.getLastModified()));
            return list;
        });
    }

    @Override
    public boolean setLastModified(String documentPath, long lastModified) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeDocument(XmldbURI.create(documentPath)).apply((document, broker, transaction) -> {
            if (!document.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + documentPath);
            }
            document.getMetadata().setLastModified(lastModified);
            broker.storeXMLResource(transaction, document);
            return true;
        });
    }

    @Override
    public Map<String, Object> getAccount(String name) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> {
            Account u = this.factory.getBrokerPool().getSecurityManager().getAccount(name);
            if (u == null) {
                throw new EXistException("account '" + name + "' does not exist");
            }
            HashMap<String, Object> tab = new HashMap<String, Object>();
            tab.put("uid", this.user.getId());
            tab.put("name", u.getName());
            tab.put("groups", Arrays.asList(u.getGroups()));
            Group dg = u.getDefaultGroup();
            if (dg != null) {
                tab.put("default-group-id", dg.getId());
                tab.put("default-group-realmId", dg.getRealmId());
                tab.put("default-group-name", dg.getName());
            }
            tab.put("enabled", Boolean.toString(u.isEnabled()));
            tab.put("umask", u.getUserMask());
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (SchemaType key : u.getMetadataKeys()) {
                metadata.put(key.getNamespace(), u.getMetadataValue(key));
            }
            tab.put("metadata", metadata);
            return tab;
        });
    }

    @Override
    public List<Map<String, Object>> getAccounts() throws EXistException, PermissionDeniedException {
        java.util.Collection<Account> users = this.factory.getBrokerPool().getSecurityManager().getUsers();
        ArrayList<Map<String, Object>> r = new ArrayList<Map<String, Object>>();
        for (Account user : users) {
            HashMap<String, Object> tab = new HashMap<String, Object>();
            tab.put("uid", user.getId());
            tab.put("name", user.getName());
            tab.put("groups", Arrays.asList(user.getGroups()));
            tab.put("enabled", Boolean.toString(user.isEnabled()));
            tab.put("umask", user.getUserMask());
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (SchemaType key : user.getMetadataKeys()) {
                metadata.put(key.getNamespace(), user.getMetadataValue(key));
            }
            tab.put("metadata", metadata);
            r.add(tab);
        }
        return r;
    }

    @Override
    public List<String> getGroups() throws EXistException, PermissionDeniedException {
        java.util.Collection<Group> groups = this.factory.getBrokerPool().getSecurityManager().getGroups();
        ArrayList<String> v = new ArrayList<String>(groups.size());
        for (Group group : groups) {
            v.add(group.getName());
        }
        return v;
    }

    @Override
    public Map<String, Object> getGroup(String name) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> {
            SecurityManager securityManager = this.factory.getBrokerPool().getSecurityManager();
            Group group = securityManager.getGroup(name);
            if (group != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", group.getId());
                map.put("realmId", group.getRealmId());
                map.put("name", name);
                List<Account> groupManagers = group.getManagers();
                ArrayList<String> managers = new ArrayList<String>(groupManagers.size());
                for (Account groupManager : groupManagers) {
                    managers.add(groupManager.getName());
                }
                map.put("managers", managers);
                HashMap<String, String> metadata = new HashMap<String, String>();
                for (SchemaType key : group.getMetadataKeys()) {
                    metadata.put(key.getNamespace(), group.getMetadataValue(key));
                }
                map.put("metadata", metadata);
                return map;
            }
            return null;
        });
    }

    @Override
    public void removeGroup(String name) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> broker.getBrokerPool().getSecurityManager().deleteGroup(name));
    }

    @Override
    public boolean hasDocument(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.hasDocument(XmldbURI.xmldbUriFor(documentPath));
    }

    private boolean hasDocument(XmldbURI docUri) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> broker.getXMLResource(docUri) != null);
    }

    @Override
    public boolean hasCollection(String collectionName) throws EXistException, URISyntaxException, PermissionDeniedException {
        return this.hasCollection(XmldbURI.xmldbUriFor(collectionName));
    }

    private boolean hasCollection(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> broker.getCollection(collUri) != null);
    }

    @Override
    public boolean parse(byte[] xml, String documentPath, int overwrite) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.parse(xml, documentPath, overwrite, null, null);
    }

    @Override
    public boolean parse(byte[] xml, String documentPath, int overwrite, Date created, Date modified) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.parse(xml, XmldbURI.xmldbUriFor(documentPath), overwrite, created, modified);
    }

    private boolean parse(byte[] xml, XmldbURI docUri, int overwrite, Date created, Date modified) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeCollection(docUri.removeLastSegment()).apply((collection, broker, transaction) -> {
            DocumentImpl old;
            if (overwrite == 0 && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                throw new PermissionDeniedException("Document exists and overwrite is not allowed");
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(xml);){
                InputSource source = new InputSource(is);
                long startTime = System.currentTimeMillis();
                IndexInfo info = collection.validateXMLResource(transaction, broker, docUri.lastSegment(), source);
                MimeType mime = MimeTable.getInstance().getContentTypeFor(docUri.lastSegment());
                if (mime != null && mime.isXMLType()) {
                    info.getDocument().getMetadata().setMimeType(mime.getName());
                }
                if (created != null) {
                    info.getDocument().getMetadata().setCreated(created.getTime());
                }
                if (modified != null) {
                    info.getDocument().getMetadata().setLastModified(modified.getTime());
                }
                collection.store(transaction, broker, info, source);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsing " + docUri + " took " + (System.currentTimeMillis() - startTime) + "ms.");
                }
                Boolean bl = true;
                return bl;
            }
        });
    }

    public boolean parseLocal(String localFile, String documentPath, int overwrite, String mimeType) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.parseLocal(localFile, documentPath, overwrite, mimeType, null, null);
    }

    public boolean parseLocalExt(String localFile, String documentPath, int overwrite, String mimeType, int isXML) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.parseLocalExt(localFile, documentPath, overwrite, mimeType, isXML, null, null);
    }

    private boolean parseLocal(String localFile, XmldbURI docUri, int overwrite, String mimeType) throws EXistException, PermissionDeniedException {
        return this.parseLocal(localFile, docUri, overwrite, mimeType, null, null, null);
    }

    private boolean parseLocalExt(String localFile, XmldbURI docUri, int overwrite, String mimeType, int isXML) throws EXistException, PermissionDeniedException {
        return this.parseLocal(localFile, docUri, overwrite, mimeType, isXML != 0, null, null);
    }

    public boolean parseLocal(String localFile, String documentPath, int overwrite, String mimeType, Date created, Date modified) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.parseLocal(localFile, XmldbURI.xmldbUriFor(documentPath), overwrite, mimeType, null, created, modified);
    }

    public boolean parseLocalExt(String localFile, String documentPath, int overwrite, String mimeType, int isXML, Date created, Date modified) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.parseLocal(localFile, XmldbURI.xmldbUriFor(documentPath), overwrite, mimeType, isXML != 0, created, modified);
    }

    private boolean parseLocal(String localFile, XmldbURI docUri, int overwrite, String mimeType, Boolean isXML, Date created, Date modified) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeCollection(docUri.removeLastSegment()).apply((collection, broker, transaction) -> {
            SupplierE sourceSupplier;
            DocumentImpl old;
            if (overwrite == 0 && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
            }
            try {
                int handle = Integer.parseInt(localFile);
                SerializedResult sr = this.factory.resultSets.getSerializedResult(handle);
                if (sr == null) {
                    throw new EXistException("Invalid handle specified");
                }
                sourceSupplier = () -> {
                    VirtualTempFileInputSource source = new VirtualTempFileInputSource(sr.result);
                    sr.result = null;
                    this.factory.resultSets.remove(handle);
                    return source;
                };
            }
            catch (NumberFormatException nfe) {
                Path path = Paths.get(localFile, new String[0]);
                if (!Files.isReadable(path)) {
                    throw new EXistException("unable to read file " + path.toAbsolutePath().toString());
                }
                sourceSupplier = () -> new VirtualTempFileInputSource(path);
            }
            try (VirtualTempFileInputSource source = (VirtualTempFileInputSource)sourceSupplier.get();){
                boolean treatAsXML;
                MimeType mime = Optional.ofNullable(MimeTable.getInstance().getContentType(mimeType)).orElse(MimeType.BINARY_TYPE);
                boolean bl = treatAsXML = isXML != null && isXML != false || isXML == null && mime.isXMLType();
                if (treatAsXML) {
                    IndexInfo info = collection.validateXMLResource(transaction, broker, docUri.lastSegment(), source);
                    if (created != null) {
                        info.getDocument().getMetadata().setCreated(created.getTime());
                    }
                    if (modified != null) {
                        info.getDocument().getMetadata().setLastModified(modified.getTime());
                    }
                    collection.store(transaction, broker, info, source);
                } else {
                    try (InputStream is = source.getByteStream();){
                        BinaryDocument doc = collection.addBinaryResource(transaction, broker, docUri.lastSegment(), is, mime.getName(), source.getByteStreamLength());
                        if (created != null) {
                            doc.getMetadata().setCreated(created.getTime());
                        }
                        if (modified != null) {
                            doc.getMetadata().setLastModified(modified.getTime());
                        }
                    }
                }
                Boolean bl2 = true;
                return bl2;
            }
        });
    }

    public boolean storeBinary(byte[] data, String documentPath, String mimeType, int overwrite) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.storeBinary(data, documentPath, mimeType, overwrite, null, null);
    }

    private boolean storeBinary(byte[] data, XmldbURI docUri, String mimeType, int overwrite) throws EXistException, PermissionDeniedException {
        return this.storeBinary(data, docUri, mimeType, overwrite, null, null);
    }

    public boolean storeBinary(byte[] data, String documentPath, String mimeType, int overwrite, Date created, Date modified) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.storeBinary(data, XmldbURI.xmldbUriFor(documentPath), mimeType, overwrite, created, modified);
    }

    private boolean storeBinary(byte[] data, XmldbURI docUri, String mimeType, int overwrite, Date created, Date modified) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeCollection(docUri.removeLastSegment()).apply((collection, broker, transaction) -> {
            DocumentImpl old;
            transaction.acquireLock(collection.getLock(), Lock.LockMode.WRITE_LOCK);
            if (overwrite == 0 && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Storing binary resource to collection " + collection.getURI());
            }
            BinaryDocument doc = collection.addBinaryResource(transaction, broker, docUri.lastSegment(), data, mimeType);
            if (created != null) {
                doc.getMetadata().setCreated(created.getTime());
            }
            if (modified != null) {
                doc.getMetadata().setLastModified(modified.getTime());
            }
            return doc != null;
        });
    }

    public String upload(byte[] chunk, int length, String fileName, boolean compressed) throws EXistException, IOException {
        VirtualTempFile vtempFile;
        if (fileName == null || fileName.length() == 0) {
            vtempFile = new VirtualTempFile(262144, 262144);
            vtempFile.setTempPrefix("rpc");
            vtempFile.setTempPostfix(".xml");
            int handle = this.factory.resultSets.add(new SerializedResult(vtempFile));
            fileName = Integer.toString(handle);
        } else {
            try {
                int handle = Integer.parseInt(fileName);
                SerializedResult sr = this.factory.resultSets.getSerializedResult(handle);
                if (sr == null) {
                    throw new EXistException("Invalid handle specified");
                }
                sr.touch();
                vtempFile = sr.result;
            }
            catch (NumberFormatException nfe) {
                throw new EXistException("Syntactically invalid handle specified");
            }
        }
        if (compressed) {
            Compressor.uncompress(chunk, vtempFile);
        } else {
            vtempFile.write(chunk, 0, length);
        }
        return fileName;
    }

    protected String printAll(DBBroker broker, Sequence resultSet, int howmany, int start, Map<String, Object> properties, long queryTime) throws EXistException, SAXException, XPathException {
        if (resultSet.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            String opt = (String)properties.get("omit-xml-declaration");
            if (opt == null || opt.equalsIgnoreCase("no")) {
                buf.append("<?xml version=\"1.0\"?>\n");
            }
            buf.append("<exist:result xmlns:exist=\"").append("http://exist.sourceforge.net/NS/exist").append("\" ");
            buf.append("hitCount=\"0\"/>");
            return buf.toString();
        }
        if (howmany > resultSet.getItemCount() || howmany == 0) {
            howmany = resultSet.getItemCount();
        }
        if (start < 1 || start > resultSet.getItemCount()) {
            throw new EXistException("start parameter out of range");
        }
        StringWriter writer = new StringWriter();
        writer.write("<exist:result xmlns:exist=\"");
        writer.write("http://exist.sourceforge.net/NS/exist");
        writer.write("\" hits=\"");
        writer.write(Integer.toString(resultSet.getItemCount()));
        writer.write("\" start=\"");
        writer.write(Integer.toString(start));
        writer.write("\" count=\"");
        writer.write(Integer.toString(howmany));
        writer.write("\">\n");
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperties(this.toProperties(properties));
        for (int i = --start; i < start + howmany; ++i) {
            Item item = resultSet.itemAt(i);
            if (item == null) continue;
            if (item.getType() == 1) {
                NodeValue node = (NodeValue)item;
                writer.write(serializer.serialize(node));
                continue;
            }
            writer.write("<exist:value type=\"");
            writer.write(Type.getTypeName(item.getType()));
            writer.write("\">");
            writer.write(item.getStringValue());
            writer.write("</exist:value>");
        }
        writer.write("\n</exist:result>");
        return writer.toString();
    }

    public Map<String, Object> compile(String query, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        StringSource source = new StringSource(query);
        return this.withDb((broker, transaction) -> {
            HashMap<String, Object> ret;
            block2: {
                ret = new HashMap<String, Object>();
                try {
                    this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> null);
                }
                catch (XPathException e) {
                    ret.put("error", e.getMessage());
                    if (e.getLine() == 0) break block2;
                    ret.put("line", e.getLine());
                    ret.put("column", e.getColumn());
                }
            }
            return ret;
        });
    }

    public String query(String xpath, int howmany, int start, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        StringSource source = new StringSource(xpath);
        return this.withDb((broker, transaction) -> {
            long startTime = System.currentTimeMillis();
            try {
                QueryResult qr = (QueryResult)this.compileQuery(broker, transaction, source, parameters).apply(compiled -> this.doQuery(broker, compiled, null, parameters));
                if (qr == null) {
                    return "<?xml version=\"1.0\"?>\n<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" hitCount=\"0\"/>";
                }
                if (qr.hasErrors()) {
                    throw qr.getException();
                }
                return this.printAll(broker, qr.result, howmany, start, parameters, System.currentTimeMillis() - startTime);
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    public Map<String, Object> queryP(String xpath, String documentPath, String s_id, Map<String, Object> parameters) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.queryP(xpath, documentPath == null ? null : XmldbURI.xmldbUriFor(documentPath), s_id, parameters);
    }

    private Map<String, Object> queryP(String xpath, XmldbURI docUri, String s_id, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        StringSource source = new StringSource(xpath);
        Optional<String> sortBy = Optional.ofNullable(parameters.get("sort-expr")).map(Object::toString);
        return this.withDb((broker, transaction) -> {
            long startTime = System.currentTimeMillis();
            NodeSet nodes = docUri != null && s_id != null ? (NodeSet)this.readDocument(broker, transaction, docUri).apply((document, broker1, transaction1) -> {
                Object[] docs = new Object[]{docUri.toString()};
                parameters.put("static-documents", docs);
                if (s_id.length() > 0) {
                    NodeId nodeId = this.factory.getBrokerPool().getNodeFactory().createFromString(s_id);
                    NodeProxy node = new NodeProxy(document, nodeId);
                    ExtArrayNodeSet nodeSet = new ExtArrayNodeSet(1);
                    nodeSet.add(node);
                    return nodeSet;
                }
                return null;
            }) : null;
            try {
                Map rpcResponse = (Map)this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> this.queryResultToRpcResponse(startTime, this.doQuery(broker, compiledQuery, nodes, parameters), sortBy));
                return rpcResponse;
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    private Map<String, Object> queryResultToRpcResponse(long startTime, QueryResult queryResult, Optional<String> sortBy) throws XPathException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (queryResult == null) {
            return ret;
        }
        if (queryResult.hasErrors()) {
            XPathException e = queryResult.getException();
            ret.put("error", e.getMessage());
            if (e.getLine() != 0) {
                ret.put("line", e.getLine());
                ret.put("column", e.getColumn());
            }
            return ret;
        }
        Sequence resultSeq = queryResult.result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("found " + resultSeq.getItemCount());
        }
        if (sortBy.isPresent()) {
            SortedNodeSet sorted = new SortedNodeSet(this.factory.getBrokerPool(), this.user, sortBy.get());
            sorted.addAll(resultSeq);
            resultSeq = sorted;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (resultSeq != null) {
            SequenceIterator i = resultSeq.iterate();
            if (i != null) {
                while (i.hasNext()) {
                    Item next = i.nextItem();
                    if (Type.subTypeOf(next.getType(), -1)) {
                        ArrayList<String> entry = new ArrayList<String>();
                        if (((NodeValue)next).getImplementationType() == 1) {
                            NodeProxy p = (NodeProxy)next;
                            entry.add(p.getOwnerDocument().getURI().toString());
                            entry.add(p.getNodeId().toString());
                        } else {
                            entry.add("temp_xquery/" + next.hashCode());
                            entry.add(String.valueOf(((NodeImpl)next).getNodeNumber()));
                        }
                        result.add(entry);
                        continue;
                    }
                    result.add(next.getStringValue());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("sequence iterator is null. Should not");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("result sequence is null. Skipping it...");
        }
        queryResult.result = resultSeq;
        queryResult.queryTime = System.currentTimeMillis() - startTime;
        int id = this.factory.resultSets.add(queryResult);
        ret.put("id", id);
        ret.put("hash", queryResult.hashCode());
        ret.put("results", result);
        return ret;
    }

    @Override
    public Map<String, Object> queryPT(byte[] xquery, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return this.queryPT(new String(xquery, DEFAULT_ENCODING), null, null, parameters);
    }

    @Override
    public Map<String, Object> queryPT(byte[] xquery, @Nullable String docName, @Nullable String s_id, Map<String, Object> parameters) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.queryPT(new String(xquery, DEFAULT_ENCODING), docName == null ? null : XmldbURI.create(docName), s_id, parameters);
    }

    private Map<String, Object> queryPT(String xquery, XmldbURI docUri, String s_id, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        StringSource source = new StringSource(xquery);
        Optional<String> sortBy = Optional.ofNullable(parameters.get("sort-expr")).map(Object::toString);
        return this.withDb((broker, transaction) -> {
            long startTime = System.currentTimeMillis();
            NodeSet nodes = docUri != null && s_id != null ? (NodeSet)this.readDocument(broker, transaction, docUri).apply((document, broker1, transaction1) -> {
                Object[] docs = new Object[]{docUri.toString()};
                parameters.put("static-documents", docs);
                if (s_id.length() > 0) {
                    NodeId nodeId = this.factory.getBrokerPool().getNodeFactory().createFromString(s_id);
                    NodeProxy node = new NodeProxy(document, nodeId);
                    ExtArrayNodeSet nodeSet = new ExtArrayNodeSet(1);
                    nodeSet.add(node);
                    return nodeSet;
                }
                return null;
            }) : null;
            try {
                Map rpcResponse = (Map)this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> this.queryResultToTypedRpcResponse(startTime, this.doQuery(broker, compiledQuery, nodes, parameters), sortBy));
                return rpcResponse;
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    private Map<String, Object> queryResultToTypedRpcResponse(long startTime, QueryResult queryResult, Optional<String> sortBy) throws XPathException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (queryResult == null) {
            return ret;
        }
        if (queryResult.hasErrors()) {
            XPathException e = queryResult.getException();
            ret.put("error", e.getMessage());
            if (e.getLine() != 0) {
                ret.put("line", e.getLine());
                ret.put("column", e.getColumn());
            }
            return ret;
        }
        Sequence resultSeq = queryResult.result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("found " + resultSeq.getItemCount());
        }
        if (sortBy.isPresent()) {
            SortedNodeSet sorted = new SortedNodeSet(this.factory.getBrokerPool(), this.user, sortBy.get());
            sorted.addAll(resultSeq);
            resultSeq = sorted;
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (resultSeq != null) {
            SequenceIterator i = resultSeq.iterate();
            if (i != null) {
                while (i.hasNext()) {
                    Item next = i.nextItem();
                    Map<String, String> entry = Type.subTypeOf(next.getType(), -1) ? this.nodeMap(next) : this.atomicMap(next);
                    if (entry == null) continue;
                    result.add(entry);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("sequence iterator is null. Should not");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("result sequence is null. Skipping it...");
        }
        queryResult.result = resultSeq;
        queryResult.queryTime = System.currentTimeMillis() - startTime;
        int id = this.factory.resultSets.add(queryResult);
        ret.put("id", id);
        ret.put("hash", queryResult.hashCode());
        ret.put("results", result);
        return ret;
    }

    @Nullable
    private Map<String, String> nodeMap(Item item) {
        HashMap<String, String> result;
        if (item instanceof NodeValue && ((NodeValue)item).getImplementationType() == 1) {
            NodeProxy p = (NodeProxy)item;
            result = new HashMap();
            result.put("type", Type.getTypeName(p.getType()));
            result.put("docUri", p.getOwnerDocument().getURI().toString());
            result.put("nodeId", p.getNodeId().toString());
        } else if (item instanceof NodeImpl) {
            NodeImpl ni = (NodeImpl)item;
            result = new HashMap<String, String>();
            result.put("type", Type.getTypeName(ni.getType()));
            result.put("docUri", "temp_xquery/" + item.hashCode());
            result.put("nodeId", String.valueOf(ni.getNodeNumber()));
        } else {
            LOG.error("Omitting from results, unsure how to process: " + item.getClass());
            result = null;
        }
        return result;
    }

    private Map<String, String> atomicMap(Item item) throws XPathException {
        HashMap<String, String> result = new HashMap<String, String>();
        int type = item.getType();
        result.put("type", Type.getTypeName(type));
        result.put("value", item.getStringValue());
        return result;
    }

    @Override
    @Deprecated
    public Map<String, Object> execute(String pathToQuery, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        long startTime = System.currentTimeMillis();
        Optional<String> sortBy = Optional.ofNullable(parameters.get("sort-expr")).map(Object::toString);
        return (Map)this.readDocument(XmldbURI.createInternal(pathToQuery)).apply((document, broker, transaction) -> {
            BinaryDocument xquery = (BinaryDocument)document;
            if (xquery.getResourceType() != 1) {
                throw new EXistException("Document " + pathToQuery + " is not a binary resource");
            }
            if (!xquery.getPermissions().validate(this.user, 5)) {
                throw new PermissionDeniedException("Insufficient privileges to access resource");
            }
            DBSource source = new DBSource(broker, xquery, true);
            try {
                Map rpcResponse = (Map)this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> this.queryResultToRpcResponse(startTime, this.doQuery(broker, compiledQuery, null, parameters), sortBy));
                return rpcResponse;
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    @Override
    public Map<String, Object> executeT(String pathToQuery, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        long startTime = System.currentTimeMillis();
        Optional<String> sortBy = Optional.ofNullable(parameters.get("sort-expr")).map(Object::toString);
        return (Map)this.readDocument(XmldbURI.createInternal(pathToQuery)).apply((document, broker, transaction) -> {
            BinaryDocument xquery = (BinaryDocument)document;
            if (xquery.getResourceType() != 1) {
                throw new EXistException("Document " + pathToQuery + " is not a binary resource");
            }
            if (!xquery.getPermissions().validate(this.user, 5)) {
                throw new PermissionDeniedException("Insufficient privileges to access resource");
            }
            DBSource source = new DBSource(broker, xquery, true);
            try {
                Map rpcResponse = (Map)this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> this.queryResultToTypedRpcResponse(startTime, this.doQuery(broker, compiledQuery, null, parameters), sortBy));
                return rpcResponse;
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    @Override
    public boolean releaseQueryResult(int handle) {
        this.factory.resultSets.remove(handle);
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed query result with handle " + handle);
        }
        return true;
    }

    @Override
    public boolean releaseQueryResult(int handle, int hash) {
        this.factory.resultSets.remove(handle, hash);
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed query result with handle " + handle);
        }
        return true;
    }

    @Override
    public boolean remove(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.remove(XmldbURI.xmldbUriFor(documentPath));
    }

    private boolean remove(XmldbURI docUri) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeCollection(docUri.removeLastSegment()).apply((collection, broker, transaction) -> {
            transaction.acquireLock(collection.getLock(), Lock.LockMode.WRITE_LOCK);
            DocumentImpl doc = collection.getDocument(broker, docUri.lastSegment());
            if (doc == null) {
                throw new EXistException("Document " + docUri + " not found");
            }
            if (doc.getResourceType() == 1) {
                collection.removeBinaryResource(transaction, broker, doc);
            } else {
                collection.removeXMLResource(transaction, broker, docUri.lastSegment());
            }
            return true;
        });
    }

    @Override
    public boolean removeCollection(String collectionName) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.removeCollection(XmldbURI.xmldbUriFor(collectionName));
    }

    private boolean removeCollection(XmldbURI collURI) throws EXistException, PermissionDeniedException {
        try {
            return (Boolean)this.writeCollection(collURI).apply((collection, broker, transaction) -> {
                transaction.acquireLock(collection.getLock(), Lock.LockMode.WRITE_LOCK);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removing collection " + collURI);
                }
                return broker.removeCollection(transaction, collection);
            });
        }
        catch (EXistException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return false;
        }
    }

    @Override
    public boolean removeAccount(String name) throws EXistException, PermissionDeniedException {
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new PermissionDeniedException("you are not allowed to remove users");
        }
        this.withDb((broker, transaction) -> manager.deleteAccount(name));
        return true;
    }

    @Override
    public byte[] retrieve(String doc, String id, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        try {
            String xml = this.retrieveAsString(doc, id, parameters);
            return xml.getBytes(this.getEncoding(parameters));
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    @Override
    public String retrieveAsString(String documentPath, String s_id, Map<String, Object> parameters) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.retrieve(XmldbURI.xmldbUriFor(documentPath), s_id, parameters);
    }

    private String retrieve(XmldbURI docUri, String s_id, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return (String)this.readDocument(docUri).apply((document, broker, transaction) -> {
            NodeId nodeId = this.factory.getBrokerPool().getNodeFactory().createFromString(s_id);
            NodeProxy node = new NodeProxy(document, nodeId);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(this.toProperties(parameters));
            return serializer.serialize(node);
        });
    }

    @Override
    public Map<String, Object> retrieveFirstChunk(String docName, String id, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        XmldbURI docUri;
        boolean compression = this.useCompression(parameters);
        try {
            docUri = XmldbURI.xmldbUriFor(docName);
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
        return (Map)this.readDocument(docUri).apply((document, broker, transaction) -> {
            NodeId nodeId = this.factory.getBrokerPool().getNodeFactory().createFromString(id);
            NodeProxy node = new NodeProxy(document, nodeId);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(this.toProperties(parameters));
            HashMap<String, Object> result = new HashMap<String, Object>();
            VirtualTempFile vtempFile = new VirtualTempFile(262144, 262144);
            vtempFile.setTempPrefix("eXistRPCC");
            vtempFile.setTempPostfix(".xml");
            OutputStream os = null;
            if (compression) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("retrieveFirstChunk with compression");
                }
                os = new DeflaterOutputStream(vtempFile);
            } else {
                os = vtempFile;
            }
            try (OutputStreamWriter writer2 = new OutputStreamWriter(os, this.getEncoding(parameters));){
                serializer.serialize(node, (Writer)writer2);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException writer2) {}
                if (os != vtempFile) {
                    try {
                        vtempFile.close();
                    }
                    catch (IOException writer2) {}
                }
            }
            byte[] firstChunk = vtempFile.getChunk(0L);
            result.put("data", firstChunk);
            int offset = 0;
            if (vtempFile.length() > 262144L) {
                offset = firstChunk.length;
                int handle = this.factory.resultSets.add(new SerializedResult(vtempFile));
                result.put("handle", Integer.toString(handle));
                result.put("supports-long-offset", Boolean.TRUE);
            } else {
                vtempFile.delete();
            }
            result.put("offset", offset);
            return result;
        });
    }

    @Override
    public byte[] retrieve(int resultId, int num, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        Charset encoding = this.getEncoding(parameters);
        boolean compression = this.useCompression(parameters);
        String xml = this.retrieveAsString(resultId, num, parameters);
        if (compression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("retrieve with compression");
            }
            try {
                return Compressor.compress(xml.getBytes(encoding));
            }
            catch (IOException ioe) {
                throw new EXistException(ioe);
            }
        }
        return xml.getBytes(encoding);
    }

    private String retrieveAsString(int resultId, int num, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> {
            QueryResult qr = this.factory.resultSets.getResult(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.touch();
            Item item = qr.result.itemAt(num);
            if (item == null) {
                throw new EXistException("index out of range");
            }
            if (Type.subTypeOf(item.getType(), -1)) {
                NodeValue nodeValue = (NodeValue)item;
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                for (Map.Entry<Object, Object> entry : qr.serialization.entrySet()) {
                    parameters.put(entry.getKey().toString(), entry.getValue().toString());
                }
                serializer.setProperties(this.toProperties(parameters));
                return serializer.serialize(nodeValue);
            }
            try {
                return item.getStringValue();
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    @Override
    public Map<String, Object> retrieveFirstChunk(int resultId, int num, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        boolean compression = this.useCompression(parameters);
        return this.withDb((broker, transaction) -> {
            OutputStream os;
            QueryResult qr = this.factory.resultSets.getResult(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out: " + resultId);
            }
            qr.touch();
            Item item = qr.result.itemAt(num);
            if (item == null) {
                throw new EXistException("index out of range");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            VirtualTempFile vtempFile = new VirtualTempFile(262144, 262144);
            vtempFile.setTempPrefix("eXistRPCC");
            vtempFile.setTempPostfix(".xml");
            if (compression) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("retrieveFirstChunk with compression");
                }
                os = new DeflaterOutputStream(vtempFile);
            } else {
                os = vtempFile;
            }
            try {
                try (OutputStreamWriter writer = new OutputStreamWriter(os, this.getEncoding(parameters));){
                    if (Type.subTypeOf(item.getType(), -1)) {
                        NodeValue nodeValue = (NodeValue)item;
                        Serializer serializer = broker.getSerializer();
                        serializer.reset();
                        for (Map.Entry<Object, Object> entry : qr.serialization.entrySet()) {
                            parameters.put(entry.getKey().toString(), entry.getValue().toString());
                        }
                        serializer.setProperties(this.toProperties(parameters));
                        serializer.serialize(nodeValue, (Writer)writer);
                    } else {
                        writer.write(item.getStringValue());
                    }
                }
                catch (XPathException e) {
                    throw new EXistException(e);
                }
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {}
                if (os != vtempFile) {
                    try {
                        vtempFile.close();
                    }
                    catch (IOException e) {}
                }
            }
            byte[] firstChunk = vtempFile.getChunk(0L);
            result.put("data", firstChunk);
            int offset = 0;
            if (vtempFile.length() > 262144L) {
                offset = firstChunk.length;
                int handle = this.factory.resultSets.add(new SerializedResult(vtempFile));
                result.put("handle", Integer.toString(handle));
                result.put("supports-long-offset", Boolean.TRUE);
            } else {
                vtempFile.delete();
            }
            result.put("offset", offset);
            return result;
        });
    }

    @Override
    public byte[] retrieveAll(int resultId, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        String xml = this.retrieveAllAsString(resultId, parameters);
        return xml.getBytes(this.getEncoding(parameters));
    }

    private String retrieveAllAsString(int resultId, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> {
            QueryResult qr = this.factory.resultSets.getResult(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.touch();
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(qr.serialization);
            SAXSerializer handler = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            StringWriter writer = new StringWriter();
            handler.setOutput(writer, this.toProperties(parameters));
            handler.startDocument();
            handler.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            handler.startPrefixMapping("xs", "http://www.w3.org/2001/XMLSchema");
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("", "hitCount", "hitCount", "CDATA", Integer.toString(qr.result.getItemCount()));
            handler.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", attribs);
            try {
                SequenceIterator i = qr.result.iterate();
                while (i.hasNext()) {
                    Item current = i.nextItem();
                    if (Type.subTypeOf(current.getType(), -1)) {
                        current.toSAX(broker, handler, null);
                        continue;
                    }
                    AttributesImpl typeAttr = new AttributesImpl();
                    typeAttr.addAttribute("", "type", "type", "CDATA", Type.getTypeName(current.getType()));
                    handler.startElement("http://exist.sourceforge.net/NS/exist", "value", "exist:value", typeAttr);
                    char[] value = current.toString().toCharArray();
                    handler.characters(value, 0, value.length);
                    handler.endElement("http://exist.sourceforge.net/NS/exist", "value", "exist:value");
                }
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
            handler.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
            handler.endPrefixMapping("xs");
            handler.endPrefixMapping("exist");
            handler.endDocument();
            SerializerPool.getInstance().returnObject(handler);
            return writer.toString();
        });
    }

    @Override
    public Map<String, Object> retrieveAllFirstChunk(int resultId, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        boolean compression = this.useCompression(parameters);
        return this.withDb((broker, transaction) -> {
            OutputStream os;
            QueryResult qr = this.factory.resultSets.getResult(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.touch();
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            for (Map.Entry<Object, Object> entry : qr.serialization.entrySet()) {
                parameters.put(entry.getKey().toString(), entry.getValue().toString());
            }
            serializer.setProperties(this.toProperties(parameters));
            SAXSerializer handler = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            HashMap<String, Object> result = new HashMap<String, Object>();
            VirtualTempFile vtempFile = new VirtualTempFile(262144, 262144);
            vtempFile.setTempPrefix("eXistRPCC");
            vtempFile.setTempPostfix(".xml");
            if (compression) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("retrieveAllFirstChunk compression");
                }
                os = new DeflaterOutputStream(vtempFile);
            } else {
                os = vtempFile;
            }
            try (OutputStreamWriter writer2 = new OutputStreamWriter(os, this.getEncoding(parameters));){
                handler.setOutput(writer2, this.toProperties(parameters));
                handler.startDocument();
                handler.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
                AttributesImpl attribs = new AttributesImpl();
                attribs.addAttribute("", "hitCount", "hitCount", "CDATA", Integer.toString(qr.result.getItemCount()));
                handler.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", attribs);
                try {
                    SequenceIterator i = qr.result.iterate();
                    while (i.hasNext()) {
                        Item current = i.nextItem();
                        if (Type.subTypeOf(current.getType(), -1)) {
                            ((NodeValue)current).toSAX(broker, handler, null);
                            continue;
                        }
                        char[] value = current.toString().toCharArray();
                        handler.characters(value, 0, value.length);
                    }
                }
                catch (XPathException e) {
                    throw new EXistException(e);
                }
                handler.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
                handler.endPrefixMapping("exist");
                handler.endDocument();
                SerializerPool.getInstance().returnObject(handler);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException writer2) {}
                if (os != vtempFile) {
                    try {
                        vtempFile.close();
                    }
                    catch (IOException writer2) {}
                }
            }
            byte[] firstChunk = vtempFile.getChunk(0L);
            result.put("data", firstChunk);
            int offset = 0;
            if (vtempFile.length() > 262144L) {
                offset = firstChunk.length;
                int handle = this.factory.resultSets.add(new SerializedResult(vtempFile));
                result.put("handle", Integer.toString(handle));
                result.put("supports-long-offset", Boolean.TRUE);
            } else {
                vtempFile.delete();
            }
            result.put("offset", offset);
            return result;
        });
    }

    @Override
    public boolean chgrp(String resource, String ownerGroup) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> permission.setGroup(ownerGroup)));
            return true;
        });
    }

    @Override
    public boolean chown(String resource, String owner) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> permission.setOwner(owner)));
            return true;
        });
    }

    @Override
    public boolean chown(String resource, String owner, String ownerGroup) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> {
                permission.setOwner(owner);
                permission.setGroup(ownerGroup);
            }));
            return true;
        });
    }

    @Override
    public boolean setPermissions(String resource, int permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> permission.setMode(permissions)));
            return true;
        });
    }

    @Override
    public boolean setPermissions(String resource, String permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> {
                try {
                    permission.setMode(permissions);
                }
                catch (SyntaxException se) {
                    throw new PermissionDeniedException("Unrecognised mode syntax: " + se.getMessage(), se);
                }
            }));
            return true;
        });
    }

    @Override
    public boolean setPermissions(String resource, String owner, String ownerGroup, String permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> {
                permission.setOwner(owner);
                permission.setGroup(ownerGroup);
                try {
                    permission.setMode(permissions);
                }
                catch (SyntaxException se) {
                    throw new PermissionDeniedException("Unrecognised mode syntax: " + se.getMessage(), se);
                }
            }));
            return true;
        });
    }

    @Override
    public boolean setPermissions(String resource, String owner, String ownerGroup, int permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> {
                permission.setOwner(owner);
                permission.setGroup(ownerGroup);
                permission.setMode(permissions);
            }));
            return true;
        });
    }

    @Override
    public boolean setPermissions(String resource, String owner, String group, int mode, List<ACEAider> aces) throws EXistException, PermissionDeniedException, URISyntaxException {
        XmldbURI uri = XmldbURI.xmldbUriFor(resource);
        return this.withDb((broker, transaction) -> {
            PermissionFactory.updatePermissions(broker, uri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> {
                permission.setOwner(owner);
                permission.setGroup(group);
                permission.setMode(mode);
                if (permission instanceof ACLPermission) {
                    ACLPermission aclPermission = (ACLPermission)((Object)permission);
                    aclPermission.clear();
                    for (ACEAider ace : aces) {
                        aclPermission.addACE(ace.getAccessType(), ace.getTarget(), ace.getWho(), ace.getMode());
                    }
                }
            }));
            return true;
        });
    }

    @Override
    public boolean addAccount(String name, String passwd, String passwdDigest, List<String> groups, Boolean enabled, Integer umask, Map<String, String> metadata) throws EXistException, PermissionDeniedException {
        SecurityManager manager;
        if (passwd.length() == 0) {
            passwd = null;
        }
        if ((manager = this.factory.getBrokerPool().getSecurityManager()).hasAccount(name)) {
            throw new PermissionDeniedException("Account '" + name + "' exist");
        }
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new PermissionDeniedException("Account '" + this.user.getName() + "' not allowed to create new account");
        }
        UserAider u = new UserAider(name);
        u.setEncodedPassword(passwd);
        u.setPasswordDigest(passwdDigest);
        for (String string : groups) {
            if (u.hasGroup(string)) continue;
            u.addGroup(string);
        }
        if (enabled != null) {
            u.setEnabled(enabled);
        }
        if (umask != null) {
            u.setUserMask(umask);
        }
        if (metadata != null) {
            for (Map.Entry entry : metadata.entrySet()) {
                if (AXSchemaType.valueOfNamespace((String)entry.getKey()) != null) {
                    u.setMetadataValue(AXSchemaType.valueOfNamespace((String)entry.getKey()), (String)entry.getValue());
                    continue;
                }
                if (EXistSchemaType.valueOfNamespace((String)entry.getKey()) == null) continue;
                u.setMetadataValue(EXistSchemaType.valueOfNamespace((String)entry.getKey()), (String)entry.getValue());
            }
        }
        this.withDb((broker, transaction) -> manager.addAccount(u));
        return true;
    }

    @Override
    public boolean updateAccount(String name, String passwd, String passwdDigest, List<String> groups) throws EXistException, PermissionDeniedException {
        return this.updateAccount(name, passwd, passwdDigest, groups, null, null, null);
    }

    @Override
    public boolean updateAccount(String name, String passwd, String passwdDigest, List<String> groups, Boolean enabled, Integer umask, Map<String, String> metadata) throws EXistException, PermissionDeniedException {
        if (passwd.length() == 0) {
            passwd = null;
        }
        UserAider account = new UserAider(name);
        account.setEncodedPassword(passwd);
        account.setPasswordDigest(passwdDigest);
        for (String string : groups) {
            account.addGroup(string);
        }
        if (enabled != null) {
            account.setEnabled(enabled);
        }
        if (umask != null) {
            account.setUserMask(umask);
        }
        if (metadata != null) {
            for (Map.Entry entry : metadata.entrySet()) {
                if (AXSchemaType.valueOfNamespace((String)entry.getKey()) != null) {
                    account.setMetadataValue(AXSchemaType.valueOfNamespace((String)entry.getKey()), (String)entry.getValue());
                    continue;
                }
                if (EXistSchemaType.valueOfNamespace((String)entry.getKey()) == null) continue;
                account.setMetadataValue(EXistSchemaType.valueOfNamespace((String)entry.getKey()), (String)entry.getValue());
            }
        }
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        this.withDb((broker, transaction) -> manager.updateAccount(account));
        return true;
    }

    @Override
    public boolean addGroup(String name, Map<String, String> metadata) throws EXistException, PermissionDeniedException {
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        if (!manager.hasGroup(name)) {
            if (!manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("Not allowed to create group");
            }
            GroupAider role = new GroupAider(name);
            for (Map.Entry<String, String> m : metadata.entrySet()) {
                if (AXSchemaType.valueOfNamespace(m.getKey()) != null) {
                    role.setMetadataValue(AXSchemaType.valueOfNamespace(m.getKey()), m.getValue());
                    continue;
                }
                if (EXistSchemaType.valueOfNamespace(m.getKey()) == null) continue;
                role.setMetadataValue(EXistSchemaType.valueOfNamespace(m.getKey()), m.getValue());
            }
            this.withDb((broker, transaction) -> manager.addGroup(broker, role));
            return true;
        }
        return false;
    }

    public boolean setUserPrimaryGroup(String username, String groupName) throws EXistException, PermissionDeniedException {
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        if (!manager.hasGroup(groupName)) {
            throw new EXistException("Group '" + groupName + "' does not exist!");
        }
        if (!manager.hasAdminPrivileges(this.user)) {
            throw new PermissionDeniedException("Not allowed to modify user");
        }
        this.withDb((broker, transaction) -> {
            Account account = manager.getAccount(username);
            Group group = manager.getGroup(groupName);
            account.setPrimaryGroup(group);
            manager.updateAccount(account);
            return null;
        });
        return true;
    }

    @Override
    public boolean updateGroup(String name, List<String> managers, Map<String, String> metadata) throws EXistException, PermissionDeniedException {
        SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
        if (manager.hasGroup(name)) {
            GroupAider group = new GroupAider(name);
            for (String string : managers) {
                group.addManager(new UserAider(string));
            }
            if (metadata != null) {
                for (Map.Entry entry : metadata.entrySet()) {
                    if (AXSchemaType.valueOfNamespace((String)entry.getKey()) != null) {
                        group.setMetadataValue(AXSchemaType.valueOfNamespace((String)entry.getKey()), (String)entry.getValue());
                        continue;
                    }
                    if (EXistSchemaType.valueOfNamespace((String)entry.getKey()) == null) continue;
                    group.setMetadataValue(EXistSchemaType.valueOfNamespace((String)entry.getKey()), (String)entry.getValue());
                }
            }
            this.withDb((broker, transaction) -> manager.updateGroup(group));
            return true;
        }
        return false;
    }

    @Override
    public List<String> getGroupMembers(String groupName) throws EXistException, PermissionDeniedException {
        return this.withDb((broker, transaction) -> broker.getBrokerPool().getSecurityManager().findAllGroupMembers(groupName));
    }

    @Override
    public void addAccountToGroup(String accountName, String groupName) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Account account = sm.getAccount(accountName);
            account.addGroup(groupName);
            sm.updateAccount(account);
            return null;
        });
    }

    @Override
    public void addGroupManager(String manager, String groupName) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Account account = sm.getAccount(manager);
            Group group = sm.getGroup(groupName);
            group.addManager(account);
            sm.updateGroup(group);
            return null;
        });
    }

    @Override
    public void removeGroupManager(String groupName, String manager) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Group group = sm.getGroup(groupName);
            Account account = sm.getAccount(manager);
            group.removeManager(account);
            sm.updateGroup(group);
            return null;
        });
    }

    public void removeGroupMember(String group, String member) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Account account = sm.getAccount(member);
            account.remGroup(group);
            sm.updateAccount(account);
            return null;
        });
    }

    public boolean updateAccount(String name, List<String> groups) throws EXistException, PermissionDeniedException {
        try {
            return this.withDb((broker, transaction) -> {
                SecurityManager manager = broker.getBrokerPool().getSecurityManager();
                Account u = !manager.hasAccount(name) ? new UserAider(name) : manager.getAccount(name);
                for (String g : groups) {
                    if (u.hasGroup(g)) continue;
                    u.addGroup(g);
                }
                return manager.updateAccount(u);
            });
        }
        catch (EXistException | PermissionDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addUserGroup encountered error", (Throwable)e);
            }
            return false;
        }
    }

    public boolean updateAccount(String name, List<String> groups, String rgroup) throws EXistException, PermissionDeniedException {
        try {
            return this.withDb((broker, transaction) -> {
                SecurityManager manager = broker.getBrokerPool().getSecurityManager();
                Account u = manager.getAccount(name);
                for (String g : groups) {
                    if (!g.equals(rgroup)) continue;
                    u.remGroup(g);
                }
                return manager.updateAccount(u);
            });
        }
        catch (EXistException | PermissionDeniedException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("removeGroup encountered error", (Throwable)ex);
            }
            return false;
        }
    }

    @Override
    public boolean lockResource(String documentPath, String userName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.lockResource(XmldbURI.xmldbUriFor(documentPath), userName);
    }

    private boolean lockResource(XmldbURI docURI, String userName) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeDocument(docURI).apply((document, broker, transaction) -> {
            if (!document.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + docURI);
            }
            SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
            if (!userName.equals(this.user.getName()) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("User " + this.user.getName() + " is not allowed to lock the resource for user " + userName);
            }
            Account lockOwner = document.getUserLock();
            if (lockOwner != null && !lockOwner.equals(this.user) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            document.setUserLock(this.user);
            broker.storeXMLResource(transaction, document);
            return true;
        });
    }

    @Override
    public String hasUserLock(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.hasUserLock(XmldbURI.xmldbUriFor(documentPath));
    }

    private String hasUserLock(XmldbURI docURI) throws EXistException, PermissionDeniedException {
        return (String)this.readDocument(docURI).apply((document, broker, transaction) -> {
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            Account u = document.getUserLock();
            return u == null ? "" : u.getName();
        });
    }

    @Override
    public boolean unlockResource(String documentPath) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.unlockResource(XmldbURI.xmldbUriFor(documentPath));
    }

    private boolean unlockResource(XmldbURI docURI) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeDocument(docURI).apply((document, broker, transaction) -> {
            if (!document.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + docURI);
            }
            SecurityManager manager = this.factory.getBrokerPool().getSecurityManager();
            Account lockOwner = document.getUserLock();
            if (lockOwner != null && !lockOwner.equals(this.user) && !manager.hasAdminPrivileges(this.user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            document.setUserLock(null);
            broker.storeXMLResource(transaction, document);
            return true;
        });
    }

    public Map<String, Object> summary(String xpath) throws EXistException, PermissionDeniedException {
        StringSource source = new StringSource(xpath);
        return this.withDb((broker, transaction) -> {
            long startTime = System.currentTimeMillis();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            try {
                QueryResult qr = (QueryResult)this.compileQuery(broker, transaction, source, parameters).apply(compiledQuery -> this.doQuery(broker, compiledQuery, null, parameters));
                if (qr == null) {
                    return new HashMap();
                }
                if (qr.hasErrors()) {
                    throw qr.getException();
                }
                HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
                HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
                SequenceIterator i = qr.result.iterate();
                while (i.hasNext()) {
                    DoctypeCount doctypeCounter;
                    NodeCount counter;
                    Object nv;
                    Item item = i.nextItem();
                    if (!Type.subTypeOf(item.getType(), -1) || (nv = (NodeValue)item).getImplementationType() != 1) continue;
                    NodeProxy p = (NodeProxy)nv;
                    String docName = p.getOwnerDocument().getURI().toString();
                    DocumentType doctype = p.getOwnerDocument().getDoctype();
                    if (map.containsKey(docName)) {
                        counter = (NodeCount)map.get(docName);
                        counter.inc();
                    } else {
                        counter = new NodeCount(p.getOwnerDocument());
                        map.put(docName, counter);
                    }
                    if (doctype == null) continue;
                    if (doctypes.containsKey(doctype.getName())) {
                        doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                        doctypeCounter.inc();
                        continue;
                    }
                    doctypeCounter = new DoctypeCount(doctype);
                    doctypes.put(doctype.getName(), doctypeCounter);
                }
                HashMap<String, Serializable> result = new HashMap<String, Serializable>();
                result.put("queryTime", Long.valueOf(System.currentTimeMillis() - startTime));
                result.put("hits", Integer.valueOf(qr.result.getItemCount()));
                ArrayList documents = new ArrayList();
                for (NodeCount nodeCounter : map.values()) {
                    ArrayList<Object> hitsByDoc = new ArrayList<Object>();
                    hitsByDoc.add(nodeCounter.doc.getFileURI().toString());
                    hitsByDoc.add(nodeCounter.doc.getDocId());
                    hitsByDoc.add(nodeCounter.count);
                    documents.add(hitsByDoc);
                }
                result.put("documents", documents);
                ArrayList dtypes = new ArrayList();
                for (DoctypeCount docTemp : doctypes.values()) {
                    ArrayList<Object> hitsByType = new ArrayList<Object>();
                    hitsByType.add(docTemp.doctype.getName());
                    hitsByType.add(docTemp.count);
                    dtypes.add(hitsByType);
                }
                result.put("doctypes", dtypes);
                return result;
            }
            catch (XPathException e) {
                throw new EXistException(e);
            }
        });
    }

    public Map<String, Object> summary(int resultId) throws EXistException, XPathException {
        QueryResult qr = this.factory.resultSets.getResult(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.touch();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("queryTime", qr.queryTime);
        if (qr.result == null) {
            result.put("hits", 0);
            return result;
        }
        HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
        HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
        SequenceIterator i = qr.result.iterate();
        while (i.hasNext()) {
            DoctypeCount doctypeCounter;
            NodeCount counter;
            NodeValue nv;
            Item item = i.nextItem();
            if (!Type.subTypeOf(item.getType(), -1) || (nv = (NodeValue)item).getImplementationType() != 1) continue;
            NodeProxy p = (NodeProxy)nv;
            String docName = p.getOwnerDocument().getURI().toString();
            DocumentType doctype = p.getOwnerDocument().getDoctype();
            if (map.containsKey(docName)) {
                counter = (NodeCount)map.get(docName);
                counter.inc();
            } else {
                counter = new NodeCount(p.getOwnerDocument());
                map.put(docName, counter);
            }
            if (doctype == null) continue;
            if (doctypes.containsKey(doctype.getName())) {
                doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                doctypeCounter.inc();
                continue;
            }
            doctypeCounter = new DoctypeCount(doctype);
            doctypes.put(doctype.getName(), doctypeCounter);
        }
        result.put("hits", qr.result.getItemCount());
        ArrayList documents = new ArrayList();
        for (NodeCount nodeCounter : map.values()) {
            ArrayList<Object> hitsByDoc = new ArrayList<Object>();
            hitsByDoc.add(nodeCounter.doc.getFileURI().toString());
            hitsByDoc.add(nodeCounter.doc.getDocId());
            hitsByDoc.add(nodeCounter.count);
            documents.add(hitsByDoc);
        }
        result.put("documents", documents);
        ArrayList dtypes = new ArrayList();
        for (DoctypeCount docTemp : doctypes.values()) {
            ArrayList<Object> hitsByType = new ArrayList<Object>();
            hitsByType.add(docTemp.doctype.getName());
            hitsByType.add(docTemp.count);
            dtypes.add(hitsByType);
        }
        result.put("doctypes", dtypes);
        return result;
    }

    @Override
    public List<List> getIndexedElements(String collectionName, boolean inclusive) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getIndexedElements(XmldbURI.xmldbUriFor(collectionName), inclusive);
    }

    private List<List> getIndexedElements(XmldbURI collUri, boolean inclusive) throws EXistException, PermissionDeniedException {
        return (List)this.readCollection(collUri).apply((collection, broker, transaction) -> {
            Occurrences[] occurrences = broker.getElementIndex().scanIndexedElements(collection, inclusive);
            ArrayList result = new ArrayList(occurrences.length);
            for (Occurrences occurrence : occurrences) {
                QName qname = (QName)occurrence.getTerm();
                ArrayList<Object> temp = new ArrayList<Object>(4);
                temp.add(qname.getLocalPart());
                temp.add(qname.getNamespaceURI());
                temp.add(qname.getPrefix() == null ? "" : qname.getPrefix());
                temp.add(occurrence.getOccurrences());
                result.add(temp);
            }
            return result;
        });
    }

    public void synchronize() {
    }

    private Properties toProperties(Map<String, Object> parameters) {
        Properties properties = new Properties();
        properties.putAll(parameters);
        return properties;
    }

    @Override
    public byte[] getDocumentChunk(String name, int start, int len) throws EXistException, PermissionDeniedException, IOException {
        Path file = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(name);
        if (!Files.isReadable(file)) {
            throw new EXistException("unable to read file " + name);
        }
        if (FileUtils.sizeQuietly(file) < (long)(start + len)) {
            throw new EXistException("address too big " + name);
        }
        byte[] buffer = new byte[len];
        try (RandomAccessFile os = new RandomAccessFile(file.toFile(), "r");){
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read from: " + start + " to: " + (start + len));
            }
            os.seek(start);
            os.read(buffer);
        }
        return buffer;
    }

    public boolean moveOrCopyResource(String documentPath, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyResource(XmldbURI.xmldbUriFor(documentPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName), move);
    }

    private boolean moveOrCopyResource(XmldbURI docUri, XmldbURI destUri, XmldbURI newName, boolean move) throws EXistException, PermissionDeniedException {
        Lock.LockMode srcCollectionMode = move || docUri.removeLastSegment().equals(destUri) ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK;
        return this.withDb((broker, transaction) -> (Boolean)this.withCollection(srcCollectionMode, broker, transaction, docUri.removeLastSegment()).apply((source, broker1, transaction1) -> (Boolean)this.writeDocument(broker1, transaction1, source, docUri).apply((document, broker2, transaction2) -> (Boolean)this.writeCollection(broker2, transaction2, destUri).apply((destination, broker3, transaction3) -> {
            if (move) {
                broker3.moveResource(transaction3, document, destination, newName);
            } else {
                broker3.copyResource(transaction3, document, destination, newName);
            }
            return true;
        }))));
    }

    public boolean moveOrCopyCollection(String collectionName, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyCollection(XmldbURI.xmldbUriFor(collectionName), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName), move);
    }

    private boolean moveOrCopyCollection(XmldbURI collUri, XmldbURI destUri, XmldbURI newName, boolean move) throws EXistException, PermissionDeniedException {
        Lock.LockMode srcCollectionMode = move || collUri.equals(destUri) ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK;
        return this.withDb((broker, transaction) -> (Boolean)this.withCollection(srcCollectionMode, broker, transaction, collUri).apply((source, broker1, transaction1) -> (Boolean)this.writeCollection(broker1, transaction1, destUri).apply((destination, broker2, transaction2) -> {
            if (move) {
                broker2.moveCollection(transaction2, source, destination, newName);
            } else {
                broker2.copyCollection(transaction2, source, destination, newName);
            }
            return true;
        })));
    }

    @Override
    public boolean reindexCollection(String collectionName) throws URISyntaxException, EXistException, PermissionDeniedException {
        this.reindexCollection(XmldbURI.xmldbUriFor(collectionName));
        return true;
    }

    private void reindexCollection(XmldbURI collUri) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            broker.reindexCollection(collUri);
            if (LOG.isDebugEnabled()) {
                LOG.debug("collection " + collUri + " and sub-collections reindexed");
            }
            return null;
        });
    }

    @Override
    public boolean reindexDocument(String docUri) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            DocumentImpl doc = null;
            try {
                doc = broker.getXMLResource(XmldbURI.create(docUri), Lock.LockMode.READ_LOCK);
                broker.reindexXMLResource(transaction, doc, DBBroker.IndexMode.STORE);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("document " + docUri + " reindexed");
                }
                Object var4_4 = null;
                return var4_4;
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        });
        return true;
    }

    @Override
    public boolean backup(String userbackup, String password, String destcollection, String collection) throws EXistException, PermissionDeniedException {
        try {
            Backup backup = new Backup(userbackup, password, Paths.get(destcollection + "-backup", new String[0]), XmldbURI.xmldbUriFor(XmldbURI.EMBEDDED_SERVER_URI.toString() + collection));
            backup.backup(false, null);
        }
        catch (IOException | URISyntaxException | SAXException | XMLDBException e) {
            throw new EXistException(e);
        }
        return true;
    }

    @Override
    public boolean isValid(String documentPath) throws PermissionDeniedException, URISyntaxException, EXistException {
        return this.isValid(XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValid(XmldbURI docUri) throws EXistException, PermissionDeniedException {
        try {
            Validator validator = new Validator(this.factory.getBrokerPool());
            try (EmbeddedInputStream is = new EmbeddedInputStream(new XmldbURL(docUri));){
                ValidationReport report = validator.validate(is);
                boolean bl = report.isValid();
                return bl;
            }
        }
        catch (IOException e) {
            throw new EXistException(e);
        }
    }

    @Override
    public List<String> getDocType(String documentPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getDocType(XmldbURI.xmldbUriFor(documentPath));
    }

    private List<String> getDocType(XmldbURI docUri) throws PermissionDeniedException, EXistException {
        return (List)this.readDocument(docUri).apply((document, broker, transaction) -> {
            ArrayList<String> list = new ArrayList<String>(3);
            if (document.getDoctype() != null) {
                list.add(document.getDoctype().getName());
                if (document.getDoctype().getPublicId() != null) {
                    list.add(document.getDoctype().getPublicId());
                } else {
                    list.add("");
                }
                if (document.getDoctype().getSystemId() != null) {
                    list.add(document.getDoctype().getSystemId());
                } else {
                    list.add("");
                }
            } else {
                list.add("");
                list.add("");
                list.add("");
            }
            return list;
        });
    }

    @Override
    public boolean setDocType(String documentPath, String doctypename, String publicid, String systemid) throws URISyntaxException, EXistException, PermissionDeniedException {
        return this.setDocType(XmldbURI.xmldbUriFor(documentPath), doctypename, publicid, systemid);
    }

    private boolean setDocType(XmldbURI docUri, String doctypename, String publicid, String systemid) throws EXistException, PermissionDeniedException {
        return (Boolean)this.writeDocument(docUri).apply((document, broker, transaction) -> {
            if (!document.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + docUri);
            }
            DocumentTypeImpl result = null;
            if (!"".equals(doctypename)) {
                result = new DocumentTypeImpl(doctypename, "".equals(publicid) ? null : publicid, "".equals(systemid) ? null : systemid);
            }
            document.setDocumentType(result);
            broker.storeXMLResource(transaction, document);
            return true;
        });
    }

    @Override
    public boolean copyResource(String docPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyResource(docPath, destinationPath, newName, false);
    }

    @Override
    public boolean copyCollection(String collectionPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyCollection(collectionPath, destinationPath, newName, false);
    }

    @Override
    public boolean moveResource(String docPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyResource(docPath, destinationPath, newName, true);
    }

    @Override
    public boolean moveCollection(String collectionPath, String destinationPath, String newName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyCollection(collectionPath, destinationPath, newName, true);
    }

    @Override
    public List<String> getDocumentChunk(String name, Map<String, Object> parameters) throws EXistException, PermissionDeniedException, IOException {
        ArrayList<String> result = new ArrayList<String>(2);
        File file = File.createTempFile("rpc", ".xml");
        file.deleteOnExit();
        try (FileOutputStream os = new FileOutputStream(file.getAbsolutePath(), true);){
            os.write(this.getDocument(name, parameters));
        }
        result.add(file.getName());
        result.add(Long.toString(file.length()));
        return result;
    }

    @Override
    public boolean copyCollection(String name, String namedest) throws PermissionDeniedException, EXistException {
        try {
            String nome;
            this.createCollection(namedest);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("indent", "no");
            parameters.put("expand-xincludes", "no");
            parameters.put("encoding", DEFAULT_ENCODING);
            Map<String, Object> desc = this.getCollectionDesc(name);
            Object[] collections = (Object[])desc.get("collections");
            Object[] documents = (Object[])desc.get("documents");
            for (Object collection : collections) {
                nome = collection.toString();
                this.createCollection(namedest + "/" + nome);
                this.copyCollection(name + "/" + nome, namedest + "/" + nome);
            }
            int dsize = documents.length;
            for (int i = 0; i < dsize; ++i) {
                Map hash = (Map)documents[i];
                nome = (String)hash.get("name");
                int p = nome.lastIndexOf("/");
                if (p != -1) {
                    nome = nome.substring(p + 1);
                }
                byte[] xml = this.getDocument(name + "/" + nome, parameters);
                this.parse(xml, namedest + "/" + nome);
            }
            return true;
        }
        catch (URISyntaxException e) {
            throw new EXistException(e);
        }
    }

    @Override
    public int xupdateResource(String resource, byte[] xupdate) throws PermissionDeniedException, EXistException, SAXException {
        return this.xupdateResource(resource, xupdate, DEFAULT_ENCODING.name());
    }

    @Override
    public Map<String, Object> querySummary(int resultId) throws EXistException, PermissionDeniedException, XPathException {
        return this.summary(resultId);
    }

    @Override
    public int executeQuery(byte[] xpath, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return this.executeQuery(xpath, null, parameters);
    }

    @Override
    public boolean storeBinary(byte[] data, String docName, String mimeType, boolean replace, Date created, Date modified) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.storeBinary(data, docName, mimeType, replace ? 1 : 0, created, modified);
    }

    @Override
    public boolean storeBinary(byte[] data, String docName, String mimeType, boolean replace) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.storeBinary(data, docName, mimeType, replace ? 1 : 0, null, null);
    }

    @Override
    public boolean parseLocalExt(String localFile, String docName, boolean replace, String mimeType, boolean treatAsXML, Date created, Date modified) throws EXistException, PermissionDeniedException, SAXException, URISyntaxException {
        return this.parseLocalExt(localFile, docName, replace ? 1 : 0, mimeType, treatAsXML ? 1 : 0, created, modified);
    }

    @Override
    public boolean parseLocal(String localFile, String docName, boolean replace, String mimeType, Date created, Date modified) throws EXistException, PermissionDeniedException, SAXException, URISyntaxException {
        return this.parseLocal(localFile, docName, replace ? 1 : 0, mimeType, created, modified);
    }

    @Override
    public boolean parseLocalExt(String localFile, String docName, boolean replace, String mimeType, boolean treatAsXML) throws EXistException, PermissionDeniedException, SAXException, URISyntaxException {
        return this.parseLocalExt(localFile, docName, replace ? 1 : 0, mimeType, treatAsXML ? 1 : 0, null, null);
    }

    @Override
    public boolean parseLocal(String localFile, String docName, boolean replace, String mimeType) throws EXistException, PermissionDeniedException, SAXException, URISyntaxException {
        return this.parseLocal(localFile, docName, replace ? 1 : 0, mimeType, null, null);
    }

    @Override
    public String uploadCompressed(String file, byte[] data, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(data, length, file, true);
    }

    @Override
    public String uploadCompressed(byte[] data, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(data, length, null, true);
    }

    @Override
    public String upload(String file, byte[] chunk, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(chunk, length, file, false);
    }

    @Override
    public String upload(byte[] chunk, int length) throws EXistException, PermissionDeniedException, IOException {
        return this.upload(chunk, length, null, false);
    }

    @Override
    public boolean parse(String xml, String docName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.parse(xml.getBytes(DEFAULT_ENCODING), docName, 0);
    }

    @Override
    public boolean parse(String xml, String docName, int overwrite) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.parse(xml.getBytes(DEFAULT_ENCODING), docName, overwrite);
    }

    @Override
    public boolean parse(byte[] xmlData, String docName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.parse(xmlData, docName, 0);
    }

    @Override
    public Map<String, Object> querySummary(String xquery) throws EXistException, PermissionDeniedException {
        return this.summary(xquery);
    }

    @Override
    public byte[] query(byte[] xquery, int howmany, int start, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        String result = this.query(new String(xquery, DEFAULT_ENCODING), howmany, start, parameters);
        return result.getBytes(this.getEncoding(parameters));
    }

    @Override
    @Deprecated
    public Map<String, Object> queryP(byte[] xpath, String docName, String s_id, Map<String, Object> parameters) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.queryP(new String(xpath, DEFAULT_ENCODING), docName, s_id, parameters);
    }

    @Override
    @Deprecated
    public Map<String, Object> queryP(byte[] xpath, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return this.queryP(new String(xpath, DEFAULT_ENCODING), (XmldbURI)null, null, parameters);
    }

    @Override
    public Map<String, Object> compile(byte[] xquery, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return this.compile(new String(xquery, DEFAULT_ENCODING), parameters);
    }

    @Override
    public byte[] retrieve(String doc, String id) throws EXistException, PermissionDeniedException {
        return this.retrieve(doc, id, null);
    }

    @Override
    public String getDocumentAsString(String name, int prettyPrint, String stylesheet) throws EXistException, PermissionDeniedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("indent", prettyPrint > 0 ? "yes" : "no");
        if (stylesheet != null) {
            parameters.put("stylesheet", stylesheet);
        }
        return this.getDocumentAsString(name, parameters);
    }

    @Override
    public String getDocumentAsString(String name, int prettyPrint) throws EXistException, PermissionDeniedException {
        return this.getDocumentAsString(name, prettyPrint, null);
    }

    @Override
    public byte[] getDocument(String name, String encoding, int prettyPrint, String stylesheet) throws EXistException, PermissionDeniedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("indent", prettyPrint > 0 ? "yes" : "no");
        if (stylesheet != null) {
            parameters.put("stylesheet", stylesheet);
        }
        parameters.put("encoding", encoding);
        return this.getDocument(name, parameters);
    }

    @Override
    public byte[] getDocument(String name, String encoding, int prettyPrint) throws EXistException, PermissionDeniedException {
        return this.getDocument(name, encoding, prettyPrint, null);
    }

    @Override
    public boolean setTriggersEnabled(String path, String value) throws EXistException, PermissionDeniedException {
        boolean triggersEnabled = Boolean.parseBoolean(value);
        return this.withDb((broker, transaction) -> {
            Collection collection = broker.getCollection(XmldbURI.create(path));
            if (collection == null) {
                return false;
            }
            collection.setTriggersEnabled(triggersEnabled);
            return true;
        });
    }

    @Override
    public boolean shutdown() throws PermissionDeniedException {
        this.factory.getBrokerPool().shutdown();
        return true;
    }

    @Override
    public boolean shutdown(String delay) throws PermissionDeniedException {
        return this.shutdown(Long.parseLong(delay));
    }

    @Override
    public boolean shutdown(long delay) throws PermissionDeniedException {
        if (!this.user.hasDbaRole()) {
            throw new PermissionDeniedException("not allowed to shut downthe database");
        }
        SystemTaskJobImpl shutdownJob = new SystemTaskJobImpl("rpc-api.shutdown", new ShutdownTask());
        return this.factory.getBrokerPool().getScheduler().createPeriodicJob(0L, shutdownJob, delay, new Properties(), 0);
    }

    public boolean enterServiceMode() throws PermissionDeniedException, EXistException {
        BrokerPool brokerPool = this.factory.getBrokerPool();
        brokerPool.enterServiceMode(this.user);
        return true;
    }

    public void exitServiceMode() throws PermissionDeniedException, EXistException {
        BrokerPool brokerPool = this.factory.getBrokerPool();
        brokerPool.exitServiceMode(this.user);
    }

    @Override
    public void runCommand(XmldbURI collectionURI, List<String> params) throws EXistException, PermissionDeniedException {
        this.withDb((broker, transaction) -> {
            Commands.command(collectionURI, params.toArray(new String[params.size()]));
            return null;
        });
    }

    private Charset getEncoding(Map<String, Object> parameters) {
        return Optional.ofNullable(parameters.get("encoding")).map(p -> Charset.forName(p.toString())).orElse(DEFAULT_ENCODING);
    }

    private boolean useCompression(Map<String, Object> parameters) {
        return Optional.ofNullable(parameters.get("compress-output")).map(c -> c.toString().equalsIgnoreCase("yes")).orElse(false);
    }

    private <R> Function3E<XmlRpcCompiledXQueryFunction<R>, R, EXistException, PermissionDeniedException, XPathException> compileQuery(DBBroker broker, Txn transaction, Source source, Map<String, Object> parameters) throws EXistException, PermissionDeniedException {
        return compiledOp -> {
            XQueryPool pool = broker.getBrokerPool().getXQueryPool();
            CompiledXQuery compiled = null;
            try {
                compiled = this.compile(broker, source, parameters);
                Object r = compiledOp.apply(compiled);
                return r;
            }
            catch (IOException e) {
                throw new EXistException(e);
            }
            finally {
                if (compiled != null) {
                    compiled.getContext().runCleanupTasks();
                    pool.returnCompiledXQuery(source, compiled);
                }
            }
        };
    }

    private <R> Function2E<XmlRpcCollectionFunction<R>, R, EXistException, PermissionDeniedException> readCollection(XmldbURI uri) throws EXistException, PermissionDeniedException {
        return readOp -> this.withDb((broker, transaction) -> this.readCollection(broker, transaction, uri).apply(readOp));
    }

    private <R> Function2E<XmlRpcCollectionFunction<R>, R, EXistException, PermissionDeniedException> readCollection(DBBroker broker, Txn transaction, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return this.withCollection(Lock.LockMode.READ_LOCK, broker, transaction, uri);
    }

    private <R> Function2E<XmlRpcCollectionFunction<R>, R, EXistException, PermissionDeniedException> writeCollection(XmldbURI uri) throws EXistException, PermissionDeniedException {
        return writeOp -> this.withDb((broker, transaction) -> this.writeCollection(broker, transaction, uri).apply(writeOp));
    }

    private <R> Function2E<XmlRpcCollectionFunction<R>, R, EXistException, PermissionDeniedException> writeCollection(DBBroker broker, Txn transaction, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return this.withCollection(Lock.LockMode.WRITE_LOCK, broker, transaction, uri);
    }

    private <R> Function2E<XmlRpcCollectionFunction<R>, R, EXistException, PermissionDeniedException> withCollection(Lock.LockMode lockMode, DBBroker broker, Txn transaction, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return readOp -> {
            Collection collection = null;
            try {
                collection = broker.openCollection(uri, lockMode);
                if (collection == null) {
                    String msg = "collection " + uri + " not found!";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msg);
                    }
                    throw new EXistException(msg);
                }
                Object r = readOp.apply(collection, broker, transaction);
                return r;
            }
            finally {
                if (collection != null) {
                    collection.release(lockMode);
                }
            }
        };
    }

    private <R> Function2E<XmlRpcDocumentFunction<R>, R, EXistException, PermissionDeniedException> readDocument(XmldbURI uri) throws EXistException, PermissionDeniedException {
        return readOp -> this.withDb((broker, transaction) -> this.readDocument(broker, transaction, uri).apply(readOp));
    }

    private <R> Function2E<XmlRpcDocumentFunction<R>, R, EXistException, PermissionDeniedException> readDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return this.withDocument(Lock.LockMode.READ_LOCK, broker, transaction, uri);
    }

    private <R> Function2E<XmlRpcDocumentFunction<R>, R, EXistException, PermissionDeniedException> writeDocument(XmldbURI uri) throws EXistException, PermissionDeniedException {
        return writeOp -> this.withDb((broker, transaction) -> this.writeDocument(broker, transaction, uri).apply(writeOp));
    }

    private <R> Function2E<XmlRpcDocumentFunction<R>, R, EXistException, PermissionDeniedException> writeDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return this.withDocument(Lock.LockMode.WRITE_LOCK, broker, transaction, uri);
    }

    private <R> Function2E<XmlRpcDocumentFunction<R>, R, EXistException, PermissionDeniedException> writeDocument(DBBroker broker, Txn transaction, Collection collection, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return this.withDocument(Lock.LockMode.WRITE_LOCK, broker, transaction, collection, uri);
    }

    private <R> Function2E<XmlRpcDocumentFunction<R>, R, EXistException, PermissionDeniedException> withDocument(Lock.LockMode lockMode, DBBroker broker, Txn transaction, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return withOp -> this.readCollection(broker, transaction, uri.removeLastSegment()).apply((collection, broker1, transaction1) -> this.withDocument(lockMode, broker1, transaction1, collection, uri).apply(withOp));
    }

    private <R> Function2E<XmlRpcDocumentFunction<R>, R, EXistException, PermissionDeniedException> withDocument(Lock.LockMode lockMode, DBBroker broker, Txn transaction, Collection collection, XmldbURI uri) throws EXistException, PermissionDeniedException {
        return readOp -> {
            DocumentImpl document = null;
            try {
                document = collection.getDocumentWithLock(broker, uri.lastSegment(), lockMode);
                if (document == null) {
                    String msg = "document " + uri + " not found!";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(msg);
                    }
                    throw new EXistException(msg);
                }
                Object msg = readOp.apply(document, broker, transaction);
                return msg;
            }
            catch (LockException e) {
                throw new EXistException(e);
            }
            finally {
                if (document != null) {
                    collection.releaseDocument(document, lockMode);
                }
            }
        };
    }

    private <R> R withDbAsSystem(XmlRpcFunction<R> dbOperation) throws EXistException, PermissionDeniedException {
        return this.withDb(this.factory.getBrokerPool().getSecurityManager().getSystemSubject(), dbOperation);
    }

    private <R> R withDb(XmlRpcFunction<R> dbOperation) throws EXistException, PermissionDeniedException {
        return this.withDb(this.user, dbOperation);
    }

    /*
     * Exception decompiling
     */
    private <R> R withDb(Subject user, XmlRpcFunction<R> dbOperation) throws EXistException, PermissionDeniedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class NodeCount {
        int count = 1;
        final DocumentImpl doc;

        public NodeCount(DocumentImpl doc) {
            this.doc = doc;
        }

        public void inc() {
            ++this.count;
        }
    }

    static class DoctypeCount {
        int count = 1;
        final DocumentType doctype;

        public DoctypeCount(DocumentType doctype) {
            this.doctype = doctype;
        }

        public void inc() {
            ++this.count;
        }
    }

    static class CachedQuery {
        final PathExpr expression;
        final String queryString;
        final long timestamp;

        public CachedQuery(PathExpr expr, String query) {
            this.expression = expr;
            this.queryString = query;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

