/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.Expression;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Type;

public class AnalyzeContextInfo {
    private XQueryContext context = null;
    private Expression parent = null;
    private int flags = 0;
    private int contextId = -1;
    private int staticType = 11;
    private int staticReturnType = 11;
    private Expression contextStep = null;

    public AnalyzeContextInfo() {
    }

    public AnalyzeContextInfo(Expression parent, int flags) {
        this.parent = parent;
        this.flags = flags;
    }

    public AnalyzeContextInfo(AnalyzeContextInfo other) {
        this.parent = other.parent;
        this.flags = other.flags;
        this.contextId = other.contextId;
        this.contextStep = other.contextStep;
        this.staticType = other.staticType;
        this.context = other.context;
    }

    public AnalyzeContextInfo(XQueryContext context) {
        this.context = context;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    public int getContextId() {
        return this.contextId;
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlag(int flag) {
        this.flags |= flag;
    }

    public void removeFlag(int flag) {
        this.flags &= ~flag;
    }

    public Expression getParent() {
        return this.parent;
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    public int getStaticType() {
        return this.staticType;
    }

    public void setStaticType(int staticType) {
        this.staticType = staticType;
    }

    public int getStaticReturnType() {
        return this.staticReturnType;
    }

    public void setStaticReturnType(int type) {
        this.staticReturnType = type;
    }

    public void setContextStep(Expression step) {
        this.contextStep = step;
    }

    public Expression getContextStep() {
        return this.contextStep;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ID: ").append(this.contextId);
        buf.append(" Type: ").append(Type.getTypeName(this.staticType)).append(" Flags: ");
        if ((this.flags & 1) > 0) {
            buf.append("single ");
        }
        if ((this.flags & 2) > 0) {
            buf.append("in-predicate ");
        }
        if ((this.flags & 4) > 0) {
            buf.append("in-where-clause ");
        }
        if ((this.flags & 8) > 0) {
            buf.append("in-update ");
        }
        if ((this.flags & 0x80) > 0) {
            buf.append("dot-test ");
        }
        buf.append('(').append(this.flags).append(')');
        return buf.toString();
    }
}

