/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.NamedFunctionReference;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class ArrowOperator
extends AbstractExpression {
    private QName qname = null;
    private Expression leftExpr;
    private FunctionCall fcall = null;
    private Expression funcSpec = null;
    private List<Expression> parameters;
    private AnalyzeContextInfo cachedContextInfo;

    public ArrowOperator(XQueryContext context, Expression leftExpr) throws XPathException {
        super(context);
        this.leftExpr = leftExpr;
    }

    public void setArrowFunction(String fname, List<Expression> params) throws XPathException {
        try {
            this.qname = QName.parse(this.context, fname, this.context.getDefaultFunctionNamespace());
            this.parameters = params;
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + fname);
        }
    }

    public void setArrowFunction(PathExpr funcSpec, List<Expression> params) {
        this.funcSpec = funcSpec.simplify();
        this.parameters = params;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (this.getContext().getXQueryVersion() < 31) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0003, "arrow operator is not available before XQuery 3.1");
        }
        if (this.qname != null) {
            this.fcall = NamedFunctionReference.lookupFunction(this, this.context, this.qname, this.parameters.size() + 1);
        }
        this.cachedContextInfo = contextInfo;
        this.leftExpr.analyze(contextInfo);
        if (this.fcall != null) {
            this.fcall.analyze(contextInfo);
        }
        if (this.funcSpec != null) {
            this.funcSpec.analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        FunctionReference fref;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        contextSequence = this.leftExpr.eval(contextSequence);
        if (this.fcall != null) {
            fref = new FunctionReference(this.fcall);
        } else {
            Sequence funcSeq = this.funcSpec.eval(contextSequence, contextItem);
            if (funcSeq.getCardinality() != 2) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Expected exactly one item for the function to be called, got " + funcSeq.getItemCount() + ". Expression: " + ExpressionDumper.dump(this.funcSpec));
            }
            Item item0 = funcSeq.itemAt(0);
            if (!Type.subTypeOf(item0.getType(), 101)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Type error: expected function, got " + Type.getTypeName(item0.getType()));
            }
            fref = (FunctionReference)item0;
        }
        ArrayList<Expression> fparams = new ArrayList<Expression>(this.parameters.size() + 1);
        fparams.add(new ContextParam(this.context, contextSequence));
        fparams.addAll(this.parameters);
        fref.setArguments(fparams);
        fref.analyze(new AnalyzeContextInfo(this.cachedContextInfo));
        Sequence result = fref.eval(contextSequence);
        fref.resetState(false);
        return result;
    }

    @Override
    public int returnsType() {
        return this.fcall == null ? 11 : this.fcall.returnsType();
    }

    @Override
    public int getCardinality() {
        return this.fcall == null ? super.getCardinality() : this.fcall.getCardinality();
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.leftExpr.dump(dumper);
        dumper.display(" => ");
        if (this.fcall != null) {
            dumper.display(this.fcall.getFunction().getName()).display('(');
        } else {
            this.funcSpec.dump(dumper);
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i <= 0) continue;
            dumper.display(", ");
            this.parameters.get(i).dump(dumper);
        }
        dumper.display(')');
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.leftExpr.resetState(postOptimization);
        if (this.fcall != null) {
            this.fcall.resetState(postOptimization);
        }
        if (this.funcSpec != null) {
            this.funcSpec.resetState(postOptimization);
        }
        for (Expression param : this.parameters) {
            param.resetState(postOptimization);
        }
    }

    private class ContextParam
    extends Function.Placeholder {
        private Sequence sequence;

        ContextParam(XQueryContext context, Sequence sequence) {
            super(context);
            this.sequence = sequence;
        }

        @Override
        public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        }

        @Override
        public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
            return this.sequence;
        }

        @Override
        public int returnsType() {
            return this.sequence.getItemType();
        }

        @Override
        public void dump(ExpressionDumper dumper) {
        }
    }
}

