/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class Atomize
extends AbstractExpression {
    private final Expression expression;

    public Atomize(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence result = Atomize.atomize(this.expression.eval(contextSequence, contextItem));
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static Sequence atomize(Sequence input) throws XPathException {
        if (input.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if ((input = ArrayType.flatten(input)).hasOne()) {
            return input.itemAt(0).atomize();
        }
        ValueSequence result = new ValueSequence();
        SequenceIterator i = input.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            result.add(next.atomize());
        }
        return result;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("atomize[");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display("]");
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public int returnsType() {
        return 20;
    }

    @Override
    public int getDependencies() {
        return this.expression.getDependencies();
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public int getLine() {
        return this.expression.getLine();
    }

    @Override
    public int getColumn() {
        return this.expression.getColumn();
    }

    @Override
    public int getSubExpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubExpression(int index) {
        if (index == 0) {
            return this.expression;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSubExpressionCount());
    }
}

