/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;

public class AttributeConstructor
extends NodeConstructor {
    final String qname;
    public final List<Object> contents = new ArrayList<Object>(5);
    boolean isNamespaceDecl = false;

    public AttributeConstructor(XQueryContext context, String name) {
        super(context);
        if (name.startsWith("xmlns")) {
            this.isNamespaceDecl = true;
        }
        this.qname = name;
    }

    public void addValue(String value) {
        this.contents.add(value);
    }

    public void addEnclosedExpr(Expression expr) throws XPathException {
        if (this.isNamespaceDecl) {
            throw new XPathException((Expression)this, "enclosed expressions are not allowed in namespace declaration attributes");
        }
        this.contents.add(expr);
    }

    public String getQName() {
        return this.qname;
    }

    public boolean isNamespaceDeclaration() {
        return this.isNamespaceDecl;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        contextInfo.setParent(this);
        for (Object next : this.contents) {
            if (!(next instanceof Expression)) continue;
            ((Expression)next).analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringBuilder buf = new StringBuilder();
        for (Object next : this.contents) {
            if (next instanceof Expression) {
                this.evalEnclosedExpr(((Expression)next).eval(contextSequence, contextItem), buf);
                continue;
            }
            buf.append(next);
        }
        StringValue result = new StringValue(buf.toString());
        return result;
    }

    private void evalEnclosedExpr(Sequence seq, StringBuilder buf) throws XPathException {
        SequenceIterator i = Atomize.atomize(seq).iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            buf.append(item.getStringValue());
            if (!i.hasNext()) continue;
            buf.append(' ');
        }
    }

    public String getLiteralValue() {
        if (this.contents.size() == 0) {
            return "";
        }
        return (String)this.contents.get(0);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("attribute ");
        dumper.display("{");
        dumper.display(this.qname);
        dumper.display("} ");
        dumper.display("{");
        dumper.startIndent();
        for (Object next : this.contents) {
            if (next instanceof Expression) {
                ((Expression)next).dump(dumper);
                continue;
            }
            dumper.display(next);
        }
        dumper.endIndent();
        dumper.nl().display("} ");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("attribute ");
        result.append("{");
        result.append(this.qname);
        result.append("} ");
        result.append("{");
        for (Object next : this.contents) {
            result.append(next.toString());
        }
        result.append("} ");
        return result.toString();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        for (Object object : this.contents) {
            if (!(object instanceof Expression)) continue;
            ((Expression)object).resetState(postOptimization);
        }
    }

    public Iterator<Object> contentIterator() {
        return this.contents.iterator();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitAttribConstructor(this);
    }
}

