/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class BasicFunction
extends Function {
    public BasicFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        int argCount = this.getArgumentCount();
        Sequence[] args = new Sequence[argCount];
        for (int i = 0; i < argCount; ++i) {
            try {
                args[i] = this.getArgument(i).eval(contextSequence, contextItem);
                continue;
            }
            catch (XPathException e) {
                if (e.getErrorCode() == null || e.getErrorCode() == ErrorCodes.ERROR) {
                    e.prependMessage(ErrorCodes.XPTY0004, "checking function parameter " + (i + 1) + " in call " + ExpressionDumper.dump(this) + ": ");
                }
                throw e;
            }
        }
        Sequence result = this.eval(args, contextSequence);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public abstract Sequence eval(Sequence[] var1, Sequence var2) throws XPathException;
}

