/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class CastExpression
extends AbstractExpression {
    private Expression expression;
    private int cardinality = 2;
    private final int requiredType;

    public CastExpression(XQueryContext context, Expression expr, int requiredType, int cardinality) {
        super(context);
        this.requiredType = requiredType;
        this.cardinality = cardinality;
        this.setExpression(expr);
    }

    protected Expression getInnerExpression() {
        return this.expression;
    }

    public void setExpression(Expression expr) {
        this.expression = expr;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
        contextInfo.setStaticReturnType(this.requiredType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.requiredType == 20 || this.requiredType == 28 && this.expression.returnsType() != 28) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0080, "cannot cast to " + Type.getTypeName(this.requiredType));
        }
        if (this.requiredType == 13 || this.expression.returnsType() == 13 || this.requiredType == 14 || this.expression.returnsType() == 14) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0051, "cannot cast to " + Type.getTypeName(this.requiredType));
        }
        Sequence seq = Atomize.atomize(this.expression.eval(contextSequence, contextItem));
        if (seq.isEmpty()) {
            if ((this.cardinality & 1) == 0) {
                throw new XPathException((Expression)this, "Type error: empty sequence is not allowed here");
            }
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Item item = seq.itemAt(0);
            if (seq.hasMany() && Type.subTypeOf(this.requiredType, 20)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "cardinality error: sequence with more than one item is not allowed here");
            }
            try {
                if (this.requiredType == 24) {
                    if (item.getType() == 24) {
                        result = item.toSequence();
                    } else {
                        if (item.getType() != 20 && !Type.subTypeOf(item.getType(), 22)) throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Cannot cast " + Type.getTypeName(item.getType()) + " to xs:QName");
                        result = new QNameValue(this.context, item.getStringValue());
                    }
                } else {
                    result = item.convertTo(this.requiredType);
                }
            }
            catch (XPathException e) {
                e.setLocation(e.getLine(), e.getColumn());
                throw e;
            }
        }
        if (!this.context.getProfiler().isEnabled()) return result;
        this.context.getProfiler().end(this, "", result);
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        dumper.display(" cast as ");
        dumper.display(Type.getTypeName(this.requiredType));
    }

    public String toString() {
        return this.expression.toString() + " cast as " + Type.getTypeName(this.requiredType);
    }

    @Override
    public int returnsType() {
        return this.requiredType;
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public int getCardinality() {
        return 3;
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitCastExpr(this);
    }

    public Function toFunction() throws XPathException {
        String typeName = Type.getTypeName(this.requiredType);
        try {
            QName qname = QName.parse(this.context, typeName);
            FunctionSignature signature = new FunctionSignature(qname);
            SequenceType argType = new SequenceType(11, 2);
            signature.setArgumentTypes(new SequenceType[]{argType});
            signature.setReturnType(new SequenceType(this.requiredType, this.cardinality));
            return new FunctionWrapper(this.context, signature);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + typeName);
        }
    }

    private class FunctionWrapper
    extends Function {
        protected FunctionWrapper(XQueryContext context, FunctionSignature signature) throws XPathException {
            super(context, signature);
            ArrayList<Expression> args = new ArrayList<Expression>(1);
            args.add(new Function.Placeholder(context));
            super.setArguments(args);
        }

        @Override
        public void setArguments(List<Expression> arguments) throws XPathException {
            CastExpression.this.setExpression(arguments.get(0));
        }

        @Override
        public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
            return CastExpression.this.eval(contextSequence);
        }
    }
}

