/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class ConcatExpr
extends PathExpr {
    public ConcatExpr(XQueryContext context) {
        super(context);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (this.getContext().getXQueryVersion() < 30) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0003, "string concatenation operator is not available before XQuery 3.0");
        }
        super.analyze(contextInfo);
    }

    @Override
    public void add(PathExpr pathExpr) {
        AbstractExpression expr = new DynamicCardinalityCheck(this.context, 3, pathExpr, new Error("D02"));
        if (!Type.subTypeOf(expr.returnsType(), 20)) {
            expr = new Atomize(this.context, expr);
        }
        super.add(expr);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        StringBuilder concat = new StringBuilder();
        for (Expression step : this.steps) {
            Sequence seq = step.eval(contextSequence, contextItem);
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                if (Type.subTypeOf(item.getType(), 101)) {
                    throw new XPathException((Expression)this, ErrorCodes.FOTY0013, "Got a function item as operand in string concatenation");
                }
                concat.append(item.getStringValue());
            }
        }
        StringValue result = new StringValue(concat.toString());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public int returnsType() {
        return 22;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public Expression simplify() {
        return this;
    }
}

