/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.source.Source;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class DebuggableExpression
implements Expression,
RewritableExpression {
    private Expression expression;
    protected int line = -1;
    protected int column = -1;

    public DebuggableExpression(Expression expression) {
        this.expression = expression.simplify();
        this.line = this.expression.getLine();
        this.column = this.expression.getColumn();
    }

    @Override
    public int getExpressionId() {
        return this.expression.getExpressionId();
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (contextInfo.getParent() == null) {
            contextInfo.setParent(this);
        }
        this.expression.analyze(contextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        try {
            this.expression.getContext().expressionStart(this.expression);
            Sequence sequence = this.expression.eval(contextSequence, contextItem);
            return sequence;
        }
        finally {
            this.expression.getContext().expressionEnd(this.expression);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence) throws XPathException {
        return this.eval(contextSequence, null);
    }

    @Override
    public void setPrimaryAxis(int axis) {
        this.expression.setPrimaryAxis(axis);
    }

    @Override
    public int getPrimaryAxis() {
        return this.expression.getPrimaryAxis();
    }

    @Override
    public int returnsType() {
        return this.expression.returnsType();
    }

    @Override
    public int getCardinality() {
        return this.expression.getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.expression.getDependencies();
    }

    @Override
    public void resetState(boolean postOptimization) {
        this.expression.resetState(postOptimization);
    }

    @Override
    public boolean needsReset() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void setContextId(int contextId) {
        this.expression.setContextId(contextId);
    }

    @Override
    public int getContextId() {
        return this.expression.getContextId();
    }

    @Override
    public DocumentSet getContextDocSet() {
        return this.expression.getContextDocSet();
    }

    @Override
    public void setASTNode(XQueryAST ast) {
        if (ast != null) {
            this.line = ast.getLine();
            this.column = ast.getColumn();
        }
    }

    @Override
    public void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public XQueryContext getContext() {
        return this.expression.getContext();
    }

    @Override
    public Source getSource() {
        return this.expression.getSource();
    }

    @Override
    public int getSubExpressionCount() {
        return this.expression.getSubExpressionCount();
    }

    @Override
    public Expression getSubExpression(int index) {
        return this.expression.getSubExpression(index);
    }

    @Override
    public Boolean match(Sequence contextSequence, Item item) throws XPathException {
        return this.expression.match(contextSequence, item);
    }

    @Override
    public void replace(Expression oldExpr, Expression newExpr) {
        if (oldExpr == this.expression) {
            this.expression = newExpr;
        }
    }

    @Override
    public void remove(Expression oldExpr) throws XPathException {
        throw new XPathException("Method remove is not supported");
    }

    @Override
    public Expression getPrevious(Expression current) {
        return null;
    }

    @Override
    public Expression getFirst() {
        return this.expression;
    }

    @Override
    public boolean allowMixedNodesInReturn() {
        return false;
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public Expression simplify() {
        return this;
    }

    @Override
    public Expression getParent() {
        return null;
    }
}

