/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import java.util.List;
import org.exist.xquery.AttributeConstructor;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.ConditionalExpression;
import org.exist.xquery.DocumentConstructor;
import org.exist.xquery.DynamicAttributeConstructor;
import org.exist.xquery.DynamicTextConstructor;
import org.exist.xquery.ElementConstructor;
import org.exist.xquery.Expression;
import org.exist.xquery.ForExpr;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.GroupByClause;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.Intersect;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LocationStep;
import org.exist.xquery.OpSimpleMap;
import org.exist.xquery.OrderByClause;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.TryCatchExpression;
import org.exist.xquery.Union;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.VariableDeclaration;
import org.exist.xquery.WhereClause;

public class DefaultExpressionVisitor
extends BasicExpressionVisitor {
    @Override
    public void visitPathExpr(PathExpr expression) {
        for (int i = 0; i < expression.getLength(); ++i) {
            Expression next = expression.getExpression(i);
            next.accept(this);
        }
    }

    @Override
    public void visitUserFunction(UserDefinedFunction function) {
        function.getFunctionBody().accept(this);
    }

    @Override
    public void visitBuiltinFunction(Function function) {
        for (int i = 0; i < function.getArgumentCount(); ++i) {
            Expression arg = function.getArgument(i);
            arg.accept(this);
        }
    }

    @Override
    public void visitFunctionCall(FunctionCall call) {
        for (int i = 0; i < call.getArgumentCount(); ++i) {
            call.getArgument(i).accept(this);
        }
        call.getFunction().accept(this);
    }

    @Override
    public void visitForExpression(ForExpr forExpr) {
        forExpr.getInputSequence().accept(this);
        forExpr.getReturnExpression().accept(this);
    }

    @Override
    public void visitLetExpression(LetExpr letExpr) {
        letExpr.getInputSequence().accept(this);
        letExpr.getReturnExpression().accept(this);
    }

    @Override
    public void visitOrderByClause(OrderByClause orderBy) {
        for (OrderSpec spec : orderBy.getOrderSpecs()) {
            spec.getSortExpression().accept(this);
        }
        orderBy.getReturnExpression().accept(this);
    }

    @Override
    public void visitGroupByClause(GroupByClause groupBy) {
        for (GroupSpec spec : groupBy.getGroupSpecs()) {
            spec.getGroupExpression().accept(this);
        }
        groupBy.getReturnExpression().accept(this);
    }

    @Override
    public void visitWhereClause(WhereClause where) {
        where.getWhereExpr().accept(this);
        where.getReturnExpression().accept(this);
    }

    @Override
    public void visitConditional(ConditionalExpression conditional) {
        conditional.getTestExpr().accept(this);
        conditional.getThenExpr().accept(this);
        conditional.getElseExpr().accept(this);
    }

    @Override
    public void visitLocationStep(LocationStep locationStep) {
        List<Predicate> predicates = locationStep.getPredicates();
        for (Predicate pred : predicates) {
            pred.accept(this);
        }
    }

    @Override
    public void visitPredicate(Predicate predicate) {
        predicate.getExpression(0).accept(this);
    }

    @Override
    public void visitDocumentConstructor(DocumentConstructor constructor) {
        constructor.getContent().accept(this);
    }

    @Override
    public void visitElementConstructor(ElementConstructor constructor) {
        constructor.getNameExpr().accept(this);
        if (constructor.getAttributes() != null) {
            for (AttributeConstructor attrConstr : constructor.getAttributes()) {
                attrConstr.accept(this);
            }
        }
        if (constructor.getContent() != null) {
            constructor.getContent().accept(this);
        }
    }

    @Override
    public void visitTextConstructor(DynamicTextConstructor constructor) {
        constructor.getContent().accept(this);
    }

    @Override
    public void visitAttribConstructor(AttributeConstructor constructor) {
        Iterator<Object> i = constructor.contentIterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (!(next instanceof Expression)) continue;
            ((Expression)next).accept(this);
        }
    }

    @Override
    public void visitAttribConstructor(DynamicAttributeConstructor constructor) {
        constructor.getNameExpr().accept(this);
        if (constructor.getContentExpr() != null) {
            constructor.getContentExpr().accept(this);
        }
    }

    @Override
    public void visitUnionExpr(Union union) {
        union.left.accept(this);
        union.right.accept(this);
    }

    @Override
    public void visitIntersectionExpr(Intersect intersect) {
        intersect.left.accept(this);
        intersect.right.accept(this);
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration decl) {
        decl.getExpression().ifPresent(e -> e.accept(this));
    }

    @Override
    public void visitTryCatch(TryCatchExpression tryCatch) {
        tryCatch.getTryTargetExpr().accept(this);
        for (TryCatchExpression.CatchClause clause : tryCatch.getCatchClauses()) {
            clause.getCatchExpr().accept(this);
        }
    }

    @Override
    public void visitSimpleMapOperator(OpSimpleMap simpleMap) {
        simpleMap.getLeft().accept(this);
        simpleMap.getRight().accept(this);
    }
}

