/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.Expression;

public class Dependency {
    public static final int UNKNOWN_DEPENDENCY = -1;
    public static final int NO_DEPENDENCY = 0;
    public static final int CONTEXT_SET = 1;
    public static final int CONTEXT_ITEM = 2;
    public static final int LOCAL_VARS = 4;
    public static final int CONTEXT_VARS = 8;
    public static final int VARS = 12;
    public static final int CONTEXT_POSITION = 16;
    public static final int DEFAULT_DEPENDENCIES = 1;

    public static final String getDependenciesName(int dependencies) {
        if (dependencies == -1) {
            return "UNKNOWN";
        }
        if (dependencies == 0) {
            return "NO_DEPENDENCY";
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        if ((dependencies & 1) != 0) {
            result.append("CONTEXT_SET | ");
        }
        if ((dependencies & 2) != 0) {
            result.append("CONTEXT_ITEM | ");
        }
        if ((dependencies & 4) != 0) {
            result.append("LOCAL_VARS | ");
        }
        if ((dependencies & 8) != 0) {
            result.append("CONTEXT_VARS | ");
        }
        if ((dependencies & 0x10) != 0) {
            result.append("CONTEXT_POSITION | ");
        }
        result.delete(result.length() - 3, result.length());
        result.append("]");
        return result.toString();
    }

    public static final boolean dependsOn(Expression expr, int dependency) {
        return (expr.getDependencies() & dependency) == dependency;
    }

    public static final boolean dependsOn(int expressionDep, int dependency) {
        return (expressionDep & dependency) == dependency;
    }

    public static final boolean dependsOnVar(Expression expr) {
        return (expr.getDependencies() & 0xC) != 0;
    }
}

