/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.Namespaces;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.util.XMLChar;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.DOMException;

public class DynamicAttributeConstructor
extends NodeConstructor {
    private Expression qnameExpr;
    private Expression valueExpr;
    private boolean replaceAttribute = false;

    public DynamicAttributeConstructor(XQueryContext context) {
        super(context);
    }

    public void setNameExpr(Expression expr) {
        this.qnameExpr = new Atomize(this.context, expr);
    }

    public Expression getNameExpr() {
        return this.qnameExpr;
    }

    public void setContentExpr(Expression expr) {
        this.valueExpr = expr;
    }

    public Expression getContentExpr() {
        return this.valueExpr;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        contextInfo.setParent(this);
        this.qnameExpr.analyze(contextInfo);
        this.valueExpr.analyze(contextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeImpl node;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.newDocumentContext) {
            this.context.pushDocumentContext();
        }
        try {
            String value;
            QName qn;
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            builder.setReplaceAttributeFlag(this.replaceAttribute);
            this.context.proceed(this, builder);
            Sequence nameSeq = this.qnameExpr.eval(contextSequence, contextItem);
            if (!nameSeq.hasOne()) {
                throw new XPathException((Expression)this, "The name expression should evaluate to a single value");
            }
            Item qnItem = nameSeq.itemAt(0);
            if (qnItem.getType() == 24) {
                qn = ((QNameValue)qnItem).getQName();
            } else {
                try {
                    qn = QName.parse(this.context, nameSeq.getStringValue(), null);
                }
                catch (QName.IllegalQNameException e) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + nameSeq.getStringValue() + "' is not a valid attribute name");
                }
            }
            if (!XMLChar.isValidName(qn.getLocalPart())) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "'" + qn.getLocalPart() + "' is not a valid attribute name");
            }
            if ("xmlns".equals(qn.getLocalPart()) && qn.getNamespaceURI().isEmpty()) {
                throw new XPathException((Expression)this, ErrorCodes.XQDY0044, "'" + qn.getLocalPart() + "' is not a valid attribute name");
            }
            Sequence valueSeq = this.valueExpr.eval(contextSequence, contextItem);
            if (valueSeq.isEmpty()) {
                value = "";
            } else {
                StringBuilder buf = new StringBuilder();
                SequenceIterator i = Atomize.atomize(valueSeq).iterate();
                while (i.hasNext()) {
                    Item next = i.nextItem();
                    buf.append(next.getStringValue());
                    if (!i.hasNext()) continue;
                    buf.append(' ');
                }
                value = buf.toString();
            }
            value = DynamicAttributeConstructor.normalize(this, qn, value);
            node = null;
            try {
                int nodeNr = builder.addAttribute(qn, value);
                node = builder.getDocument().getAttribute(nodeNr);
            }
            catch (DOMException e) {
                throw new XPathException((Expression)this, ErrorCodes.XQDY0025, "element has more than one attribute '" + qn + "'");
            }
        }
        finally {
            if (this.newDocumentContext) {
                this.context.popDocumentContext();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", node);
        }
        return node;
    }

    public static String normalize(Expression expr, QName qn, String value) throws XPathException {
        if (qn.equals(Namespaces.XML_ID_QNAME) && !XMLChar.isValidNCName(value = StringValue.trimWhitespace(StringValue.collapseWhitespace(value)))) {
            throw new XPathException(expr, ErrorCodes.XQDY0091, "Value of xml:id attribute is not a valid NCName: " + value);
        }
        return value;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("attribute ");
        dumper.display("{");
        this.qnameExpr.dump(dumper);
        dumper.display("} ");
        dumper.display("{");
        dumper.startIndent();
        this.valueExpr.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        return "attribute {" + this.qnameExpr.toString() + "} {" + this.valueExpr.toString() + "} ";
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.qnameExpr.resetState(postOptimization);
        this.valueExpr.resetState(postOptimization);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitAttribConstructor(this);
    }

    public void setReplaceAttributeFlag(boolean flag) {
        this.replaceAttribute = flag;
    }
}

