/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class DynamicCardinalityCheck
extends AbstractExpression {
    private final Expression expression;
    private final int requiredCardinality;
    private Error error;

    public DynamicCardinalityCheck(XQueryContext context, int requiredCardinality, Expression expr, Error error) {
        super(context);
        this.requiredCardinality = requiredCardinality;
        this.expression = expr;
        this.error = error;
        this.setLocation(this.expression.getLine(), this.expression.getColumn());
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq;
        int actualCardinality;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (!Cardinality.checkCardinality(this.requiredCardinality, actualCardinality = (seq = this.expression.eval(contextSequence, contextItem)).isEmpty() ? 1 : (seq.hasMany() ? 4 : 2))) {
            this.error.addArgs(ExpressionDumper.dump(this.expression), Cardinality.getDescription(this.requiredCardinality), seq.getItemCount());
            throw new XPathException((Expression)this, this.error.toString());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", seq);
        }
        return seq;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("dynamic-cardinality-check");
            dumper.display("(");
            dumper.display("\"" + Cardinality.getDescription(this.requiredCardinality) + "\"");
            dumper.display(", ");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display(")");
        }
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public int returnsType() {
        return this.expression.returnsType();
    }

    @Override
    public int getDependencies() {
        return this.expression.getDependencies();
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }

    @Override
    public int getSubExpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubExpression(int index) {
        if (index == 0) {
            return this.expression;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSubExpressionCount());
    }
}

