/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.List;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.PartialFunctionApplication;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class DynamicFunctionCall
extends AbstractExpression {
    private Expression functionExpr;
    private List<Expression> arguments;
    private boolean isPartial = false;
    private AnalyzeContextInfo cachedContextInfo;

    public DynamicFunctionCall(XQueryContext context, Expression fun, List<Expression> args, boolean partial) {
        super(context);
        this.setLocation(fun.getLine(), fun.getColumn());
        this.functionExpr = fun;
        this.arguments = args;
        this.isPartial = partial;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.cachedContextInfo = new AnalyzeContextInfo(contextInfo);
        this.functionExpr.analyze(contextInfo);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.functionExpr.dump(dumper);
        dumper.display('(');
        for (Expression arg : this.arguments) {
            arg.dump(dumper);
        }
        dumper.display(')');
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.context.proceed(this);
        Sequence funcSeq = this.functionExpr.eval(contextSequence, contextItem);
        if (funcSeq.getCardinality() != 2) {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Expected exactly one item for the function to be called, got " + funcSeq.getItemCount() + ". Expression: " + ExpressionDumper.dump(this.functionExpr));
        }
        Item item0 = funcSeq.itemAt(0);
        if (!Type.subTypeOf(item0.getType(), 101)) {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Type error: expected function, got " + Type.getTypeName(item0.getType()));
        }
        FunctionReference ref = (FunctionReference)item0;
        if (this.isPartial) {
            try {
                FunctionCall call = ref.getCall();
                call.setArguments(this.arguments);
                PartialFunctionApplication partialApp = new PartialFunctionApplication(this.context, call);
                partialApp.analyze(new AnalyzeContextInfo(this.cachedContextInfo));
                return partialApp.eval(contextSequence, contextItem);
            }
            catch (XPathException e) {
                e.setLocation(this.line, this.column, this.getSource());
                throw e;
            }
        }
        ref.setArguments(this.arguments);
        ref.analyze(new AnalyzeContextInfo(this.cachedContextInfo));
        try {
            Sequence result = ref.eval(contextSequence);
            ref.resetState(false);
            return result;
        }
        catch (XPathException e) {
            if (e.getLine() <= 0) {
                e.setLocation(this.getLine(), this.getColumn(), this.getSource());
            }
            throw e;
        }
    }

    @Override
    public int returnsType() {
        return 11;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.functionExpr.resetState(postOptimization);
        this.arguments.forEach(arg -> arg.resetState(postOptimization));
    }
}

