/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.NameTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class DynamicNameCheck
extends AbstractExpression {
    private final NameTest test;
    private final Expression expression;

    public DynamicNameCheck(XQueryContext context, NameTest test, Expression expression) {
        super(context);
        this.test = test;
        this.expression = expression;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        try {
            Sequence seq = this.expression.eval(contextSequence, contextItem);
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                int itemType = item.getType();
                if (itemType == -1) {
                    itemType = seq.getItemType();
                }
                if (item instanceof NodeProxy && (itemType = item.getType()) == -1) {
                    itemType = NodeProxy.nodeType2XQuery(((NodeProxy)item).getNode().getNodeType());
                }
                if (!Type.subTypeOf(itemType, this.test.getType())) {
                    throw new XPathException(this.expression, "Type error in expression: required type is " + Type.getTypeName(this.test.getType()) + "; got: " + Type.getTypeName(item.getType()) + ": " + item.getStringValue());
                }
                Node node = ((NodeValue)item).getNode();
                if (this.test.matchesName(node)) continue;
                throw new XPathException(this.expression, "Type error in expression: required node name is " + this.getPrefixedNodeName(this.test.getName()) + "; got: " + this.getPrefixedNodeName(node));
            }
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().end(this, "", seq);
            }
            return seq;
        }
        catch (IllegalArgumentException iae) {
            throw new XPathException(this.expression, (Throwable)iae);
        }
    }

    private String getPrefixedNodeName(Node node) {
        String prefix = node.getPrefix();
        if (prefix == null) {
            String nameSpace = node.getNamespaceURI();
            if (nameSpace == null) {
                return node.getNodeName();
            }
            return "{'" + nameSpace + "'}:" + node.getNodeName();
        }
        if (prefix.isEmpty()) {
            return "{''}:" + node.getNodeName();
        }
        return prefix + ":" + node.getLocalName();
    }

    private String getPrefixedNodeName(QName name) {
        String prefix = name.getPrefix();
        String localName = name.getLocalPart();
        if (prefix == null) {
            String namespaceURI = name.getNamespaceURI();
            if (namespaceURI == null) {
                return localName;
            }
            return "{'" + namespaceURI + "'}:" + localName;
        }
        if (prefix.isEmpty()) {
            return "{''}:" + localName;
        }
        return prefix + ":" + localName;
    }

    @Override
    public int returnsType() {
        return this.test.nodeType;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("dynamic-name-check");
            dumper.display("[");
            dumper.display(Type.getTypeName(this.test.nodeType));
            dumper.display(", ");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display("]");
        }
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }
}

