/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class DynamicTypeCheck
extends AbstractExpression {
    private final Expression expression;
    private final int requiredType;

    public DynamicTypeCheck(XQueryContext context, int requiredType, Expression expr) {
        super(context);
        this.requiredType = requiredType;
        this.expression = expr;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        ValueSequence result = null;
        if (Type.subTypeOf(this.requiredType, 20) && !Type.subTypeOf(seq.getItemType(), this.requiredType)) {
            result = new ValueSequence();
        }
        if (seq.hasOne()) {
            this.check(result, seq.itemAt(0));
        } else if (!seq.isEmpty()) {
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                this.check(result, item);
            }
        }
        return result == null ? seq : result;
    }

    private void check(Sequence result, Item item) throws XPathException {
        int type = item.getType();
        if (type == -1 && ((NodeValue)item).getImplementationType() == 1 && (type = (int)((NodeProxy)item).getNodeType()) == -1) {
            type = ((NodeProxy)item).getNode().getNodeType();
        }
        if (type != this.requiredType && !Type.subTypeOf(type, this.requiredType)) {
            if (type == 21) {
                try {
                    item = item.convertTo(this.requiredType);
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression, ErrorCodes.FOCH0002, "Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            } else if (this.requiredType == 22 && Type.subTypeOf(type, -1)) {
                item = item.convertTo(22);
            } else if (Type.subTypeOf(this.requiredType, 30) && Type.subTypeOf(type, this.requiredType)) {
                try {
                    item = item.convertTo(this.requiredType);
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression, ErrorCodes.FOCH0002, "Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            } else if (Type.subTypeOf(this.requiredType, 53)) {
                try {
                    item = item.convertTo(this.requiredType);
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression, ErrorCodes.FOCH0002, "Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            } else if (Type.subTypeOf(this.requiredType, 51)) {
                try {
                    item = item.convertTo(this.requiredType);
                }
                catch (XPathException e) {
                    throw new XPathException(this.expression, ErrorCodes.FOCH0002, "Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
                }
            } else if (type == 25 && this.requiredType == 22) {
                item = item.convertTo(22);
                type = 22;
            } else {
                if (!Type.subTypeOf(type, this.requiredType)) {
                    throw new XPathException(this.expression, ErrorCodes.XPTY0004, Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ") is not a sub-type of " + Type.getTypeName(this.requiredType));
                }
                throw new XPathException(this.expression, ErrorCodes.FOCH0002, "Required type is " + Type.getTypeName(this.requiredType) + " but got '" + Type.getTypeName(item.getType()) + "(" + item.getStringValue() + ")'");
            }
        }
        if (result != null) {
            result.add(item);
        }
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("dynamic-type-check");
            dumper.display("[");
            dumper.display(Type.getTypeName(this.requiredType));
            dumper.display(", ");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display("]");
        }
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public int returnsType() {
        return this.requiredType;
    }

    @Override
    public int getDependencies() {
        return this.expression.getDependencies();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public int getLine() {
        return this.expression.getLine();
    }

    @Override
    public int getColumn() {
        return this.expression.getColumn();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }

    @Override
    public int getSubExpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubExpression(int index) {
        if (index == 0) {
            return this.expression;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSubExpressionCount());
    }
}

