/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.TreeSet;
import org.exist.xquery.CombiningExpression;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.ItemComparator;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Except
extends CombiningExpression {
    public Except(XQueryContext context, PathExpr left, PathExpr right) {
        super(context, left, right);
    }

    @Override
    public Sequence combine(Sequence ls, Sequence rs) throws XPathException {
        Sequence result;
        if (ls.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else if (rs.isEmpty()) {
            if (!Type.subTypeOf(ls.getItemType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "except operand is not a node sequence");
            }
            result = ls;
        } else {
            if (!Type.subTypeOf(ls.getItemType(), -1) || !Type.subTypeOf(rs.getItemType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "except operand is not a node sequence");
            }
            if (ls.isPersistentSet() && rs.isPersistentSet()) {
                result = ls.toNodeSet().except(rs.toNodeSet());
            } else {
                result = new ValueSequence();
                TreeSet<Item> set = new TreeSet<Item>(ItemComparator.INSTANCE);
                SequenceIterator i = rs.unorderedIterator();
                while (i.hasNext()) {
                    set.add(i.nextItem());
                }
                i = ls.unorderedIterator();
                while (i.hasNext()) {
                    Item next = i.nextItem();
                    if (set.contains(next)) continue;
                    result.add(next);
                }
                result.removeDuplicates();
            }
        }
        return result;
    }

    @Override
    protected String getOperatorName() {
        return "except";
    }
}

