/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.exist.dom.QName;
import org.exist.source.Source;
import org.exist.storage.DBBroker;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableDeclaration;
import org.exist.xquery.VariableImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public class ExternalModuleImpl
implements ExternalModule {
    private String mNamespaceURI;
    private String mPrefix;
    private String description = "User Defined Module";
    private Map<String, String> metadata = null;
    private boolean isReady = false;
    private final TreeMap<FunctionId, UserDefinedFunction> mFunctionMap = new TreeMap();
    private final TreeMap<QName, VariableDeclaration> mGlobalVariables = new TreeMap();
    private final TreeMap<QName, Variable> mStaticVariables = new TreeMap();
    private Source mSource = null;
    private XQueryContext mContext = null;
    private boolean needsReset = true;
    private Expression rootExpression = null;

    public ExternalModuleImpl(String namespaceURI, String prefix) {
        this.mNamespaceURI = namespaceURI;
        this.mPrefix = prefix;
    }

    @Override
    public void setNamespace(String prefix, String namespace) {
        this.mPrefix = prefix;
        this.mNamespaceURI = namespace;
    }

    @Override
    public void setContextItem(Sequence contextItem) {
        this.mContext.setContextItem(contextItem);
    }

    public void setIsReady(boolean ready) {
        this.isReady = ready;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public void addMetadata(String key, String value) {
        String old;
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        if ((old = this.metadata.get(key)) != null) {
            value = old + ", " + value;
        }
        this.metadata.put(key, value);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getReleaseVersion() {
        return "user-defined";
    }

    @Override
    public UserDefinedFunction getFunction(QName qname, int arity, XQueryContext callerContext) throws XPathException {
        FunctionId id = new FunctionId(qname, arity);
        UserDefinedFunction fn = this.mFunctionMap.get(id);
        if (fn == null) {
            return null;
        }
        if (callerContext != this.getContext() && fn.getSignature().isPrivate()) {
            throw new XPathException(ErrorCodes.XPST0017, "Calling a private function from outside its module");
        }
        return fn;
    }

    @Override
    public void declareFunction(UserDefinedFunction func) {
        this.mFunctionMap.put(func.getSignature().getFunctionId(), func);
    }

    @Override
    public String getNamespaceURI() {
        return this.mNamespaceURI;
    }

    @Override
    public String getDefaultPrefix() {
        return this.mPrefix;
    }

    @Override
    public boolean isInternalModule() {
        return false;
    }

    @Override
    public FunctionSignature[] listFunctions() {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(this.mFunctionMap.size());
        Iterator<UserDefinedFunction> i = this.mFunctionMap.values().iterator();
        while (i.hasNext()) {
            FunctionSignature signature = i.next().getSignature();
            signatures.add(signature);
        }
        FunctionSignature[] result = new FunctionSignature[signatures.size()];
        return signatures.toArray(result);
    }

    @Override
    public Iterator<FunctionSignature> getSignaturesForFunction(QName qname) {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(2);
        for (UserDefinedFunction func : this.mFunctionMap.values()) {
            if (func.getName().compareTo(qname) != 0) continue;
            signatures.add(func.getSignature());
        }
        return signatures.iterator();
    }

    @Override
    public Iterator<QName> getGlobalVariables() {
        return this.mGlobalVariables.keySet().iterator();
    }

    @Override
    public Collection<VariableDeclaration> getVariableDeclarations() {
        return this.mGlobalVariables.values();
    }

    @Override
    public Variable declareVariable(QName qname, Object value) throws XPathException {
        Sequence val = XPathUtil.javaObjectToXPath(value, this.mContext);
        Variable var = this.mStaticVariables.get(qname);
        if (var == null) {
            var = new VariableImpl(qname);
            this.mStaticVariables.put(qname, var);
        }
        var.setValue(val);
        return var;
    }

    @Override
    public Variable declareVariable(Variable var) {
        this.mStaticVariables.put(var.getQName(), var);
        return var;
    }

    @Override
    public void declareVariable(QName qname, VariableDeclaration decl) throws XPathException {
        if (!qname.getNamespaceURI().equals(this.getNamespaceURI())) {
            throw new XPathException((Expression)decl, ErrorCodes.XQST0048, "It is a static error if a function or variable declared in a library module is not in the target namespace of the library module.");
        }
        this.mGlobalVariables.put(qname, decl);
    }

    @Override
    public boolean isVarDeclared(QName qname) {
        if (this.mGlobalVariables.get(qname) != null) {
            return true;
        }
        return this.mStaticVariables.get(qname) != null;
    }

    @Override
    public Variable resolveVariable(QName qname) throws XPathException {
        Variable rootVar;
        VariableDeclaration decl = this.mGlobalVariables.get(qname);
        Variable var = this.mStaticVariables.get(qname);
        if (this.isReady && decl != null && (var == null || var.getValue() == null)) {
            decl.eval(this.getContext().getContextItem());
            var = this.mStaticVariables.get(qname);
        }
        if (var == null && (rootVar = this.getContext().getRootContext().resolveGlobalVariable(qname)) != null) {
            var = this.declareVariable(rootVar);
        }
        if (var != null && decl != null) {
            var.setSequenceType(decl.getSequenceType());
        }
        return var;
    }

    @Override
    public void analyzeGlobalVars() throws XPathException {
        for (VariableDeclaration decl : this.mGlobalVariables.values()) {
            decl.resetState(false);
            decl.analyze(new AnalyzeContextInfo());
        }
    }

    @Override
    public Source getSource() {
        return this.mSource;
    }

    @Override
    public void setSource(Source source) {
        this.mSource = source;
    }

    @Override
    public void setContext(XQueryContext context) {
        this.mContext = context;
    }

    @Override
    public XQueryContext getContext() {
        return this.mContext;
    }

    @Override
    public boolean moduleIsValid(DBBroker broker) {
        return this.mSource != null && this.mSource.isValid(broker) == Source.Validity.VALID;
    }

    @Override
    public void reset(XQueryContext context) {
    }

    @Override
    public void reset(XQueryContext xqueryContext, boolean keepGlobals) {
        if (this.needsReset) {
            this.needsReset = false;
            this.mContext.reset(keepGlobals);
            if (!keepGlobals) {
                this.mStaticVariables.clear();
                this.mGlobalVariables.values().forEach(v -> v.resetState(true));
            }
            this.needsReset = true;
        }
    }

    protected void setRootExpression(Expression expr) {
        this.rootExpression = expr;
    }

    @Override
    public Expression getRootExpression() {
        return this.rootExpression;
    }
}

