/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import com.ibm.icu.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.exist.dom.QName;
import org.exist.xquery.AbstractFLWORClause;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class GroupByClause
extends AbstractFLWORClause {
    protected FLWORClause rootClause = null;
    private GroupSpec[] groupSpecs;
    private final Deque<GroupByData> stack = new ArrayDeque<GroupByData>();

    public GroupByClause(XQueryContext context) {
        super(context);
    }

    @Override
    public FLWORClause.ClauseType getType() {
        return FLWORClause.ClauseType.GROUPBY;
    }

    @Override
    public Sequence preEval(Sequence seq) throws XPathException {
        this.stack.push(new GroupByData());
        return super.preEval(seq);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        GroupByData data = this.stack.peek();
        ArrayList<Sequence> groupingValues = new ArrayList<Sequence>();
        ArrayList<AtomicValue> groupingKeys = new ArrayList<AtomicValue>();
        for (GroupSpec spec : this.groupSpecs) {
            AtomicValue groupingValue;
            Sequence groupingSeq = spec.getGroupExpression().eval(null);
            if (groupingSeq.getItemCount() > 1) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Grouping variable " + spec.getKeyVarName() + " evaluates to more than one item");
            }
            AtomicValue atomicValue = groupingValue = groupingSeq.isEmpty() ? AtomicValue.EMPTY_VALUE : groupingSeq.itemAt(0).atomize();
            if (!data.initialized) {
                LocalVariable groupingVar = new LocalVariable(spec.getKeyVarName());
                groupingVar.setSequenceType(new SequenceType(20, groupingValue.isEmpty() ? 1 : 2));
                groupingVar.setStaticType(groupingValue.getType());
                data.groupingVars.add(groupingVar);
            }
            groupingValues.add(groupingSeq);
            groupingKeys.add(groupingValue);
        }
        Tuple tuple = data.groupedMap.computeIfAbsent(groupingKeys, ks -> new Tuple(groupingValues));
        LocalVariable nextVar = this.rootClause.getStartVariable();
        Objects.requireNonNull(nextVar);
        while (nextVar != null) {
            tuple.add(nextVar.getQName(), nextVar.getValue());
            if (!data.initialized) {
                LocalVariable var = new LocalVariable(nextVar.getQName());
                var.setSequenceType(nextVar.getSequenceType());
                var.setStaticType(nextVar.getStaticType());
                var.setContextDocs(nextVar.getContextDocs());
                data.variables.put(var.getQName(), var);
            }
            nextVar = nextVar.after;
        }
        data.initialized = true;
        return contextSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence postEval(Sequence seq) throws XPathException {
        if (!this.stack.isEmpty()) {
            GroupByData data = this.stack.peek();
            Sequence result = new ValueSequence();
            LocalVariable mark = this.context.markLocalVariables(false);
            try {
                for (LocalVariable var : data.variables.values()) {
                    this.context.declareVariableBinding(var);
                }
                for (LocalVariable var : data.groupingVars) {
                    this.context.declareVariableBinding(var);
                }
                for (Tuple tuple : data.groupedMap.values()) {
                    this.context.proceed();
                    Iterator siter = tuple.groupingValues.iterator();
                    for (LocalVariable localVariable : data.groupingVars) {
                        if (siter.hasNext()) {
                            Sequence val = (Sequence)siter.next();
                            localVariable.setValue(val);
                            continue;
                        }
                        throw new XPathException((Expression)this, "Internal error: missing grouping value");
                    }
                    for (Map.Entry entry : tuple.entrySet()) {
                        LocalVariable var = (LocalVariable)data.variables.get(entry.getKey());
                        var.setValue((Sequence)entry.getValue());
                    }
                    Sequence r = this.returnExpr.eval(null);
                    result.addAll(r);
                }
            }
            finally {
                this.stack.pop();
                this.context.popLocalVariables(mark, result);
            }
            if (this.returnExpr instanceof FLWORClause) {
                result = ((FLWORClause)this.returnExpr).postEval(result);
            }
            result = super.postEval(result);
            return result;
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            if (this.groupSpecs != null) {
                for (GroupSpec spec : this.groupSpecs) {
                    LocalVariable groupKeyVar = new LocalVariable(spec.getKeyVarName());
                    this.context.declareVariableBinding(groupKeyVar);
                }
            }
            AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
            newContextInfo.addFlag(1);
            for (GroupSpec spec : this.groupSpecs) {
                spec.analyze(newContextInfo);
            }
            this.returnExpr.analyze(newContextInfo);
        }
        finally {
            this.context.popLocalVariables(mark);
        }
        for (FLWORClause prevClause = this.getPreviousClause(); prevClause != null; prevClause = prevClause.getPreviousClause()) {
            this.rootClause = prevClause;
        }
    }

    public void setGroupSpecs(GroupSpec[] specs) {
        ArrayList<GroupSpec> distinctSpecs = new ArrayList<GroupSpec>(specs.length);
        for (int i = 0; i < specs.length; ++i) {
            boolean duplicate = false;
            for (int j = i + 1; j < specs.length; ++j) {
                if (!specs[i].equals(specs[j])) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            distinctSpecs.add(specs[i]);
        }
        this.groupSpecs = distinctSpecs.toArray(new GroupSpec[distinctSpecs.size()]);
    }

    public GroupSpec[] getGroupSpecs() {
        return this.groupSpecs == null ? new GroupSpec[]{} : this.groupSpecs;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (this.groupSpecs != null) {
            dumper.display("group by ");
            for (int i = 0; i < this.groupSpecs.length; ++i) {
                if (i > 0) {
                    dumper.display(", ");
                }
                dumper.display(this.groupSpecs[i].getGroupExpression().toString());
                dumper.display(" as ");
                dumper.display("$").display(this.groupSpecs[i].getKeyVarName());
            }
            dumper.nl();
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.stack.clear();
        this.returnExpr.resetState(postOptimization);
        for (GroupSpec spec : this.groupSpecs) {
            spec.resetState(postOptimization);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitGroupByClause(this);
    }

    private int compareKeys(List<AtomicValue> s1, List<AtomicValue> s2) {
        int c2;
        int c1 = s1.size();
        if (c1 == (c2 = s2.size())) {
            try {
                for (int i = 0; i < c1; ++i) {
                    AtomicValue v1 = s1.get(i);
                    AtomicValue v2 = s2.get(i);
                    Collator collator = this.groupSpecs[i].getCollator();
                    int r = v1.compareTo(collator, v2);
                    if (r == 0) continue;
                    return r;
                }
                return 0;
            }
            catch (XPathException e) {
                return -1;
            }
        }
        return c1 < c2 ? -1 : 1;
    }

    private boolean usesDefaultCollator() {
        return Stream.of(this.groupSpecs).allMatch(spec -> spec.getCollator() == null);
    }

    static class Tuple
    extends HashMap<QName, Sequence> {
        private final List<Sequence> groupingValues;

        public Tuple(List<Sequence> groupingValues) {
            this.groupingValues = groupingValues;
        }

        public void add(QName name, Sequence val) throws XPathException {
            Sequence seq = (Sequence)this.get(name);
            if (seq == null) {
                ValueSequence temp = new ValueSequence(val.getItemCount());
                temp.addAll(val);
                this.put(name, temp);
            } else {
                seq.addAll(val);
            }
        }
    }

    private class GroupByData {
        private Map<List<AtomicValue>, Tuple> groupedMap = null;
        private Map<QName, LocalVariable> variables = null;
        private List<LocalVariable> groupingVars = null;
        private boolean initialized = false;

        public GroupByData() {
            this.groupedMap = GroupByClause.this.usesDefaultCollator() ? new HashMap<List<AtomicValue>, Tuple>() : new TreeMap<List<AtomicValue>, Tuple>((x$0, x$1) -> GroupByClause.this.compareKeys(x$0, x$1));
            this.variables = new HashMap<QName, LocalVariable>();
            this.groupingVars = new ArrayList<LocalVariable>();
        }
    }
}

