/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;

public class GroupSpec {
    private final XQueryContext context;
    private Expression expression;
    private QName keyVarName = null;
    private Collator collator;

    public GroupSpec(XQueryContext context, Expression groupExpr, QName keyVarName) {
        if (groupExpr == null) {
            groupExpr = new VariableReference(context, keyVarName);
        }
        this.expression = groupExpr;
        this.context = context;
        this.keyVarName = keyVarName;
        this.collator = context.getDefaultCollator();
    }

    public void setCollator(String collation) throws XPathException {
        this.collator = this.context.getCollator(collation);
    }

    public Collator getCollator() {
        return this.collator;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.expression.analyze(contextInfo);
    }

    public Expression getGroupExpression() {
        return this.expression;
    }

    public QName getKeyVarName() {
        return this.keyVarName;
    }

    public String toString() {
        return "$" + this.keyVarName + " := " + ExpressionDumper.dump(this.expression);
    }

    public void resetState(boolean postOptimization) {
        this.expression.resetState(postOptimization);
    }

    public void replace(Expression oldExpr, Expression newExpr) {
        if (this.expression == oldExpr) {
            this.expression = newExpr;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof GroupSpec && ((GroupSpec)obj).keyVarName.equals(this.keyVarName);
    }
}

