/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.exist.debuggee.DebuggeeJoint;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.DocumentSet;
import org.exist.security.Subject;
import org.exist.storage.UpdateListener;
import org.exist.util.FileUtils;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.ClosureVariable;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.Module;
import org.exist.xquery.Profiler;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class ModuleContext
extends XQueryContext {
    private XQueryContext parentContext;
    private String modulePrefix;
    private String moduleNamespace;
    private final String location;

    public ModuleContext(XQueryContext parentContext, String modulePrefix, String moduleNamespace, String location) {
        this.moduleNamespace = moduleNamespace;
        this.modulePrefix = modulePrefix;
        this.location = location;
        this.setParentContext(parentContext);
        this.loadDefaults(this.getBroker().getConfiguration());
        this.profiler = new Profiler(this.getBroker().getBrokerPool());
    }

    @Override
    public Subject getRealUser() {
        return this.getRootContext().getRealUser();
    }

    String getLocation() {
        return this.location;
    }

    String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public void setModuleNamespace(String prefix, String namespaceURI) {
        this.modulePrefix = prefix;
        this.moduleNamespace = namespaceURI;
    }

    @Override
    void setModulesChanged() {
        this.parentContext.setModulesChanged();
    }

    private void setParentContext(XQueryContext parentContext) {
        this.parentContext = parentContext;
        if (parentContext != null) {
            this.db = parentContext.db;
            this.baseURI = parentContext.baseURI;
            try {
                if (this.location.startsWith("xmldb:") || this.location.indexOf(58) < 0 && parentContext.getModuleLoadPath().startsWith("xmldb:")) {
                    XmldbURI locationUri = XmldbURI.xmldbUriFor(FileUtils.dirname(this.location));
                    if (".".equals(parentContext.getModuleLoadPath())) {
                        this.setModuleLoadPath(locationUri.toString());
                    } else {
                        try {
                            XmldbURI parentLoadUri = XmldbURI.xmldbUriFor(parentContext.getModuleLoadPath());
                            XmldbURI moduleLoadUri = parentLoadUri.resolveCollectionPath(locationUri);
                            this.setModuleLoadPath(moduleLoadUri.toString());
                        }
                        catch (URISyntaxException e) {
                            this.setModuleLoadPath(locationUri.toString());
                        }
                    }
                } else {
                    String dir = FileUtils.dirname(this.location);
                    if (dir.matches("^[a-z]+:.*")) {
                        this.moduleLoadPath = dir;
                    } else if (".".equals(parentContext.moduleLoadPath)) {
                        if (!".".equals(dir)) {
                            if (dir.startsWith("/")) {
                                this.setModuleLoadPath("." + dir);
                            } else {
                                this.setModuleLoadPath("./" + dir);
                            }
                        }
                    } else if (dir.startsWith("/")) {
                        this.setModuleLoadPath(dir);
                    } else {
                        this.setModuleLoadPath(FileUtils.addPaths(parentContext.getModuleLoadPath(), dir));
                    }
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setModule(String namespaceURI, Module module) {
        if (module == null) {
            this.modules.remove(namespaceURI);
        } else {
            this.modules.put(namespaceURI, module);
        }
        this.setRootModule(namespaceURI, module);
    }

    XQueryContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public boolean hasParent() {
        return true;
    }

    @Override
    public XQueryContext getRootContext() {
        return this.parentContext.getRootContext();
    }

    @Override
    public void updateContext(XQueryContext from) {
        if (from.hasParent()) {
            this.parentContext = ((ModuleContext)from).parentContext;
        }
        try {
            Variable var = from.getRootContext().resolveVariable("response:response");
            if (var != null) {
                this.declareVariable("response:response", (Object)var.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setModule("http://exist-db.org/xquery/response", from.getRootContext().getModule("http://exist-db.org/xquery/response"));
    }

    @Override
    public XQueryContext copyContext() {
        ModuleContext ctx = new ModuleContext(this.parentContext, this.modulePrefix, this.moduleNamespace, this.location);
        this.copyFields(ctx);
        try {
            ctx.declareNamespace(this.modulePrefix, this.moduleNamespace);
        }
        catch (XPathException e) {
            e.printStackTrace();
        }
        return ctx;
    }

    @Override
    public void addDynamicOption(String qnameString, String contents) throws XPathException {
        this.parentContext.addDynamicOption(qnameString, contents);
    }

    @Override
    public DocumentSet getStaticallyKnownDocuments() throws XPathException {
        return this.parentContext.getStaticallyKnownDocuments();
    }

    @Override
    public Module getModule(String namespaceURI) {
        Module module = super.getModule(namespaceURI);
        if (module == null) {
            module = this.parentContext.getModule(namespaceURI);
        }
        return module;
    }

    @Override
    protected void setRootModule(String namespaceURI, Module module) {
        this.parentContext.setRootModule(namespaceURI, module);
    }

    @Override
    public Iterator<Module> getRootModules() {
        return this.parentContext.getRootModules();
    }

    @Override
    public Iterator<Module> getAllModules() {
        return this.parentContext.getAllModules();
    }

    @Override
    public Module getRootModule(String namespaceURI) {
        return this.parentContext.getRootModule(namespaceURI);
    }

    @Override
    protected final XPathException moduleLoadException(String message, String moduleLocation) throws XPathException {
        return this.moduleLoadException(message, moduleLocation, null);
    }

    @Override
    protected final XPathException moduleLoadException(String message, String moduleLocation, Exception e) throws XPathException {
        String dependantModule;
        try {
            dependantModule = this.location != null && this.location.startsWith("xmldb:exist:///db") ? this.location : XmldbURI.create(this.getParentContext().getModuleLoadPath(), false).append(this.location).toString();
        }
        catch (Exception ex) {
            dependantModule = this.location;
        }
        if (e == null) {
            return new XPathException(ErrorCodes.XQST0059, message, new ValueSequence(new StringValue(moduleLocation), new StringValue(dependantModule)));
        }
        return new XPathException(ErrorCodes.XQST0059, message, new ValueSequence(new StringValue(moduleLocation), new StringValue(dependantModule)), (Throwable)e);
    }

    @Override
    public XQueryWatchDog getWatchDog() {
        return this.parentContext.getWatchDog();
    }

    @Override
    public Profiler getProfiler() {
        return this.parentContext.getProfiler();
    }

    @Override
    public XMLGregorianCalendar getCalendar() {
        return this.parentContext.getCalendar();
    }

    @Override
    public AnyURIValue getBaseURI() throws XPathException {
        return this.parentContext.getBaseURI();
    }

    @Override
    public void setBaseURI(AnyURIValue uri) {
        this.parentContext.setBaseURI(uri);
    }

    @Override
    public void setXQueryContextVar(String name, Object XQvar) {
        this.parentContext.setXQueryContextVar(name, XQvar);
    }

    @Override
    public Object getXQueryContextVar(String name) {
        return this.parentContext.getXQueryContextVar(name);
    }

    @Override
    public MemTreeBuilder getDocumentBuilder() {
        return this.parentContext.getDocumentBuilder();
    }

    @Override
    public MemTreeBuilder getDocumentBuilder(boolean explicitCreation) {
        return this.parentContext.getDocumentBuilder(explicitCreation);
    }

    @Override
    public void pushDocumentContext() {
        this.parentContext.pushDocumentContext();
    }

    @Override
    public LocalVariable markLocalVariables(boolean newContext) {
        return this.parentContext.markLocalVariables(newContext);
    }

    @Override
    public void popLocalVariables(LocalVariable var) {
        this.parentContext.popLocalVariables(var);
    }

    @Override
    public void popLocalVariables(LocalVariable var, Sequence resultSequence) {
        this.parentContext.popLocalVariables(var, resultSequence);
    }

    @Override
    public LocalVariable declareVariableBinding(LocalVariable var) throws XPathException {
        return this.parentContext.declareVariableBinding(var);
    }

    @Override
    protected Variable resolveLocalVariable(QName qname) throws XPathException {
        return this.parentContext.resolveLocalVariable(qname);
    }

    @Override
    public Variable resolveVariable(QName qname) throws XPathException {
        Module module;
        Variable var = this.resolveLocalVariable(qname);
        if (var == null && (module = this.moduleNamespace.equals(qname.getNamespaceURI()) ? this.getRootModule(this.moduleNamespace) : this.getModule(qname.getNamespaceURI())) != null) {
            var = module.resolveVariable(qname);
        }
        if (var == null) {
            var = (Variable)this.globalVariables.get(qname);
        }
        return var;
    }

    @Override
    public Map<QName, Variable> getVariables() {
        return this.parentContext.getVariables();
    }

    @Override
    public Map<QName, Variable> getLocalVariables() {
        return this.parentContext.getLocalVariables();
    }

    @Override
    public List<ClosureVariable> getLocalStack() {
        return this.parentContext.getLocalStack();
    }

    @Override
    public Map<QName, Variable> getGlobalVariables() {
        return this.parentContext.getGlobalVariables();
    }

    @Override
    public void restoreStack(List<ClosureVariable> stack) throws XPathException {
        this.parentContext.restoreStack(stack);
    }

    @Override
    public int getCurrentStackSize() {
        return this.parentContext.getCurrentStackSize();
    }

    @Override
    public void popDocumentContext() {
        this.parentContext.popDocumentContext();
    }

    @Override
    public String getURIForPrefix(String prefix) {
        String uri = this.getInScopeNamespace(prefix);
        if (uri != null) {
            return uri;
        }
        uri = this.getInheritedNamespace(prefix);
        if (uri != null) {
            return uri;
        }
        return (String)this.staticNamespaces.get(prefix);
    }

    @Override
    public String getPrefixForURI(String uri) {
        String prefix = this.getInScopePrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.getInheritedPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        return (String)this.staticPrefixes.get(uri);
    }

    @Override
    public String getInScopeNamespace(String prefix) {
        return this.parentContext.getInScopeNamespace(prefix);
    }

    @Override
    public String getInScopePrefix(String uri) {
        return this.parentContext.getInScopePrefix(uri);
    }

    @Override
    public String getInheritedNamespace(String prefix) {
        return this.parentContext.getInheritedNamespace(prefix);
    }

    @Override
    public String getInheritedPrefix(String uri) {
        return this.parentContext.getInheritedPrefix(uri);
    }

    @Override
    public void declareInScopeNamespace(String prefix, String uri) {
        this.parentContext.declareInScopeNamespace(prefix, uri);
    }

    @Override
    public void pushInScopeNamespaces(boolean inherit) {
        this.parentContext.pushInScopeNamespaces(inherit);
    }

    @Override
    public void pushInScopeNamespaces() {
        this.parentContext.pushInScopeNamespaces();
    }

    @Override
    public void popInScopeNamespaces() {
        this.parentContext.popInScopeNamespaces();
    }

    @Override
    public void registerUpdateListener(UpdateListener listener) {
        this.parentContext.registerUpdateListener(listener);
    }

    @Override
    protected void clearUpdateListeners() {
    }

    @Override
    public DebuggeeJoint getDebuggeeJoint() {
        return this.parentContext.getDebuggeeJoint();
    }

    @Override
    public boolean isDebugMode() {
        return this.parentContext.isDebugMode();
    }

    @Override
    public void expressionStart(Expression expr) throws TerminatedException {
        this.parentContext.expressionStart(expr);
    }

    @Override
    public void expressionEnd(Expression expr) {
        this.parentContext.expressionEnd(expr);
    }

    @Override
    public void stackEnter(Expression expr) throws TerminatedException {
        this.parentContext.stackEnter(expr);
    }

    @Override
    public void stackLeave(Expression expr) {
        this.parentContext.stackLeave(expr);
    }

    @Override
    public void registerBinaryValueInstance(BinaryValue binaryValue) {
        this.parentContext.registerBinaryValueInstance(binaryValue);
    }

    @Override
    public void saveState() {
        super.saveState();
        this.parentContext.saveState();
    }
}

