/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.BinaryOp;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class NodeComparison
extends BinaryOp {
    private final Constants.NodeComparisonOperator relation;

    public NodeComparison(XQueryContext context, Expression left, Expression right, Constants.NodeComparisonOperator relation) {
        super(context);
        this.relation = relation;
        this.add(new DynamicCardinalityCheck(context, 3, left, new Error("D05")));
        this.add(right);
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public int getCardinality() {
        return 3;
    }

    @Override
    public int returnsType() {
        return 23;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence ls = this.getLeft().eval(contextSequence, contextItem);
        Sequence rs = this.getRight().eval(contextSequence, contextItem);
        if (!ls.isEmpty() && !rs.isEmpty()) {
            if (!Type.subTypeOf(ls.itemAt(0).getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "left item is not a node; got '" + Type.getTypeName(ls.itemAt(0).getType()) + "'");
            }
            if (!Type.subTypeOf(rs.itemAt(0).getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "right item is not a node; got '" + Type.getTypeName(rs.itemAt(0).getType()) + "'");
            }
            NodeValue lv = (NodeValue)ls.itemAt(0);
            NodeValue rv = (NodeValue)rs.itemAt(0);
            if (lv.getImplementationType() != rv.getImplementationType()) {
                result = BooleanValue.FALSE;
            } else {
                switch (this.relation) {
                    case IS: {
                        result = lv.equals(rv) ? BooleanValue.TRUE : BooleanValue.FALSE;
                        break;
                    }
                    case BEFORE: {
                        result = lv.before(rv, false) ? BooleanValue.TRUE : BooleanValue.FALSE;
                        break;
                    }
                    case AFTER: {
                        result = lv.after(rv, false) ? BooleanValue.TRUE : BooleanValue.FALSE;
                        break;
                    }
                    default: {
                        throw new XPathException((Expression)this, "Illegal argument: unknown relation");
                    }
                }
            }
        } else {
            if (ls.isEmpty() && !rs.isEmpty() && !Type.subTypeOf(rs.getItemType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "The empty sequence cant be an atomic value");
            }
            if (!ls.isEmpty() && rs.isEmpty() && !Type.subTypeOf(ls.getItemType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "The empty sequence cant be an atomic value");
            }
            result = BooleanValue.EMPTY_SEQUENCE;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.getLeft().dump(dumper);
        dumper.display(' ').display(this.relation.symbol).display(' ');
        this.getRight().dump(dumper);
    }

    @Override
    public String toString() {
        return this.getLeft().toString() + ' ' + this.relation.symbol + ' ' + this.getRight().toString();
    }
}

