/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class OpSimpleMap
extends AbstractExpression {
    private Expression left;
    private PathExpr right;

    public OpSimpleMap(XQueryContext context, PathExpr left, PathExpr right) {
        super(context);
        this.left = left;
        this.right = right;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.left.analyze(new AnalyzeContextInfo(contextInfo));
        this.right.analyze(new AnalyzeContextInfo(contextInfo));
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence leftSeq;
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((leftSeq = this.left.eval(contextSequence)).isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ValueSequence result = new ValueSequence();
        int pos = 0;
        SequenceIterator i = leftSeq.iterate();
        while (i.hasNext()) {
            this.context.setContextSequencePosition(pos, leftSeq);
            Sequence rightSeq = this.right.eval(i.nextItem().toSequence());
            result.addAll(rightSeq);
            ++pos;
        }
        return result;
    }

    @Override
    public int returnsType() {
        return this.right.returnsType();
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.left.dump(dumper);
        dumper.display(" ! ");
        this.right.dump(dumper);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.left.toString());
        result.append(" ! ");
        result.append(this.right.toString());
        return result.toString();
    }

    public Expression getLeft() {
        return this.left;
    }

    public PathExpr getRight() {
        return this.right;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitSimpleMapOperator(this);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.left.resetState(postOptimization);
        this.right.resetState(postOptimization);
    }
}

