/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.exist.xquery.AbstractFLWORClause;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.OrderedValueSequence;
import org.exist.xquery.value.Sequence;

public class OrderByClause
extends AbstractFLWORClause {
    protected OrderSpec[] orderSpecs = null;
    private final Deque<OrderedValueSequence> stack = new ArrayDeque<OrderedValueSequence>();

    public OrderByClause(XQueryContext context, List<OrderSpec> orderSpecs) {
        super(context);
        this.orderSpecs = orderSpecs.toArray(new OrderSpec[orderSpecs.size()]);
    }

    public OrderSpec[] getOrderSpecs() {
        return this.orderSpecs;
    }

    @Override
    public FLWORClause.ClauseType getType() {
        return FLWORClause.ClauseType.ORDERBY;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.addFlag(1);
        if (this.orderSpecs != null) {
            for (OrderSpec spec : this.orderSpecs) {
                spec.analyze(newContextInfo);
            }
        }
        this.returnExpr.analyze(newContextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        OrderedValueSequence orderedResult = this.stack.isEmpty() ? new OrderedValueSequence(this.orderSpecs, 100) : this.stack.pop();
        Sequence result = this.getReturnExpression().eval(contextSequence, contextItem);
        if (result != null) {
            orderedResult.addAll(result);
        }
        this.stack.push(orderedResult);
        return result;
    }

    @Override
    public Sequence postEval(Sequence seq) throws XPathException {
        if (this.stack.isEmpty()) {
            return seq;
        }
        OrderedValueSequence orderedResult = this.stack.pop();
        orderedResult.sort();
        Sequence result = orderedResult;
        if (this.getReturnExpression() instanceof FLWORClause) {
            result = ((FLWORClause)this.getReturnExpression()).postEval(result);
        }
        return super.postEval(result);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("order by ");
        for (int i = 0; i < this.orderSpecs.length; ++i) {
            if (i > 0) {
                dumper.display(", ");
            }
            dumper.display(this.orderSpecs[i]);
        }
        dumper.nl();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitOrderByClause(this);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.stack.clear();
    }
}

