/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class PIConstructor
extends NodeConstructor {
    private static Pattern wsContentStart = Pattern.compile("^(\\s)*(.*)");
    private final String target;
    private String data = null;

    public PIConstructor(XQueryContext context, String pi) throws XPathException {
        super(context);
        int p = pi.indexOf(" ");
        if (p == -1) {
            this.target = pi;
        } else {
            this.target = pi.substring(0, p);
            if (++p < pi.length()) {
                this.data = pi.substring(p);
                Matcher m = wsContentStart.matcher(this.data);
                if (m.matches()) {
                    this.data = m.group(2);
                }
            }
        }
        if (this.target.equalsIgnoreCase("xml")) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0003, "The target 'xml' is not allowed in XML processing instructions.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.newDocumentContext) {
            this.context.pushDocumentContext();
        }
        try {
            NodeImpl node;
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            int nodeNr = builder.processingInstruction(this.target, this.data);
            NodeImpl nodeImpl = node = builder.getDocument().getNode(nodeNr);
            return nodeImpl;
        }
        finally {
            if (this.newDocumentContext) {
                this.context.popDocumentContext();
            }
        }
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("processing-instruction {");
        dumper.display(this.target);
        dumper.display("} {");
        dumper.startIndent();
        dumper.display(this.data);
        dumper.endIndent().nl().display("}");
    }

    public String toString() {
        return "processing-instruction {" + this.target + "} {" + this.data + "}";
    }
}

