/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.VariableReference;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class PartialFunctionApplication
extends AbstractExpression {
    public static final String PARTIAL_FUN_PREFIX = "partial";
    protected FunctionCall function;
    protected AnalyzeContextInfo cachedContextInfo;

    public PartialFunctionApplication(XQueryContext context, FunctionCall call) {
        super(context);
        this.function = call;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.cachedContextInfo = contextInfo;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        this.function.dump(dumper);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        FunctionReference newRef = this.createPartial(contextSequence, contextItem, this.function);
        return newRef;
    }

    @Override
    public int returnsType() {
        return 101;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    private FunctionReference createPartial(Sequence contextSequence, Item contextItem, FunctionCall staticCall) throws XPathException {
        FunctionSignature signature = staticCall.getSignature();
        SequenceType[] paramTypes = signature.getArgumentTypes();
        ArrayList<SequenceType> newParamTypes = new ArrayList<SequenceType>();
        ArrayList<Expression> callArgs = new ArrayList<Expression>();
        ArrayList<QName> variables = new ArrayList<QName>();
        int argCount = staticCall.getArgumentCount();
        for (int i = 0; i < argCount; ++i) {
            Expression param = staticCall.getArgument(i);
            if (param instanceof Function.Placeholder) {
                if (i < paramTypes.length) {
                    newParamTypes.add(paramTypes[i]);
                } else {
                    newParamTypes.add(paramTypes[paramTypes.length - 1]);
                }
                QName varName = new QName("vp" + i, "");
                variables.add(varName);
                VariableReference ref = new VariableReference(this.context, varName);
                callArgs.add(ref);
                continue;
            }
            try {
                param.analyze(this.cachedContextInfo);
                Sequence seq = param.eval(contextSequence, contextItem);
                callArgs.add(new PrecomputedValue(this.context, seq));
                continue;
            }
            catch (XPathException e) {
                if (e.getLine() <= 0) {
                    e.setLocation(this.line, this.column, this.getSource());
                }
                e.addFunctionCall(this.function.functionDef, this);
                throw e;
            }
        }
        SequenceType[] newParamArray = newParamTypes.toArray(new SequenceType[newParamTypes.size()]);
        QName name = new QName(PARTIAL_FUN_PREFIX + this.hashCode(), "");
        FunctionSignature newSignature = new FunctionSignature(name, newParamArray, signature.getReturnType());
        UserDefinedFunction func = new UserDefinedFunction(this.context, newSignature);
        func.setLocation(staticCall.getLine(), staticCall.getColumn());
        for (QName varName : variables) {
            func.addVariable(varName);
        }
        FunctionCall innerCall = new FunctionCall(staticCall);
        innerCall.setArguments(callArgs);
        func.setFunctionBody(innerCall);
        FunctionCall newCall = new FunctionCall(this.context, func);
        newCall.setLocation(staticCall.getLine(), staticCall.getColumn());
        return new FunctionReference(newCall);
    }

    private static class PrecomputedValue
    extends AbstractExpression {
        Sequence sequence;

        public PrecomputedValue(XQueryContext context, Sequence input) {
            super(context);
            this.sequence = input;
        }

        @Override
        public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        }

        @Override
        public void dump(ExpressionDumper dumper) {
        }

        @Override
        public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
            return this.sequence;
        }

        @Override
        public int returnsType() {
            return this.sequence.getItemType();
        }

        @Override
        public int getDependencies() {
            return 1;
        }
    }
}

