/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.exist.Database;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.storage.BrokerPoolService;
import org.exist.xquery.Expression;
import org.xml.sax.helpers.AttributesImpl;

public class PerformanceStats
implements BrokerPoolService {
    public static final String RANGE_IDX_TYPE = "range";
    public static final String XML_NAMESPACE = "http://exist-db.org/xquery/profiling";
    public static final String XML_PREFIX = "stats";
    public static final String CONFIG_PROPERTY_TRACE = "xquery.profiling.trace";
    public static final String CONFIG_ATTR_TRACE = "trace";
    public static final int NO_INDEX = 0;
    public static final int BASIC_INDEX = 1;
    public static final int OPTIMIZED_INDEX = 2;
    private HashMap<String, QueryStats> queries = new HashMap();
    private HashMap<FunctionStats, FunctionStats> functions = new HashMap();
    private HashMap<IndexStats, IndexStats> indexStats = new HashMap();
    private boolean enabled = false;
    private Database db;

    public PerformanceStats(Database db) {
        String config;
        this.db = db;
        if (db != null && (config = (String)db.getConfiguration().getProperty(CONFIG_PROPERTY_TRACE)) != null) {
            this.enabled = config.equals("functions") || "yes".equals(config);
        }
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled || this.db != null && this.db.getPerformanceStats() != this && this.db.getPerformanceStats().isEnabled();
    }

    public void recordQuery(String source, long elapsed) {
        if (source == null) {
            return;
        }
        QueryStats stats = this.queries.get(source);
        if (stats == null) {
            stats = new QueryStats(source);
            stats.executionTime = elapsed;
            this.queries.put(source, stats);
        } else {
            stats.recordCall(elapsed);
        }
    }

    public void recordFunctionCall(QName qname, String source, long elapsed) {
        FunctionStats newStats = new FunctionStats(source, qname);
        FunctionStats stats = this.functions.get(newStats);
        if (stats == null) {
            newStats.executionTime = elapsed;
            this.functions.put(newStats, newStats);
        } else {
            stats.recordCall(elapsed);
        }
    }

    public void recordIndexUse(Expression expression, String indexName, String source, int mode, long elapsed) {
        IndexStats newStats = new IndexStats(indexName, source, expression.getLine(), expression.getColumn(), mode);
        IndexStats stats = this.indexStats.get(newStats);
        if (stats == null) {
            newStats.executionTime = elapsed;
            this.indexStats.put(newStats, newStats);
        } else {
            stats.recordUsage(elapsed);
        }
    }

    public synchronized void merge(PerformanceStats otherStats) {
        Object mine;
        for (QueryStats queryStats : otherStats.queries.values()) {
            mine = this.queries.get(queryStats.source);
            if (mine == null) {
                this.queries.put(queryStats.source, queryStats);
                continue;
            }
            ((QueryStats)mine).callCount += queryStats.callCount;
            ((QueryStats)mine).executionTime += queryStats.executionTime;
        }
        for (FunctionStats functionStats : otherStats.functions.values()) {
            mine = this.functions.get(functionStats);
            if (mine == null) {
                this.functions.put(functionStats, functionStats);
                continue;
            }
            ((FunctionStats)mine).callCount += functionStats.callCount;
            ((FunctionStats)mine).executionTime += functionStats.executionTime;
        }
        for (IndexStats indexStats : otherStats.indexStats.values()) {
            mine = this.indexStats.get(indexStats);
            if (mine == null) {
                this.indexStats.put(indexStats, indexStats);
                continue;
            }
            ((IndexStats)mine).usageCount += indexStats.usageCount;
            ((IndexStats)mine).executionTime += indexStats.executionTime;
        }
    }

    private String createKey(QName qname, String source) {
        return qname.getNamespaceURI() + ":" + qname.getLocalPart() + ":" + source;
    }

    public boolean hasData() {
        return !this.functions.isEmpty() || !this.queries.isEmpty();
    }

    public synchronized String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        FunctionStats[] stats = this.sort();
        for (int i = 0; i < stats.length; ++i) {
            pw.format("\n%30s %8.3f %8d", stats[i].qname, (double)stats[i].executionTime / 1000.0, stats[i].callCount);
        }
        pw.flush();
        return sw.toString();
    }

    private FunctionStats[] sort() {
        FunctionStats[] stats = new FunctionStats[this.functions.size()];
        int j = 0;
        Iterator<FunctionStats> iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            FunctionStats next;
            stats[j] = next = iterator.next();
            ++j;
        }
        Arrays.sort(stats, new CompareByTime());
        return stats;
    }

    public synchronized void toXML(MemTreeBuilder builder) {
        AttributesImpl attrs = new AttributesImpl();
        builder.startElement(new QName("calls", XML_NAMESPACE, XML_PREFIX), null);
        for (QueryStats queryStats : this.queries.values()) {
            attrs.clear();
            attrs.addAttribute("", "source", "source", "CDATA", queryStats.source);
            attrs.addAttribute("", "elapsed", "elapsed", "CDATA", Double.toString((double)queryStats.executionTime / 1000.0));
            attrs.addAttribute("", "calls", "calls", "CDATA", Integer.toString(queryStats.callCount));
            builder.startElement(new QName("query", XML_NAMESPACE, XML_PREFIX), attrs);
            builder.endElement();
        }
        for (FunctionStats functionStats : this.functions.values()) {
            attrs.clear();
            attrs.addAttribute("", "name", "name", "CDATA", functionStats.qname.getStringValue());
            attrs.addAttribute("", "elapsed", "elapsed", "CDATA", Double.toString((double)functionStats.executionTime / 1000.0));
            attrs.addAttribute("", "calls", "calls", "CDATA", Integer.toString(functionStats.callCount));
            if (functionStats.source != null) {
                attrs.addAttribute("", "source", "source", "CDATA", functionStats.source);
            }
            builder.startElement(new QName("function", XML_NAMESPACE, XML_PREFIX), attrs);
            builder.endElement();
        }
        for (IndexStats indexStats : this.indexStats.values()) {
            attrs.clear();
            attrs.addAttribute("", "type", "type", "CDATA", indexStats.indexType);
            attrs.addAttribute("", "source", "source", "CDATA", indexStats.source + " [" + indexStats.line + ":" + indexStats.column + "]");
            attrs.addAttribute("", "elapsed", "elapsed", "CDATA", Double.toString((double)indexStats.executionTime / 1000.0));
            attrs.addAttribute("", "calls", "calls", "CDATA", Integer.toString(indexStats.usageCount));
            attrs.addAttribute("", "optimization", "optimization", "CDATA", Integer.toString(indexStats.mode));
            builder.startElement(new QName("index", XML_NAMESPACE, XML_PREFIX), attrs);
            builder.endElement();
        }
        builder.endElement();
    }

    public synchronized void clear() {
        this.queries.clear();
        this.functions.clear();
        this.indexStats.clear();
    }

    public void reset() {
        this.queries.clear();
        this.functions.clear();
        this.indexStats.clear();
    }

    private static class CompareByTime
    implements Comparator<FunctionStats> {
        private CompareByTime() {
        }

        @Override
        public int compare(FunctionStats o1, FunctionStats o2) {
            long t1 = o1.executionTime;
            long t2 = o2.executionTime;
            return t1 == t2 ? 0 : (t1 > t2 ? 1 : -1);
        }
    }

    private static class FunctionStats
    extends QueryStats {
        QName qname;

        FunctionStats(String source, QName name) {
            super(source);
            this.qname = name;
        }

        @Override
        public int hashCode() {
            return 31 * this.qname.hashCode() + this.source.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj != null && obj instanceof FunctionStats) {
                FunctionStats ostats = (FunctionStats)obj;
                return this.qname.equals(ostats.qname) && this.source.equals(ostats.source);
            }
            return false;
        }
    }

    private static class QueryStats {
        String source;
        long executionTime = 0L;
        int callCount = 1;

        QueryStats(String source) {
            this.source = source;
            if (this.source == null) {
                this.source = "";
            }
        }

        public void recordCall(long elapsed) {
            this.executionTime += elapsed;
            ++this.callCount;
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof QueryStats) {
                return ((QueryStats)obj).source.equals(this.source);
            }
            return false;
        }
    }

    private static class IndexStats {
        String source;
        String indexType;
        int line;
        int column;
        int mode = 0;
        int usageCount = 1;
        long executionTime = 0L;

        private IndexStats(String indexType, String source, int line, int column, int mode) {
            this.indexType = indexType;
            this.source = source;
            this.line = line;
            this.column = column;
            this.mode = mode;
        }

        public void recordUsage(long elapsed) {
            this.executionTime += elapsed;
            ++this.usageCount;
        }

        public int hashCode() {
            return this.indexType.hashCode() + this.source.hashCode() + this.line + this.column + this.mode;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof IndexStats) {
                IndexStats other = (IndexStats)obj;
                return other.indexType.equals(this.indexType) && other.source.equals(this.source) && other.line == this.line && other.column == this.column && other.mode == this.mode;
            }
            return false;
        }
    }
}

