/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.storage.DBBroker;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.Option;
import org.exist.xquery.PerformanceStats;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;

public class Profiler {
    public static final int TIME = 1;
    public static final int OPTIMIZATIONS = 2;
    public static final int OPTIMIZATION_FLAGS = 3;
    public static final int DEPENDENCIES = 4;
    public static final int START_SEQUENCES = 4;
    public static final int ITEM_COUNT = 5;
    public static final int SEQUENCE_PREVIEW = 6;
    public static final int SEQUENCE_DUMP = 8;
    public static final String CONFIG_PROPERTY_TRACELOG = "xquery.profiling.tracelog";
    private Logger log = LogManager.getLogger((String)"xquery.profiling");
    private Stack<ProfiledExpr> stack = new Stack();
    private final StringBuilder buf = new StringBuilder(64);
    private boolean enabled = false;
    private boolean logEnabled = false;
    private int verbosity = 0;
    private PerformanceStats stats;
    private long queryStart = 0L;
    private Database db;

    public Profiler(Database db) {
        this.db = db;
        this.stats = new PerformanceStats(db);
    }

    public final void configure(Option pragma) {
        String[] options = pragma.tokenizeContents();
        for (int i = 0; i < options.length; ++i) {
            String[] params = Option.parseKeyValuePair(options[i]);
            if (params == null) continue;
            if ("trace".equals(params[0])) {
                this.stats.setEnabled(true);
                continue;
            }
            if ("tracelog".equals(params[0])) {
                this.logEnabled = "yes".equals(params[1]);
                continue;
            }
            if ("logger".equals(params[0])) {
                this.log = LogManager.getLogger((String)params[1]);
                continue;
            }
            if ("enabled".equals(params[0])) {
                this.enabled = "yes".equals(params[1]);
                continue;
            }
            if (!"verbosity".equals(params[0])) continue;
            try {
                this.verbosity = Integer.parseInt(params[1]);
                continue;
            }
            catch (NumberFormatException e) {
                this.log.warn("invalid value for verbosity: should be an integer between 0 and 8");
            }
        }
        if (this.verbosity == 0) {
            this.enabled = false;
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isLogEnabled() {
        try {
            DBBroker broker = this.db.getActiveBroker();
            Boolean globalProp = (Boolean)broker.getConfiguration().getProperty(CONFIG_PROPERTY_TRACELOG);
            return this.logEnabled || globalProp != null && globalProp != false;
        }
        catch (Throwable t) {
            this.log.debug("Ignored exception: " + t.getMessage());
            return this.logEnabled;
        }
    }

    public final void setLogEnabled(boolean enabled) {
        this.logEnabled = enabled;
    }

    public final boolean traceFunctions() {
        return this.stats.isEnabled() || this.isLogEnabled();
    }

    public final int verbosity() {
        return this.verbosity;
    }

    public final void traceQueryStart() {
        this.queryStart = System.currentTimeMillis();
    }

    public final void traceQueryEnd(XQueryContext context) {
        this.stats.recordQuery(context.getSource().path(), System.currentTimeMillis() - this.queryStart);
    }

    public final void traceFunctionStart(Function function) {
        if (this.isLogEnabled()) {
            this.log.trace(String.format("ENTER %-25s", function.getSignature().getName()));
        }
    }

    public final void traceFunctionEnd(Function function, long elapsed) {
        if (this.stats.isEnabled()) {
            String source = String.format("%s [%d:%d]", function.getContext().getSource().getKey(), function.getLine(), function.getColumn());
            this.stats.recordFunctionCall(function.getSignature().getName(), source, elapsed);
        }
        if (this.isLogEnabled()) {
            this.log.trace(String.format("EXIT  %-25s %10d ms", function.getSignature().getName(), elapsed));
        }
    }

    public final void traceIndexUsage(XQueryContext context, String indexType, Expression expression, int mode, long elapsed) {
        this.stats.recordIndexUse(expression, indexType, context.getSource().path(), mode, elapsed);
    }

    private void save() {
        if (this.db != null) {
            this.db.getPerformanceStats().merge(this.stats);
        }
    }

    public final void start(Expression expr) {
        this.start(expr, null);
    }

    public final void start(Expression expr, String message) {
        if (!this.enabled) {
            return;
        }
        if (this.stack.size() == 0) {
            this.log.debug("QUERY START");
        }
        this.buf.setLength(0);
        for (int i = 0; i < this.stack.size(); ++i) {
            this.buf.append('\t');
        }
        ProfiledExpr e = new ProfiledExpr(expr);
        this.stack.push(e);
        this.buf.append("START\t");
        this.printPosition(e.expr);
        this.buf.append(expr.toString());
        this.log.debug(this.buf.toString());
        if (message != null && !"".equals(message)) {
            this.buf.setLength(0);
            for (int i = 0; i < this.stack.size(); ++i) {
                this.buf.append('\t');
            }
            this.buf.append("MSG\t");
            this.buf.append(message);
            this.buf.append("\t");
            this.printPosition(e.expr);
            this.buf.append(expr.toString());
            this.log.debug(this.buf.toString());
        }
    }

    public final void end(Expression expr, String message, Sequence result) {
        if (!this.enabled) {
            return;
        }
        try {
            int i;
            ProfiledExpr e = this.stack.pop();
            if (e.expr != expr) {
                this.log.warn("Error: the object passed to end() does not correspond to the expression on top of the stack.");
                this.stack.clear();
                return;
            }
            long elapsed = System.currentTimeMillis() - e.start;
            if (message != null && !"".equals(message)) {
                this.buf.setLength(0);
                for (i = 0; i < this.stack.size(); ++i) {
                    this.buf.append('\t');
                }
                this.buf.append("MSG\t");
                this.buf.append(message);
                this.buf.append("\t");
                this.printPosition(e.expr);
                this.buf.append(expr.toString());
                this.log.debug(this.buf.toString());
            }
            if (this.verbosity > 4) {
                this.buf.setLength(0);
                for (i = 0; i < this.stack.size(); ++i) {
                    this.buf.append('\t');
                }
                this.buf.append("RESULT\t");
                if (this.verbosity >= 5) {
                    this.buf.append(result.getItemCount()).append(" item(s)");
                }
                this.buf.append("\t");
                this.printPosition(e.expr);
                this.buf.append(expr.toString());
                this.log.debug(this.buf.toString());
            }
            if (this.verbosity >= 1) {
                this.buf.setLength(0);
                for (i = 0; i < this.stack.size(); ++i) {
                    this.buf.append('\t');
                }
                this.buf.append("TIME\t");
                this.buf.append(elapsed).append(" ms");
                this.buf.append("\t");
                this.printPosition(e.expr);
                this.buf.append(expr.toString());
                this.log.debug(this.buf.toString());
            }
            this.buf.setLength(0);
            for (i = 0; i < this.stack.size(); ++i) {
                this.buf.append('\t');
            }
            this.buf.append("END\t");
            this.printPosition(e.expr);
            this.buf.append(expr.toString());
            this.log.debug(this.buf.toString());
            if (this.stack.size() == 0) {
                this.log.debug("QUERY END");
            }
        }
        catch (RuntimeException e) {
            this.log.debug("Profiler: could not pop from expression stack - " + expr + " - " + message + ". Error : " + e.getMessage());
        }
    }

    public final void message(Expression expr, int level, String title, Sequence sequence) {
        if (!this.enabled) {
            return;
        }
        if (level > this.verbosity) {
            return;
        }
        this.buf.setLength(0);
        for (int i = 0; i < this.stack.size() - 1; ++i) {
            this.buf.append('\t');
        }
        if (title != null && !"".equals(title)) {
            this.buf.append(title);
        } else {
            this.buf.append("MSG");
        }
        this.buf.append("\t");
        if (this.verbosity >= 5) {
            this.buf.append(sequence.getItemCount()).append(" item(s)");
        }
        this.buf.append("\t");
        this.buf.append(expr.toString());
        this.log.debug(this.buf.toString());
    }

    public final void message(Expression expr, int level, String title, String message) {
        if (!this.enabled) {
            return;
        }
        if (level > this.verbosity) {
            return;
        }
        this.buf.setLength(0);
        for (int i = 0; i < this.stack.size() - 1; ++i) {
            this.buf.append('\t');
        }
        if (title != null && !"".equals(title)) {
            this.buf.append(title);
        } else {
            this.buf.append("MSG");
        }
        if (message != null && !"".equals(message)) {
            this.buf.append("\t");
            this.buf.append(message);
        }
        this.buf.append("\t");
        this.printPosition(expr);
        this.buf.append(expr.toString());
        this.log.debug(this.buf.toString());
    }

    public void reset() {
        if (this.stack.size() > 0) {
            this.log.debug("QUERY RESET");
        }
        this.stack.clear();
        if (this.stats.isEnabled() && this.stats.hasData()) {
            this.save();
            this.stats.reset();
        }
    }

    private void printPosition(Expression expr) {
        if (expr.getLine() > -1) {
            this.buf.append('[');
            this.buf.append(expr.getLine());
            this.buf.append(',');
            this.buf.append(expr.getColumn());
            this.buf.append("]\t");
        } else {
            this.buf.append("\t");
        }
    }

    private String sequencePreview(Sequence sequence) {
        StringBuilder truncation = new StringBuilder();
        if (sequence.isEmpty()) {
            truncation.append(sequence.toString());
        } else if (sequence.hasOne()) {
            truncation.append("(");
            if (sequence.itemAt(0).toString().length() > 20) {
                truncation.append(sequence.itemAt(0).toString().substring(0, 20)).append("... ");
            } else {
                truncation.append(sequence.itemAt(0).toString());
            }
            truncation.append(")");
        } else {
            truncation.append("(");
            if (sequence.itemAt(0).toString().length() > 20) {
                truncation.append(sequence.itemAt(0).toString().substring(0, 20)).append("... ");
            } else {
                truncation.append(sequence.itemAt(0).toString());
            }
            truncation.append(", ... )");
        }
        return truncation.toString();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    private static final class ProfiledExpr {
        long start;
        Expression expr;

        private ProfiledExpr(Expression expression) {
            this.expr = expression;
            this.start = System.currentTimeMillis();
        }
    }
}

