/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.List;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.RangeSequence;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class RangeExpression
extends PathExpr {
    Expression start;
    Expression end;

    public RangeExpression(XQueryContext context) {
        super(context);
    }

    public void setArguments(List<Expression> arguments) throws XPathException {
        this.start = arguments.get(0);
        this.end = arguments.get(1);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.contextId = contextInfo.getContextId();
        contextInfo.setParent(this);
        this.start.analyze(contextInfo);
        this.end.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result = null;
        Sequence startSeq = this.start.eval(contextSequence, contextItem);
        Sequence endSeq = this.end.eval(contextSequence, contextItem);
        if (startSeq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else if (endSeq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            if (startSeq.hasMany()) {
                throw new XPathException(this, ErrorCodes.XPTY0004, "The first operand must have at most one item", startSeq);
            }
            if (endSeq.hasMany()) {
                throw new XPathException(this, ErrorCodes.XPTY0004, "The second operand must have at most one item", endSeq);
            }
            if (this.context.isBackwardsCompatible()) {
                NumericValue valueEnd;
                NumericValue valueStart;
                try {
                    valueStart = (NumericValue)startSeq.itemAt(0).convertTo(30);
                }
                catch (XPathException e) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Required type is " + Type.getTypeName(31) + " but got '" + Type.getTypeName(startSeq.itemAt(0).getType()) + "(" + startSeq.itemAt(0).getStringValue() + ")'", startSeq);
                }
                try {
                    valueEnd = (NumericValue)endSeq.itemAt(0).convertTo(30);
                }
                catch (XPathException e) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Required type is " + Type.getTypeName(31) + " but got '" + Type.getTypeName(endSeq.itemAt(0).getType()) + "(" + endSeq.itemAt(0).getStringValue() + ")'", endSeq);
                }
                if (valueStart.hasFractionalPart()) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Required type is " + Type.getTypeName(31) + " but got '" + Type.getTypeName(startSeq.itemAt(0).getType()) + "(" + startSeq.itemAt(0).getStringValue() + ")'", startSeq);
                }
                if (valueEnd.hasFractionalPart()) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Required type is " + Type.getTypeName(31) + " but got '" + Type.getTypeName(endSeq.itemAt(0).getType()) + "(" + startSeq.itemAt(0).getStringValue() + ")'", endSeq);
                }
                result = new RangeSequence((IntegerValue)valueStart.convertTo(31), (IntegerValue)valueEnd.convertTo(31));
            } else {
                if (!Type.subTypeOf(startSeq.itemAt(0).atomize().getType(), 31) && !Type.subTypeOf(startSeq.itemAt(0).atomize().getType(), 21)) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Required type is " + Type.getTypeName(31) + " but got '" + Type.getTypeName(startSeq.itemAt(0).getType()) + "(" + startSeq.itemAt(0).getStringValue() + ")'", startSeq);
                }
                if (!Type.subTypeOf(endSeq.itemAt(0).atomize().getType(), 31) && !Type.subTypeOf(endSeq.itemAt(0).atomize().getType(), 21)) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Required type is " + Type.getTypeName(31) + " but got '" + Type.getTypeName(endSeq.itemAt(0).getType()) + "(" + endSeq.itemAt(0).getStringValue() + ")'", endSeq);
                }
                IntegerValue valueStart = (IntegerValue)startSeq.itemAt(0).convertTo(31);
                IntegerValue valueEnd = (IntegerValue)endSeq.itemAt(0).convertTo(31);
                result = new RangeSequence(valueStart, valueEnd);
            }
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display(this.start);
        dumper.display(" to ");
        dumper.display(this.end);
    }

    @Override
    public int returnsType() {
        return 31;
    }

    @Override
    public Expression simplify() {
        return this;
    }
}

