/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.Sequence;

public class SimpleStep
extends Step {
    private final Expression expression;

    public SimpleStep(XQueryContext context, int axis, Expression expression) {
        super(context, axis);
        this.expression = expression;
        this.expression.setPrimaryAxis(axis);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
        super.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence result = Sequence.EMPTY_SEQUENCE;
        Sequence set = this.expression.eval(contextSequence);
        if (!set.isEmpty()) {
            if (set.isPersistentSet()) {
                NodeSet nodeSet = set.toNodeSet();
                switch (this.axis) {
                    case 8: {
                        result = nodeSet.selectAncestorDescendant(contextSequence.toNodeSet(), 1, true, this.contextId, true);
                        break;
                    }
                    case 5: {
                        result = nodeSet.selectParentChild(contextSequence.toNodeSet(), 1, this.contextId);
                        break;
                    }
                    default: {
                        throw new XPathException((Expression)this, "Wrong axis specified");
                    }
                }
            } else {
                MemoryNodeSet ctxNodes = contextSequence.toMemNodeSet();
                MemoryNodeSet nodes = set.toMemNodeSet();
                switch (this.axis) {
                    case 8: {
                        result = ctxNodes.selectDescendants(nodes);
                        break;
                    }
                    case 5: {
                        result = ctxNodes.selectChildren(nodes);
                    }
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void setPrimaryAxis(int axis) {
        this.expression.setPrimaryAxis(axis);
    }

    @Override
    public int getPrimaryAxis() {
        return this.expression.getPrimaryAxis();
    }
}

