/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.List;
import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunDeepEqual;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class SwitchExpression
extends AbstractExpression {
    private Expression operand;
    private Case defaultClause = null;
    private List<Case> cases = new ArrayList<Case>(5);

    public SwitchExpression(XQueryContext context, Expression operand) {
        super(context);
        this.operand = operand;
    }

    public void addCase(List<Expression> caseOperands, Expression returnClause) {
        this.cases.add(new Case(caseOperands, returnClause));
    }

    public void setDefault(Expression defaultClause) {
        this.defaultClause = new Case(null, defaultClause);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.getContext().getXQueryVersion() < 30) {
            throw new XPathException(this, ErrorCodes.EXXQDY0003, "switch expression is not available before XQuery 3.0", contextSequence);
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence opSeq = this.operand.eval(contextSequence);
        Sequence result = null;
        if (opSeq.isEmpty()) {
            result = this.defaultClause.returnClause.eval(contextSequence);
        } else {
            if (opSeq.hasMany()) {
                throw new XPathException(this, ErrorCodes.XPTY0004, "Cardinality error in switch operand ", opSeq);
            }
            AtomicValue opVal = opSeq.itemAt(0).atomize();
            Collator defaultCollator = this.context.getDefaultCollator();
            for (Case next : this.cases) {
                for (Expression caseOperand : next.operands) {
                    Sequence caseSeq = caseOperand.eval(contextSequence, contextItem);
                    if (caseSeq.hasMany()) {
                        throw new XPathException(this, ErrorCodes.XPTY0004, "Cardinality error in switch case operand ", caseSeq);
                    }
                    AtomicValue caseVal = caseSeq.itemAt(0).atomize();
                    if (!FunDeepEqual.deepEquals(caseVal, opVal, defaultCollator)) continue;
                    return next.returnClause.eval(contextSequence);
                }
            }
        }
        if (result == null) {
            result = this.defaultClause.returnClause.eval(contextSequence);
        }
        return result;
    }

    @Override
    public int returnsType() {
        return this.operand.returnsType();
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.operand.analyze(contextInfo);
        for (Case next : this.cases) {
            next.returnClause.analyze(contextInfo);
        }
        this.defaultClause.returnClause.analyze(contextInfo);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.operand.setContextDocSet(contextSet);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("switch(", this.line);
        this.operand.dump(dumper);
        dumper.display(')');
        dumper.startIndent();
        for (Case next : this.cases) {
            for (Expression caseOperand : next.operands) {
                dumper.display("case ");
                dumper.display(caseOperand);
            }
            dumper.display(" return ");
            dumper.display(next.returnClause).nl();
        }
        dumper.display("default ");
        this.defaultClause.returnClause.dump(dumper);
        dumper.endIndent();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.operand.accept(visitor);
        for (Case next : this.cases) {
            next.returnClause.accept(visitor);
        }
        this.defaultClause.returnClause.accept(visitor);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.operand.resetState(postOptimization);
        this.defaultClause.returnClause.resetState(postOptimization);
        for (Case next : this.cases) {
            next.returnClause.resetState(postOptimization);
        }
    }

    private static class Case {
        List<Expression> operands;
        Expression returnClause;

        public Case(List<Expression> caseOperands, Expression caseClause) {
            this.operands = caseOperands;
            this.returnClause = caseClause;
        }
    }
}

