/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class TryCatchExpression
extends AbstractExpression {
    private static final Logger LOG = LogManager.getLogger(TryCatchExpression.class);
    private static final QName QN_CODE = new QName("code", "http://www.w3.org/2005/xqt-errors", "err");
    private static final QName QN_DESCRIPTION = new QName("description", "http://www.w3.org/2005/xqt-errors", "err");
    private static final QName QN_VALUE = new QName("value", "http://www.w3.org/2005/xqt-errors", "err");
    private static final QName QN_MODULE = new QName("module", "http://www.w3.org/2005/xqt-errors", "err");
    private static final QName QN_LINE_NUM = new QName("line-number", "http://www.w3.org/2005/xqt-errors", "err");
    private static final QName QN_COLUMN_NUM = new QName("column-number", "http://www.w3.org/2005/xqt-errors", "err");
    private static final QName QN_ADDITIONAL = new QName("additional", "http://www.w3.org/2005/xqt-errors", "err");
    private static final QName QN_XQUERY_STACK_TRACE = new QName("xquery-stack-trace", "http://www.exist-db.org/xqt-errors/", "exerr");
    private static final QName QN_JAVA_STACK_TRACE = new QName("java-stack-trace", "http://www.exist-db.org/xqt-errors/", "exerr");
    private final Expression tryTargetExpr;
    private final List<CatchClause> catchClauses = new ArrayList<CatchClause>();

    public TryCatchExpression(XQueryContext context, Expression tryTargetExpr) {
        super(context);
        this.tryTargetExpr = tryTargetExpr;
    }

    public void addCatchClause(List<QName> catchErrorList, List<QName> catchVars, Expression catchExpr) {
        this.catchClauses.add(new CatchClause(catchErrorList, catchVars, catchExpr));
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    public Expression getTryTargetExpr() {
        return this.tryTargetExpr;
    }

    public List<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            contextInfo.setFlags(contextInfo.getFlags() & 0xFFFFFFFD);
            contextInfo.setParent(this);
            this.context.declareVariableBinding(new LocalVariable(QN_ADDITIONAL));
            this.context.declareVariableBinding(new LocalVariable(QN_COLUMN_NUM));
            this.context.declareVariableBinding(new LocalVariable(QN_LINE_NUM));
            this.context.declareVariableBinding(new LocalVariable(QN_CODE));
            this.context.declareVariableBinding(new LocalVariable(QN_DESCRIPTION));
            this.context.declareVariableBinding(new LocalVariable(QN_MODULE));
            this.context.declareVariableBinding(new LocalVariable(QN_VALUE));
            this.context.declareVariableBinding(new LocalVariable(QN_JAVA_STACK_TRACE));
            this.context.declareVariableBinding(new LocalVariable(QN_XQUERY_STACK_TRACE));
            this.tryTargetExpr.analyze(contextInfo);
            for (CatchClause catchClause : this.catchClauses) {
                catchClause.getCatchExpr().analyze(contextInfo);
            }
        }
        finally {
            this.context.popLocalVariables(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.context.expressionStart(this);
        if (this.getContext().getXQueryVersion() < 30) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0003, "The try-catch expression is only available in xquery version \"3.0\" and later.");
        }
        try {
            Sequence tryTargetSeq;
            Sequence sequence = tryTargetSeq = this.tryTargetExpr.eval(contextSequence, contextItem);
            return sequence;
        }
        catch (Throwable throwable) {
            XPathException xpe;
            ErrorCodes.ErrorCode errorCode = throwable instanceof XPathException ? ((xpe = (XPathException)throwable).getErrorCode() != null ? (xpe.getErrorCode() == ErrorCodes.ERROR ? this.extractErrorCode(xpe) : xpe.getErrorCode()) : this.extractErrorCode(xpe)) : new ErrorCodes.JavaErrorCode(throwable);
            QName errorCodeQname = errorCode.getErrorQName();
            Sequence catchResultSeq = null;
            LocalVariable mark0 = this.context.markLocalVariables(false);
            this.context.declareInScopeNamespace("err", "http://www.w3.org/2005/xqt-errors");
            this.context.declareInScopeNamespace("exerr", "http://www.exist-db.org/xqt-errors/");
            try {
                boolean errorMatched = false;
                for (CatchClause catchClause : this.catchClauses) {
                    if (!this.isErrorInList(errorCodeQname, catchClause.getCatchErrorList()) || errorMatched) continue;
                    errorMatched = true;
                    LocalVariable mark1 = this.context.markLocalVariables(false);
                    try {
                        this.addErrCode(errorCodeQname);
                        this.addErrDescription(throwable, errorCode);
                        this.addErrValue(throwable);
                        this.addErrModule(throwable);
                        this.addErrLineNumber(throwable);
                        this.addErrColumnNumber(throwable);
                        this.addErrAdditional(throwable);
                        this.addFunctionTrace(throwable);
                        this.addJavaTrace(throwable);
                        catchResultSeq = catchClause.getCatchExpr().eval(contextSequence, contextItem);
                        this.context.popLocalVariables(mark1, catchResultSeq);
                    }
                    catch (Throwable throwable2) {
                        this.context.popLocalVariables(mark1, catchResultSeq);
                        throw throwable2;
                    }
                }
                if (!errorMatched) {
                    if (throwable instanceof XPathException) {
                        throw throwable;
                    }
                    LOG.error((Object)throwable);
                    throw new XPathException(throwable);
                }
            }
            finally {
                this.context.popLocalVariables(mark0, catchResultSeq);
            }
            Sequence sequence = catchResultSeq;
            return sequence;
        }
        finally {
            this.context.expressionEnd(this);
        }
    }

    private void addErrAdditional(Throwable t) throws XPathException {
        LocalVariable err_additional = new LocalVariable(QN_ADDITIONAL);
        err_additional.setSequenceType(new SequenceType(11, 3));
        err_additional.setValue(Sequence.EMPTY_SEQUENCE);
        this.context.declareVariableBinding(err_additional);
    }

    private void addErrColumnNumber(Throwable t) throws XPathException {
        LocalVariable err_column_nr = new LocalVariable(QN_COLUMN_NUM);
        err_column_nr.setSequenceType(new SequenceType(31, 3));
        Sequence colNum = t != null && t instanceof XPathException ? new IntegerValue(((XPathException)t).getColumn()) : Sequence.EMPTY_SEQUENCE;
        err_column_nr.setValue(colNum);
        this.context.declareVariableBinding(err_column_nr);
    }

    private void addErrLineNumber(Throwable t) throws XPathException {
        LocalVariable err_line_nr = new LocalVariable(QN_LINE_NUM);
        err_line_nr.setSequenceType(new SequenceType(31, 3));
        Sequence lineNum = t != null && t instanceof XPathException ? new IntegerValue(((XPathException)t).getLine()) : Sequence.EMPTY_SEQUENCE;
        err_line_nr.setValue(lineNum);
        this.context.declareVariableBinding(err_line_nr);
    }

    private void addErrModule(Throwable t) throws XPathException {
        LocalVariable err_module = new LocalVariable(QN_MODULE);
        err_module.setSequenceType(new SequenceType(22, 3));
        Sequence module = t != null && t instanceof XPathException && ((XPathException)t).getSource() != null ? new StringValue(((XPathException)t).getSource().path()) : Sequence.EMPTY_SEQUENCE;
        err_module.setValue(module);
        this.context.declareVariableBinding(err_module);
    }

    private void addErrValue(Throwable t) throws XPathException {
        LocalVariable err_value = new LocalVariable(QN_VALUE);
        err_value.setSequenceType(new SequenceType(11, 7));
        Sequence errorValue = t != null ? (t instanceof XPathException && ((XPathException)t).getErrorVal() != null ? ((XPathException)t).getErrorVal() : Sequence.EMPTY_SEQUENCE) : null;
        err_value.setValue(errorValue);
        this.context.declareVariableBinding(err_value);
    }

    private void addErrDescription(Throwable t, ErrorCodes.ErrorCode errorCode) throws XPathException {
        Optional<String> errorDesc = Optional.ofNullable(errorCode.getDescription());
        Optional<String> throwableDesc = Optional.ofNullable(t instanceof XPathException ? ((XPathException)t).getDetailMessage() : t.getMessage());
        Sequence description = errorDesc.map(d -> new StringValue(throwableDesc.filter(td -> !td.equals(d)).map(td -> d + (d.endsWith(".") ? " " : ". ") + td).orElse((String)d))).orElse(errorDesc.map(StringValue::new).orElse(Sequence.EMPTY_SEQUENCE));
        LocalVariable err_description = new LocalVariable(QN_DESCRIPTION);
        err_description.setSequenceType(new SequenceType(24, 3));
        err_description.setValue(description);
        this.context.declareVariableBinding(err_description);
    }

    private void addErrCode(QName errorCodeQname) throws XPathException {
        LocalVariable err_code = new LocalVariable(QN_CODE);
        err_code.setSequenceType(new SequenceType(24, 2));
        err_code.setValue(new QNameValue(this.context, errorCodeQname));
        this.context.declareVariableBinding(err_code);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("try {");
        dumper.startIndent();
        this.tryTargetExpr.dump(dumper);
        dumper.endIndent();
        for (CatchClause catchClause : this.catchClauses) {
            Expression catchExpr = catchClause.getCatchExpr();
            dumper.nl().display("} catch (expr) {");
            dumper.startIndent();
            catchExpr.dump(dumper);
            dumper.nl().display("}");
            dumper.endIndent();
        }
    }

    private ErrorCodes.ErrorCode extractErrorCode(XPathException xpe) {
        String message = xpe.getMessage();
        if (':' == message.charAt(8)) {
            String[] data = this.extractLocalName(xpe.getMessage());
            ErrorCodes.ErrorCode errorCode = new ErrorCodes.ErrorCode(data[0], data[1]);
            LOG.debug("Parsed string '" + xpe.getMessage() + "' for Errorcode. Qname='" + data[0] + "' message='" + data[1] + "'");
            return errorCode;
        }
        Throwable retVal = xpe;
        Throwable cause = xpe.getCause();
        if (cause != null && !(cause instanceof XPathException)) {
            retVal = cause;
        }
        return new ErrorCodes.JavaErrorCode(retVal);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("try { ");
        result.append(this.tryTargetExpr.toString());
        for (CatchClause catchClause : this.catchClauses) {
            Expression catchExpr = catchClause.getCatchExpr();
            result.append(" } catch (expr) { ");
            result.append(catchExpr.toString());
            result.append("}");
        }
        return result.toString();
    }

    @Override
    public int returnsType() {
        return this.catchClauses.get(0).getCatchExpr().returnsType();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.tryTargetExpr.resetState(postOptimization);
        for (CatchClause catchClause : this.catchClauses) {
            Expression catchExpr = catchClause.getCatchExpr();
            catchExpr.resetState(postOptimization);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitTryCatch(this);
    }

    private boolean isErrorInList(QName error, List<QName> errors) {
        for (QName lError : errors) {
            if (!error.matches(lError)) continue;
            return true;
        }
        return false;
    }

    private String[] extractLocalName(String errorText) throws IllegalArgumentException {
        int p = errorText.indexOf(58);
        if (p == -1) {
            return new String[]{null, errorText};
        }
        return new String[]{errorText.substring(0, p).trim(), errorText.substring(p + 1).trim()};
    }

    /*
     * Exception decompiling
     */
    private String getStackTrace(Throwable t) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addFunctionTrace(Throwable t) throws XPathException {
        Sequence trace;
        LocalVariable localVar = new LocalVariable(QN_XQUERY_STACK_TRACE);
        localVar.setSequenceType(new SequenceType(22, 7));
        if (t != null && t instanceof XPathException) {
            List<XPathException.FunctionStackElement> callStack = ((XPathException)t).getCallStack();
            if (callStack == null) {
                trace = Sequence.EMPTY_SEQUENCE;
            } else {
                ValueSequence result = new ValueSequence();
                for (XPathException.FunctionStackElement elt : callStack) {
                    result.add(new StringValue("at " + elt.toString()));
                }
                trace = result;
            }
        } else {
            trace = Sequence.EMPTY_SEQUENCE;
        }
        localVar.setValue(trace);
        this.context.declareVariableBinding(localVar);
    }

    private void addJavaTrace(Throwable t) throws XPathException {
        Sequence trace;
        LocalVariable localVar = new LocalVariable(QN_JAVA_STACK_TRACE);
        localVar.setSequenceType(new SequenceType(24, 7));
        if (t != null && t.getStackTrace() != null) {
            ValueSequence result = new ValueSequence();
            this.addJavaTrace(t, result);
            trace = result;
        } else {
            trace = Sequence.EMPTY_SEQUENCE;
        }
        localVar.setValue(trace);
        this.context.declareVariableBinding(localVar);
    }

    private void addJavaTrace(Throwable t, Sequence result) throws XPathException {
        StackTraceElement[] elements = t.getStackTrace();
        result.add(new StringValue("Caused by: " + t.toString()));
        for (StackTraceElement elt : elements) {
            result.add(new StringValue("at " + elt.toString()));
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            this.addJavaTrace(cause, result);
        }
    }

    public static class CatchClause {
        private final List<QName> catchErrorList;
        private final List<QName> catchVars;
        private final Expression catchExpr;

        public CatchClause(List<QName> catchErrorList, List<QName> catchVars, Expression catchExpr) {
            this.catchErrorList = catchErrorList;
            this.catchVars = catchVars;
            this.catchExpr = catchExpr;
        }

        public List<QName> getCatchErrorList() {
            return this.catchErrorList;
        }

        public Expression getCatchExpr() {
            return this.catchExpr;
        }

        public List<QName> getCatchVars() {
            return this.catchVars;
        }
    }
}

