/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class TypeswitchExpression
extends AbstractExpression {
    private Expression operand;
    private Case defaultClause = null;
    private List<Case> cases = new ArrayList<Case>(5);

    public TypeswitchExpression(XQueryContext context, Expression operand) {
        super(context);
        this.operand = operand;
    }

    public void addCase(SequenceType[] types, QName var, Expression caseClause) {
        this.cases.add(new Case(types, var, caseClause));
    }

    public void setDefault(QName var, Expression defaultClause) {
        this.defaultClause = new Case(null, var, defaultClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence opSeq = this.operand.eval(contextSequence);
        Sequence result = null;
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            block3: for (int i = 0; i < this.cases.size() && result == null; ++i) {
                Case next = this.cases.get(i);
                for (SequenceType type : next.types) {
                    if (!this.checkType(type, opSeq)) continue;
                    if (next.variable != null) {
                        LocalVariable var = new LocalVariable(next.variable);
                        var.setSequenceType(type);
                        var.setValue(opSeq);
                        var.setContextDocs(this.operand.getContextDocSet());
                        var.checkType();
                        this.context.declareVariableBinding(var);
                    }
                    result = next.returnClause.eval(contextSequence);
                    continue block3;
                }
            }
            if (result == null) {
                if (this.defaultClause.variable != null) {
                    LocalVariable var = new LocalVariable(this.defaultClause.variable);
                    var.setValue(opSeq);
                    var.setContextDocs(this.operand.getContextDocSet());
                    this.context.declareVariableBinding(var);
                }
                result = this.defaultClause.returnClause.eval(contextSequence);
            }
        }
        finally {
            this.context.popLocalVariables(mark, result);
        }
        return result;
    }

    private boolean checkType(SequenceType type, Sequence seq) throws XPathException {
        int actualCardinality;
        int requiredCardinality = type.getCardinality();
        if (!Cardinality.checkCardinality(requiredCardinality, actualCardinality = seq.isEmpty() ? 1 : (seq.hasMany() ? 4 : 2))) {
            return false;
        }
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (type.checkType(next)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int returnsType() {
        return this.operand.returnsType();
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.operand.analyze(contextInfo);
        LocalVariable mark0 = this.context.markLocalVariables(false);
        try {
            for (Case next : this.cases) {
                LocalVariable mark1 = this.context.markLocalVariables(false);
                try {
                    if (next.variable != null) {
                        LocalVariable var = new LocalVariable(next.variable);
                        if (next.types.length == 1) {
                            var.setSequenceType(next.types[0]);
                        }
                        this.context.declareVariableBinding(var);
                    }
                    next.returnClause.analyze(contextInfo);
                }
                finally {
                    this.context.popLocalVariables(mark1);
                }
            }
            if (this.defaultClause.variable != null) {
                LocalVariable var = new LocalVariable(this.defaultClause.variable);
                this.context.declareVariableBinding(var);
            }
            this.defaultClause.returnClause.analyze(contextInfo);
        }
        finally {
            this.context.popLocalVariables(mark0);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.operand.accept(visitor);
        for (Case next : this.cases) {
            next.returnClause.accept(visitor);
        }
        this.defaultClause.returnClause.accept(visitor);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.operand.setContextDocSet(contextSet);
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("typeswitch(", this.line);
        this.operand.dump(dumper);
        dumper.display(')');
        dumper.startIndent();
        for (int i = 0; i < this.cases.size(); ++i) {
            Case caseClause = this.cases.get(i);
            dumper.display("case ");
            if (caseClause.variable != null) {
                dumper.display('$');
                dumper.display(caseClause.variable.getStringValue());
                dumper.display(" as ");
            }
            for (int j = 0; j < caseClause.types.length; ++j) {
                if (j > 0) {
                    dumper.display(" | ");
                }
                dumper.display(caseClause.types[j]);
            }
            dumper.display(" return ");
            dumper.display(caseClause.returnClause).nl();
        }
        dumper.display("default ");
        if (this.defaultClause.variable != null) {
            dumper.display('$');
            dumper.display(this.defaultClause.variable.getStringValue());
            dumper.display(' ');
        }
        this.defaultClause.returnClause.dump(dumper);
        dumper.endIndent();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.operand.resetState(postOptimization);
        this.defaultClause.returnClause.resetState(postOptimization);
        for (int i = 0; i < this.cases.size(); ++i) {
            Case caseClause = this.cases.get(i);
            caseClause.returnClause.resetState(postOptimization);
        }
    }

    private static class Case {
        SequenceType[] types;
        Expression returnClause;
        QName variable;

        public Case(SequenceType[] types, QName variable, Expression caseClause) {
            this.types = types;
            this.variable = variable;
            this.returnClause = caseClause;
        }
    }
}

