/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.CombiningExpression;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Union
extends CombiningExpression {
    public Union(XQueryContext context, PathExpr left, PathExpr right) {
        super(context, left, right);
    }

    @Override
    public Sequence combine(Sequence ls, Sequence rs) throws XPathException {
        Sequence result;
        if (ls.isEmpty() && rs.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else if (rs.isEmpty()) {
            if (!Type.subTypeOf(ls.getItemType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "union operand is not a node sequence");
            }
            result = ls;
        } else if (ls.isEmpty()) {
            if (!Type.subTypeOf(rs.getItemType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "union operand is not a node sequence");
            }
            result = rs;
        } else {
            if (!Type.subTypeOf(ls.getItemType(), -1) || !Type.subTypeOf(rs.getItemType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "union operand is not a node sequence");
            }
            if (ls.isPersistentSet() && rs.isPersistentSet()) {
                result = ls.toNodeSet().union(rs.toNodeSet());
            } else {
                ValueSequence values = new ValueSequence(true);
                values.addAll(ls);
                values.addAll(rs);
                values.sortInDocumentOrder();
                values.removeDuplicates();
                result = values;
            }
        }
        return result;
    }

    @Override
    protected String getOperatorName() {
        return "union";
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitUnionExpr(this);
    }
}

