/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.ClosureVariable;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class UserDefinedFunction
extends Function
implements Cloneable {
    private Expression body;
    private List<QName> parameters = new ArrayList<QName>(5);
    private Sequence[] currentArguments = null;
    private DocumentSet[] contextDocs = null;
    private boolean bodyAnalyzed = false;
    private FunctionCall call;
    private boolean hasBeenReset = false;
    private boolean visited = false;
    private List<ClosureVariable> closureVariables = null;

    public UserDefinedFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void setFunctionBody(Expression body) {
        this.body = body.simplify();
    }

    public Expression getFunctionBody() {
        return this.body;
    }

    public void addVariable(String varName) throws XPathException {
        try {
            QName qname = QName.parse(this.context, varName, null);
            this.addVariable(qname);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + varName);
        }
    }

    public void addVariable(QName varName) throws XPathException {
        if (this.parameters.contains(varName)) {
            throw new XPathException("XQST0039: function " + this.getName() + " is already have parameter with the name " + varName);
        }
        this.parameters.add(varName);
    }

    public void setArguments(Sequence[] args, DocumentSet[] contextDocs) throws XPathException {
        this.currentArguments = args;
        this.contextDocs = contextDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.hasBeenReset = false;
        if (this.call != null && !this.call.isRecursive()) {
            LocalVariable mark = this.context.markLocalVariables(true);
            if (this.closureVariables != null) {
                this.context.restoreStack(this.closureVariables);
            }
            try {
                for (QName varName : this.parameters) {
                    LocalVariable var = new LocalVariable(varName);
                    this.context.declareVariableBinding(var);
                }
                AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
                newContextInfo.setParent(this);
                if (!this.bodyAnalyzed) {
                    this.body.analyze(newContextInfo);
                    this.bodyAnalyzed = true;
                }
            }
            finally {
                this.context.popLocalVariables(mark);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.context.stackEnter(this);
        this.hasBeenReset = false;
        LocalVariable mark = this.context.markLocalVariables(true);
        if (this.closureVariables != null) {
            this.context.restoreStack(this.closureVariables);
        }
        Sequence result = null;
        try {
            int j = 0;
            int i = 0;
            while (i < this.parameters.size()) {
                QName varName = this.parameters.get(i);
                LocalVariable var = new LocalVariable(varName);
                var.setValue(this.currentArguments[j]);
                if (this.contextDocs != null) {
                    var.setContextDocs(this.contextDocs[i]);
                }
                this.context.declareVariableBinding(var);
                int actualCardinality = this.currentArguments[j].isEmpty() ? 1 : (this.currentArguments[j].hasMany() ? 4 : 2);
                if (!Cardinality.checkCardinality(this.getSignature().getArgumentTypes()[j].getCardinality(), actualCardinality)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Invalid cardinality for parameter $" + varName + ". Expected " + Cardinality.getDescription(this.getSignature().getArgumentTypes()[j].getCardinality()) + ", got " + this.currentArguments[j].getItemCount());
                }
                ++i;
                ++j;
            }
            Sequence sequence = result = this.body.eval(contextSequence, contextItem);
            this.context.popLocalVariables(mark, result);
            this.context.stackLeave(this);
            return sequence;
        }
        catch (Throwable throwable) {
            this.context.popLocalVariables(mark, result);
            this.context.stackLeave(this);
            throw throwable;
        }
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        FunctionSignature signature = this.getSignature();
        if (signature.getName() != null) {
            dumper.display(signature.getName());
        }
        dumper.display('(');
        for (int i = 0; i < signature.getArgumentTypes().length; ++i) {
            if (i > 0) {
                dumper.display(", ");
            }
            dumper.display(signature.getArgumentTypes()[i]);
        }
        dumper.display(") ");
        dumper.display(signature.getReturnType().toString());
    }

    @Override
    public String toString() {
        FunctionSignature signature = this.getSignature();
        StringBuilder buf = new StringBuilder();
        if (signature.getName() != null) {
            buf.append(signature.getName());
        }
        buf.append('(');
        for (int i = 0; i < signature.getArgumentTypes().length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(signature.getArgumentTypes()[i]);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int getDependencies() {
        return 19;
    }

    @Override
    public void resetState(boolean postOptimization) {
        if (this.hasBeenReset) {
            return;
        }
        this.hasBeenReset = true;
        super.resetState(postOptimization);
        this.bodyAnalyzed = false;
        this.body.resetState(postOptimization);
        if (!postOptimization) {
            this.currentArguments = null;
            this.contextDocs = null;
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (this.visited) {
            return;
        }
        this.visited = true;
        visitor.visitUserFunction(this);
    }

    public List<QName> getParameters() {
        return this.parameters;
    }

    public synchronized Object clone() {
        try {
            UserDefinedFunction clone = (UserDefinedFunction)super.clone();
            clone.currentArguments = null;
            clone.contextDocs = null;
            clone.body = this.body;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public FunctionCall getCaller() {
        return this.call;
    }

    public void setCaller(FunctionCall call) {
        this.call = call;
    }

    public void setClosureVariables(List<ClosureVariable> vars) {
        this.closureVariables = vars;
    }

    public List<ClosureVariable> getClosureVariables() {
        return this.closureVariables;
    }

    protected Sequence[] getCurrentArguments() {
        return this.currentArguments;
    }
}

