/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Optional;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Module;
import org.exist.xquery.RewritableExpression;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class VariableDeclaration
extends AbstractExpression
implements RewritableExpression {
    final QName qname;
    Optional<Expression> expression;
    SequenceType sequenceType = null;
    boolean analyzeDone = false;

    public VariableDeclaration(XQueryContext context, QName qname, Expression expr) {
        super(context);
        this.qname = qname;
        this.expression = Optional.ofNullable(expr);
    }

    public QName getName() {
        return this.qname;
    }

    public void setSequenceType(SequenceType type) {
        this.sequenceType = type;
    }

    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        VariableImpl var = new VariableImpl(this.qname);
        var.setIsInitialized(false);
        if (!this.analyzeDone) {
            Module myModule = this.context.getModule(this.qname.getNamespaceURI());
            if (myModule != null) {
                myModule.declareVariable(var);
            } else {
                this.context.declareGlobalVariable(var);
            }
            this.analyzeDone = true;
        }
        if (this.expression.isPresent()) {
            this.expression.get().analyze(contextInfo);
        }
        var.setIsInitialized(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        this.context.pushInScopeNamespaces(false);
        try {
            Module myModule = this.context.getRootModule(this.qname.getNamespaceURI());
            this.context.pushDocumentContext();
            try {
                this.context.prologEnter(this);
                if (this.expression.isPresent()) {
                    Sequence seq = this.expression.get().eval(contextSequence, null);
                    if (myModule != null) {
                        Variable var = myModule.declareVariable(this.qname, seq);
                        var.setSequenceType(this.sequenceType);
                        var.checkType();
                    } else {
                        VariableImpl var = new VariableImpl(this.qname);
                        var.setValue(seq);
                        var.setSequenceType(this.sequenceType);
                        var.checkType();
                        this.context.declareGlobalVariable(var);
                    }
                    if (this.context.getProfiler().isEnabled()) {
                        this.context.getProfiler().end(this, "", seq);
                    }
                } else {
                    Variable external = this.context.resolveGlobalVariable(this.qname);
                    if (external == null) {
                        throw new XPathException(ErrorCodes.XPDY0002, "no value specified for external variable " + this.qname);
                    }
                    external.setSequenceType(this.sequenceType);
                    if (myModule != null) {
                        myModule.declareVariable(external);
                    }
                }
            }
            finally {
                this.context.popDocumentContext();
            }
        }
        finally {
            this.context.popInScopeNamespaces();
        }
        return null;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.nl().display("declare variable $").display(this.qname.toString(), this.line);
        if (this.sequenceType != null) {
            dumper.display(" as ").display(this.sequenceType.toString());
        }
        dumper.display("{");
        dumper.startIndent();
        this.expression.ifPresent(e -> e.dump(dumper));
        dumper.endIndent();
        dumper.nl().display("}").nl();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("declare variable $").append(this.qname);
        if (this.sequenceType != null) {
            result.append(" as ").append(this.sequenceType.toString());
        }
        if (this.expression.isPresent()) {
            result.append("{");
            result.append(this.expression.toString());
            result.append("}");
        }
        return result.toString();
    }

    @Override
    public int returnsType() {
        return this.expression.isPresent() ? this.expression.get().returnsType() : 11;
    }

    @Override
    public int getDependencies() {
        return 1;
    }

    @Override
    public int getCardinality() {
        return this.expression.isPresent() ? this.expression.get().getCardinality() : 6;
    }

    public Optional<Expression> getExpression() {
        return this.expression;
    }

    @Override
    public void replace(Expression oldExpr, Expression newExpr) {
        if (this.expression.isPresent() && this.expression.get() == oldExpr) {
            this.expression = Optional.ofNullable(newExpr);
        }
    }

    @Override
    public Expression getPrevious(Expression current) {
        return null;
    }

    @Override
    public Expression getFirst() {
        return null;
    }

    @Override
    public void remove(Expression oldExpr) throws XPathException {
    }

    @Override
    public boolean allowMixedNodesInReturn() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitVariableDeclaration(this);
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.ifPresent(e -> e.resetState(postOptimization));
        if (!postOptimization) {
            this.analyzeDone = false;
        }
    }
}

