/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.Atomize;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class VariableImpl
implements Variable {
    private final QName qname;
    private Sequence value = null;
    private int positionInStack = 0;
    private DocumentSet contextDocs = null;
    private SequenceType type = null;
    private int staticType = 11;
    private boolean initialized = true;

    public VariableImpl(QName qname) {
        this.qname = qname;
    }

    public VariableImpl(VariableImpl var) {
        this(var.qname);
        this.value = var.value;
        this.contextDocs = var.contextDocs;
        this.type = var.type;
        this.staticType = var.staticType;
    }

    @Override
    public void setValue(Sequence val) {
        this.value = val;
        if (val instanceof NodeImpl) {
            ValueSequence newSeq = new ValueSequence(1);
            newSeq.add((Item)((Object)val));
            newSeq.setHolderVariable(this);
            this.value = newSeq;
        } else if (val instanceof ValueSequence) {
            ((ValueSequence)this.value).setHolderVariable(this);
        }
    }

    @Override
    public Sequence getValue() {
        return this.value;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public int getType() {
        if (this.type != null) {
            return this.type.getPrimaryType();
        }
        return 11;
    }

    @Override
    public void setSequenceType(SequenceType type) throws XPathException {
        this.type = type;
        if (this.getValue() != null && this.getSequenceType() != null) {
            int actualCardinality = this.getValue().isEmpty() ? 1 : (this.getValue().hasMany() ? 4 : 2);
            if (!Cardinality.checkCardinality(this.getSequenceType().getCardinality(), actualCardinality)) {
                throw new XPathException("XPTY0004: Invalid cardinality for variable $" + this.getQName() + ". Expected " + Cardinality.getDescription(this.getSequenceType().getCardinality()) + ", got " + Cardinality.getDescription(actualCardinality));
            }
            if (!Type.subTypeOf(this.getSequenceType().getPrimaryType(), -1) ? !this.getValue().isEmpty() && !Type.subTypeOf(this.getValue().getItemType(), this.getSequenceType().getPrimaryType()) : !this.getValue().isEmpty() && !Type.subTypeOf(this.getValue().getItemType(), this.getSequenceType().getPrimaryType())) {
                throw new XPathException("XPTY0004: Invalid type for variable $" + this.getQName() + ". Expected " + Type.getTypeName(this.getSequenceType().getPrimaryType()) + ", got " + Type.getTypeName(this.getValue().getItemType()));
            }
        }
    }

    @Override
    public SequenceType getSequenceType() {
        return this.type;
    }

    @Override
    public void setStaticType(int type) {
        this.staticType = type;
    }

    @Override
    public int getStaticType() {
        return this.staticType;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setIsInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void destroy(XQueryContext context, Sequence contextSequence) {
        if (this.value != null) {
            this.value.destroy(context, contextSequence);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("$").append(this.qname.getStringValue());
        result.append(" as ");
        result.append(Type.getTypeName(this.getType()));
        result.append(Cardinality.toString(this.getCardinality()));
        result.append(" ");
        if (this.value == null) {
            result.append("[not set]");
        } else {
            result.append(":= ").append(this.value.toString());
        }
        return result.toString();
    }

    @Override
    public int getDependencies(XQueryContext context) {
        if (context.getCurrentStackSize() > this.positionInStack) {
            return 9;
        }
        return 5;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    @Override
    public void setStackPosition(int position) {
        this.positionInStack = position;
    }

    @Override
    public DocumentSet getContextDocs() {
        return this.contextDocs;
    }

    @Override
    public void setContextDocs(DocumentSet docs) {
        this.contextDocs = docs;
    }

    @Override
    public void checkType() throws XPathException {
        if (this.type == null) {
            return;
        }
        this.type.checkCardinality(this.value);
        if (this.value.isEmpty()) {
            return;
        }
        int requiredType = this.type.getPrimaryType();
        if (Type.subTypeOf(requiredType, 20)) {
            if (!Type.subTypeOf(this.value.getItemType(), 20)) {
                this.value = Atomize.atomize(this.value);
            }
            if (requiredType != 20) {
                this.value = this.convert(this.value);
            }
        }
        if (!this.type.checkType(this.value)) {
            throw new XPathException(Messages.getMessage("D07", this.toString(), this.type.toString(), new SequenceType(this.value.getItemType(), this.value.getCardinality()).toString()));
        }
    }

    private Sequence convert(Sequence seq) throws XPathException {
        ValueSequence result = new ValueSequence();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            result.add(item.convertTo(this.type.getPrimaryType()));
        }
        return result;
    }
}

