/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.ContextItem;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.xquery.AbstractFLWORClause;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FLWORClause;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class WhereClause
extends AbstractFLWORClause {
    protected Expression whereExpr;
    protected boolean fastTrack = false;

    public WhereClause(XQueryContext context, Expression whereExpr) {
        super(context);
        this.whereExpr = whereExpr;
    }

    @Override
    public FLWORClause.ClauseType getType() {
        return FLWORClause.ClauseType.WHERE;
    }

    public Expression getWhereExpr() {
        return this.whereExpr;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.setFlags(contextInfo.getFlags() | 2 | 4);
        newContextInfo.setContextId(this.getExpressionId());
        this.whereExpr.analyze(newContextInfo);
        newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.addFlag(1);
        this.returnExpr.analyze(newContextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence preEval(Sequence in) throws XPathException {
        if (in != null && Type.subTypeOf(in.getItemType(), -1) && in.isPersistentSet() && !Dependency.dependsOn(this.whereExpr, 2) && Type.subTypeOf(this.whereExpr.returnsType(), 11)) {
            if (!in.isCached()) {
                BindingExpression.setContext(this.getExpressionId(), in);
            }
            try {
                Sequence seq;
                Sequence sequence = seq = in.isEmpty() ? in : this.whereExpr.eval(in);
                if (Type.subTypeOf(this.whereExpr.returnsType(), -1)) {
                    NodeSet nodes = seq.toNodeSet();
                    NodeSet contextSet = in.toNodeSet();
                    boolean contextIsVirtual = contextSet instanceof VirtualNodeSet;
                    ExtArrayNodeSet result = new ExtArrayNodeSet();
                    DocumentImpl lastDoc = null;
                    for (NodeProxy current : nodes) {
                        ContextItem context;
                        int sizeHint = -1;
                        if (lastDoc == null || current.getOwnerDocument() != lastDoc) {
                            lastDoc = current.getOwnerDocument();
                            sizeHint = nodes.getSizeHint(lastDoc);
                        }
                        if ((context = current.getContext()) == null) {
                            throw new XPathException((Expression)this, "Internal evaluation error: context node is missing for node " + current.getNodeId() + "!");
                        }
                        while (context != null) {
                            if (context.getContextId() == this.whereExpr.getContextId()) {
                                NodeProxy contextNode = context.getNode();
                                if (contextIsVirtual || contextSet.contains(contextNode)) {
                                    contextNode.addMatches(current);
                                    result.add(contextNode, sizeHint);
                                }
                            }
                            context = context.getNextDirect();
                        }
                    }
                    this.fastTrack = true;
                    ExtArrayNodeSet extArrayNodeSet = result;
                    return extArrayNodeSet;
                }
            }
            finally {
                if (!in.isCached()) {
                    BindingExpression.clearContext(this.getExpressionId(), in);
                }
            }
        }
        return super.preEval(in);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.applyWhereExpression()) {
            return this.returnExpr.eval(null);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public Sequence postEval(Sequence seq) throws XPathException {
        this.fastTrack = false;
        if (this.returnExpr instanceof FLWORClause) {
            seq = ((FLWORClause)this.returnExpr).postEval(seq);
        }
        return super.postEval(seq);
    }

    private boolean applyWhereExpression() throws XPathException {
        if (this.fastTrack) {
            return true;
        }
        Sequence innerSeq = this.whereExpr.eval(null);
        return innerSeq.effectiveBooleanValue();
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("where", this.whereExpr.getLine());
        dumper.startIndent();
        this.whereExpr.dump(dumper);
        dumper.endIndent().nl();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.whereExpr.resetState(postOptimization);
        this.returnExpr.resetState(postOptimization);
    }
}

