/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.debuggee.Debuggee;
import org.exist.debuggee.DebuggeeJoint;
import org.exist.dom.QName;
import org.exist.dom.memtree.InMemoryXMLStreamReader;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.http.servlets.RequestWrapper;
import org.exist.interpreter.Context;
import org.exist.numbering.NodeId;
import org.exist.repo.ExistRepository;
import org.exist.security.AuthenticationException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.stax.ExtendedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.UpdateListener;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.util.Collations;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.util.hashtable.NamePool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.ClosureVariable;
import org.exist.xquery.ContextItemDeclaration;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.ExternalModuleImpl;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionId;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.Module;
import org.exist.xquery.ModuleContext;
import org.exist.xquery.Optimizer;
import org.exist.xquery.Option;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Pragma;
import org.exist.xquery.Profiler;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.pragmas.ForceIndexUse;
import org.exist.xquery.pragmas.NoIndexPragma;
import org.exist.xquery.pragmas.Optimize;
import org.exist.xquery.pragmas.ProfilePragma;
import org.exist.xquery.pragmas.TimerPragma;
import org.exist.xquery.update.Modification;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class XQueryContext
implements BinaryValueManager,
Context {
    public static final String ENABLE_QUERY_REWRITING_ATTRIBUTE = "enable-query-rewriting";
    public static final String XQUERY_BACKWARD_COMPATIBLE_ATTRIBUTE = "backwardCompatible";
    public static final String XQUERY_RAISE_ERROR_ON_FAILED_RETRIEVAL_ATTRIBUTE = "raise-error-on-failed-retrieval";
    public static final String ENFORCE_INDEX_USE_ATTRIBUTE = "enforce-index-use";
    public static final String BUILT_IN_MODULE_URI_ATTRIBUTE = "uri";
    public static final String BUILT_IN_MODULE_CLASS_ATTRIBUTE = "class";
    public static final String BUILT_IN_MODULE_SOURCE_ATTRIBUTE = "src";
    public static final String PROPERTY_XQUERY_BACKWARD_COMPATIBLE = "xquery.backwardCompatible";
    public static final String PROPERTY_ENABLE_QUERY_REWRITING = "xquery.enable-query-rewriting";
    public static final String PROPERTY_XQUERY_RAISE_ERROR_ON_FAILED_RETRIEVAL = "xquery.raise-error-on-failed-retrieval";
    public static final boolean XQUERY_RAISE_ERROR_ON_FAILED_RETRIEVAL_DEFAULT = false;
    public static final String PROPERTY_ENFORCE_INDEX_USE = "xquery.enforce-index-use";
    public static final String PROPERTY_BUILT_IN_MODULES = "xquery.modules";
    public static final String PROPERTY_STATIC_MODULE_MAP = "xquery.modules.static";
    public static final String PROPERTY_MODULE_PARAMETERS = "xquery.modules.parameters";
    public static final String JAVA_URI_START = "java:";
    protected static final Logger LOG = LogManager.getLogger(XQueryContext.class);
    private static final String TEMP_STORE_ERROR = "Error occurred while storing temporary data";
    public static final String XQUERY_CONTEXTVAR_XQUERY_UPDATE_ERROR = "_eXist_xquery_update_error";
    public static final String HTTP_SESSIONVAR_XMLDB_USER = "_eXist_xmldb_user";
    public static final String HTTP_REQ_ATTR_USER = "xquery.user";
    public static final String HTTP_REQ_ATTR_PASS = "xquery.password";
    protected HashMap<String, String> staticNamespaces = new HashMap();
    protected HashMap<String, String> staticPrefixes = new HashMap();
    protected HashMap<String, String> inScopeNamespaces = new HashMap();
    protected HashMap<String, String> inScopePrefixes = new HashMap();
    protected HashMap<String, String> inheritedInScopeNamespaces = new HashMap();
    protected HashMap<String, String> inheritedInScopePrefixes = new HashMap();
    protected HashMap<String, XmldbURI> mappedModules = new HashMap();
    private boolean preserveNamespaces = true;
    private boolean inheritNamespaces = true;
    protected Stack<HashMap<String, String>> namespaceStack = new Stack();
    protected TreeMap<FunctionId, UserDefinedFunction> declaredFunctions = new TreeMap();
    protected Map<QName, Variable> globalVariables = new TreeMap<QName, Variable>();
    protected LocalVariable lastVar = null;
    protected Stack<LocalVariable> contextStack = new Stack();
    protected Stack<FunctionSignature> callStack = new Stack();
    protected int variableStackSize = 0;
    protected Deque<FunctionCall> forwardReferences = new ArrayDeque<FunctionCall>();
    protected List<Option> staticOptions = null;
    protected List<Option> dynamicOptions = null;
    XMLGregorianCalendar calendar = null;
    TimeZone implicitTimeZone = null;
    protected XQueryWatchDog watchdog;
    protected HashMap<String, Module> modules = new HashMap();
    protected HashMap<String, Module> allModules = new HashMap();
    protected SavedState savedState = new SavedState();
    private boolean modulesChanged = true;
    protected XmldbURI[] staticDocumentPaths = null;
    protected DocumentSet staticDocuments = null;
    protected XmldbURI[] staticCollections = null;
    protected MutableDocumentSet modifiedDocuments = null;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected AnyURIValue baseURI = AnyURIValue.EMPTY_URI;
    protected boolean baseURISetInProlog = false;
    protected String moduleLoadPath = ".";
    protected String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    protected AnyURIValue defaultElementNamespace = AnyURIValue.EMPTY_URI;
    protected AnyURIValue defaultElementNamespaceSchema = AnyURIValue.EMPTY_URI;
    private String defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private Collator defaultCollator = null;
    private boolean backwardsCompatible = false;
    private boolean stripWhitespace = true;
    private boolean orderEmptyGreatest = true;
    private ContextItemDeclaration contextItemDeclaration = null;
    private Sequence contextItem = Sequence.EMPTY_SEQUENCE;
    private int contextPosition = 0;
    private Sequence contextSequence = null;
    private NamePool sharedNamePool = null;
    private Stack<MemTreeBuilder> fragmentStack = new Stack();
    private Expression rootExpression;
    private int expressionCounter = 0;
    private LockedDocumentMap protectedDocuments = null;
    protected Profiler profiler;
    HashMap<String, Object> XQueryContextVars = new HashMap();
    Map<String, String> envs;
    private ContextUpdateListener updateListener = null;
    private boolean enableOptimizer = true;
    private boolean raiseErrorOnFailedRetrieval = false;
    private boolean isShared = false;
    private Source source = null;
    private DebuggeeJoint debuggeeJoint = null;
    private int xqueryVersion = 31;
    protected Database db;
    private boolean analyzed = false;
    private Subject realUser;
    private boolean pushedUserFromHttpSession = false;
    private MemTreeBuilder documentBuilder = null;
    private Deque<BinaryValue> binaryValueInstances;
    private final List<CleanupTask> cleanupTasks = new ArrayList<CleanupTask>();

    public synchronized Optional<ExistRepository> getRepository() throws XPathException {
        return this.getBroker().getBrokerPool().getExpathRepo();
    }

    private Module resolveInEXPathRepository(String namespace, String prefix) throws XPathException {
        Module jMod;
        Optional<ExistRepository> repo = this.getRepository();
        if (repo.isPresent() && (jMod = repo.get().resolveJavaModule(namespace, this)) != null) {
            return jMod;
        }
        Path resolved = null;
        if (repo.isPresent() && (resolved = repo.get().resolveXQueryModule(namespace)) == null) {
            return null;
        }
        FileSource src = new FileSource(resolved, false);
        return this.compileOrBorrowModule(prefix, namespace, "", src);
    }

    public XQueryContext() {
        this.profiler = new Profiler(null);
    }

    public XQueryContext(Database db) {
        this();
        this.db = db;
        this.loadDefaults(db.getConfiguration());
        this.profiler = new Profiler(db);
    }

    public XQueryContext(XQueryContext copyFrom) {
        this();
        this.db = copyFrom.db;
        this.loadDefaultNS();
        for (String prefix : copyFrom.staticNamespaces.keySet()) {
            if ("xml".equals(prefix) || "xmlns".equals(prefix)) continue;
            try {
                this.declareNamespace(prefix, copyFrom.staticNamespaces.get(prefix));
            }
            catch (XPathException ex) {
                ex.printStackTrace();
            }
        }
        this.profiler = copyFrom.profiler;
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public XQueryContext getRootContext() {
        return this;
    }

    @Override
    public XQueryContext copyContext() {
        XQueryContext ctx = new XQueryContext(this);
        this.copyFields(ctx);
        return ctx;
    }

    @Override
    public void updateContext(XQueryContext from) {
        this.watchdog = from.watchdog;
        this.lastVar = from.lastVar;
        this.variableStackSize = from.getCurrentStackSize();
        this.contextStack = from.contextStack;
        this.inScopeNamespaces = from.inScopeNamespaces;
        this.inScopePrefixes = from.inScopePrefixes;
        this.inheritedInScopeNamespaces = from.inheritedInScopeNamespaces;
        this.inheritedInScopePrefixes = from.inheritedInScopePrefixes;
        this.variableStackSize = from.variableStackSize;
        this.attributes = from.attributes;
        this.updateListener = from.updateListener;
        this.modules = from.modules;
        this.allModules = from.allModules;
        this.mappedModules = from.mappedModules;
        this.dynamicOptions = from.dynamicOptions;
        this.staticOptions = from.staticOptions;
        this.db = from.db;
    }

    protected void copyFields(XQueryContext ctx) {
        ctx.calendar = this.calendar;
        ctx.implicitTimeZone = this.implicitTimeZone;
        ctx.baseURI = this.baseURI;
        ctx.baseURISetInProlog = this.baseURISetInProlog;
        ctx.staticDocumentPaths = this.staticDocumentPaths;
        ctx.staticDocuments = this.staticDocuments;
        ctx.moduleLoadPath = this.moduleLoadPath;
        ctx.defaultFunctionNamespace = this.defaultFunctionNamespace;
        ctx.defaultElementNamespace = this.defaultElementNamespace;
        ctx.defaultCollation = this.defaultCollation;
        ctx.defaultCollator = this.defaultCollator;
        ctx.backwardsCompatible = this.backwardsCompatible;
        ctx.enableOptimizer = this.enableOptimizer;
        ctx.stripWhitespace = this.stripWhitespace;
        ctx.preserveNamespaces = this.preserveNamespaces;
        ctx.inheritNamespaces = this.inheritNamespaces;
        ctx.orderEmptyGreatest = this.orderEmptyGreatest;
        ctx.declaredFunctions = new TreeMap<FunctionId, UserDefinedFunction>((SortedMap<FunctionId, UserDefinedFunction>)this.declaredFunctions);
        ctx.globalVariables = new TreeMap<QName, Variable>(this.globalVariables);
        ctx.attributes = new HashMap<String, Object>(this.attributes);
        ctx.modules = new HashMap();
        for (Module module : this.modules.values()) {
            try {
                ctx.modules.put(module.getNamespaceURI(), module);
                String prefix = this.staticPrefixes.get(module.getNamespaceURI());
                ctx.declareNamespace(prefix, module.getNamespaceURI());
            }
            catch (XPathException xPathException) {}
        }
        ctx.allModules = new HashMap();
        for (Module module : this.allModules.values()) {
            if (module == null) continue;
            ctx.allModules.put(module.getNamespaceURI(), module);
        }
        ctx.watchdog = this.watchdog;
        ctx.profiler = this.getProfiler();
        ctx.lastVar = this.lastVar;
        ctx.variableStackSize = this.getCurrentStackSize();
        ctx.contextStack = this.contextStack;
        ctx.mappedModules = new HashMap<String, XmldbURI>(this.mappedModules);
        ctx.staticNamespaces = new HashMap<String, String>(this.staticNamespaces);
        ctx.staticPrefixes = new HashMap<String, String>(this.staticPrefixes);
        if (this.dynamicOptions != null) {
            ctx.dynamicOptions = new ArrayList<Option>(this.dynamicOptions);
        }
        if (this.staticOptions != null) {
            ctx.staticOptions = new ArrayList<Option>(this.staticOptions);
        }
        ctx.source = this.source;
    }

    @Override
    public void prepareForExecution() {
        Subject user = this.getUserFromHttpSession();
        if (user != null) {
            this.getBroker().pushSubject(user);
            this.pushedUserFromHttpSession = true;
        }
        this.setRealUser(this.getBroker().getCurrentSubject());
        this.setContextSequencePosition(0, null);
    }

    public void setContextItem(Sequence contextItem) {
        this.contextItem = contextItem;
    }

    public void setContextItemDeclaration(ContextItemDeclaration contextItemDeclaration) {
        this.contextItemDeclaration = contextItemDeclaration;
    }

    public ContextItemDeclaration getContextItemDeclartion() {
        return this.contextItemDeclaration;
    }

    public Sequence getContextItem() {
        return this.contextItem;
    }

    @Override
    public boolean isProfilingEnabled() {
        return this.profiler.isEnabled();
    }

    @Override
    public boolean isProfilingEnabled(int verbosity) {
        return this.profiler.isEnabled() && this.profiler.verbosity() >= verbosity;
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public void setRootExpression(Expression expr) {
        this.rootExpression = expr;
    }

    @Override
    public Expression getRootExpression() {
        return this.rootExpression;
    }

    protected int nextExpressionId() {
        return this.expressionCounter++;
    }

    @Override
    public int getExpressionCount() {
        return this.expressionCounter;
    }

    @Override
    public void declareNamespace(String prefix, String uri) throws XPathException {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if ("xml".equals(prefix) || "xmlns".equals(prefix)) {
            throw new XPathException(ErrorCodes.XQST0070, "Namespace predefined prefix '" + prefix + "' can not be bound");
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new XPathException(ErrorCodes.XQST0070, "Namespace URI '" + uri + "' must be bound to the 'xml' prefix");
        }
        String prevURI = this.staticNamespaces.get(prefix);
        if (prevURI == null) {
            if (uri.length() > 0) {
                this.staticNamespaces.put(prefix, uri);
                this.staticPrefixes.put(uri, prefix);
                return;
            }
            LOG.warn("Unbinding unbound prefix '" + prefix + "'");
        } else {
            if (uri.length() == 0) {
                this.staticPrefixes.remove(uri);
                this.staticNamespaces.remove(prefix);
                return;
            }
            if ("xs".equals(prefix) && "http://www.w3.org/2001/XMLSchema".equals(prevURI) || "xsi".equals(prefix) && "http://www.w3.org/2001/XMLSchema-instance".equals(prevURI) || "xdt".equals(prefix) && "http://www.w3.org/2003/05/xpath-datatypes".equals(prevURI) || "fn".equals(prefix) && "http://www.w3.org/2005/xpath-functions".equals(prevURI) || "math".equals(prefix) && "http://www.w3.org/2005/xpath-functions/math".equals(prevURI) || "local".equals(prefix) && "http://www.w3.org/2005/xquery-local-functions".equals(prevURI)) {
                this.staticPrefixes.remove(prevURI);
                this.staticNamespaces.remove(prefix);
                if (uri.length() > 0) {
                    this.staticNamespaces.put(prefix, uri);
                    this.staticPrefixes.put(uri, prefix);
                    return;
                }
                LOG.warn("Unbinding unbound prefix '" + prefix + "'");
            } else if (!uri.equals(prevURI)) {
                throw new XPathException(ErrorCodes.XQST0033, "Cannot bind prefix '" + prefix + "' to '" + uri + "' it is already bound to '" + prevURI + "'");
            }
        }
    }

    @Override
    public void declareNamespaces(Map<String, String> namespaceMap) {
        for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            this.staticNamespaces.put(prefix, uri);
            this.staticPrefixes.put(uri, prefix);
        }
    }

    @Override
    public void removeNamespace(String uri) {
        this.staticPrefixes.remove(uri);
        Iterator<String> i = this.staticNamespaces.values().iterator();
        while (i.hasNext()) {
            if (!i.next().equals(uri)) continue;
            i.remove();
            return;
        }
        this.inScopePrefixes.remove(uri);
        if (this.inScopeNamespaces != null) {
            i = this.inScopeNamespaces.values().iterator();
            while (i.hasNext()) {
                if (!i.next().equals(uri)) continue;
                i.remove();
                return;
            }
        }
        this.inheritedInScopePrefixes.remove(uri);
        if (this.inheritedInScopeNamespaces != null) {
            i = this.inheritedInScopeNamespaces.values().iterator();
            while (i.hasNext()) {
                if (!i.next().equals(uri)) continue;
                i.remove();
                return;
            }
        }
    }

    @Override
    public void declareInScopeNamespace(String prefix, String uri) {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("null argument passed to declareNamespace");
        }
        if (this.inheritedInScopePrefixes.get(this.getURIForPrefix(prefix)) != null) {
            this.inheritedInScopePrefixes.remove(uri);
        }
        if (this.inheritedInScopeNamespaces.get(prefix) != null) {
            this.inheritedInScopeNamespaces.remove(prefix);
        }
        this.inScopePrefixes.put(uri, prefix);
        this.inScopeNamespaces.put(prefix, uri);
    }

    @Override
    public String getInScopeNamespace(String prefix) {
        return this.inScopeNamespaces == null ? null : this.inScopeNamespaces.get(prefix);
    }

    @Override
    public String getInScopePrefix(String uri) {
        return this.inScopePrefixes == null ? null : this.inScopePrefixes.get(uri);
    }

    public Map<String, String> getInScopePrefixes() {
        return this.inScopePrefixes == null ? null : this.inScopePrefixes;
    }

    @Override
    public String getInheritedNamespace(String prefix) {
        return this.inheritedInScopeNamespaces == null ? null : this.inheritedInScopeNamespaces.get(prefix);
    }

    @Override
    public String getInheritedPrefix(String uri) {
        return this.inheritedInScopePrefixes == null ? null : this.inheritedInScopePrefixes.get(uri);
    }

    @Override
    public String getURIForPrefix(String prefix) {
        String uri;
        String string = uri = this.inScopeNamespaces == null ? null : this.inScopeNamespaces.get(prefix);
        if (uri != null) {
            return uri;
        }
        if (this.inheritNamespaces) {
            String string2 = uri = this.inheritedInScopeNamespaces == null ? null : this.inheritedInScopeNamespaces.get(prefix);
            if (uri != null) {
                return uri;
            }
        }
        return this.staticNamespaces.get(prefix);
    }

    @Override
    public String getPrefixForURI(String uri) {
        String prefix;
        String string = prefix = this.inScopePrefixes == null ? null : this.inScopePrefixes.get(uri);
        if (prefix != null) {
            return prefix;
        }
        if (this.inheritNamespaces) {
            String string2 = prefix = this.inheritedInScopePrefixes == null ? null : this.inheritedInScopePrefixes.get(uri);
            if (prefix != null) {
                return prefix;
            }
        }
        return this.staticPrefixes.get(uri);
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    @Override
    public void setDefaultFunctionNamespace(String uri) throws XPathException {
        if (this.defaultFunctionNamespace != null && !this.defaultFunctionNamespace.equals("http://www.w3.org/2005/xpath-functions") && !this.defaultFunctionNamespace.equals(uri)) {
            throw new XPathException("err:XQST0066: default function namespace is already set to: '" + this.defaultFunctionNamespace + "'");
        }
        this.defaultFunctionNamespace = uri;
    }

    @Override
    public String getDefaultElementNamespaceSchema() throws XPathException {
        return this.defaultElementNamespaceSchema.getStringValue();
    }

    @Override
    public void setDefaultElementNamespaceSchema(String uri) throws XPathException {
        if (!this.defaultElementNamespaceSchema.equals(AnyURIValue.EMPTY_URI)) {
            throw new XPathException("err:XQST0066: default function namespace schema is already set to: '" + this.defaultElementNamespaceSchema.getStringValue() + "'");
        }
        this.defaultElementNamespaceSchema = new AnyURIValue(uri);
    }

    @Override
    public String getDefaultElementNamespace() throws XPathException {
        return this.defaultElementNamespace.getStringValue();
    }

    @Override
    public void setDefaultElementNamespace(String uri, String schema) throws XPathException {
        if (!this.defaultElementNamespace.equals(AnyURIValue.EMPTY_URI)) {
            throw new XPathException("err:XQST0066: default element namespace is already set to: '" + this.defaultElementNamespace.getStringValue() + "'");
        }
        this.defaultElementNamespace = new AnyURIValue(uri);
        if (schema != null) {
            this.defaultElementNamespaceSchema = new AnyURIValue(schema);
        }
    }

    @Override
    public void setDefaultCollation(String uri) throws XPathException {
        URI uriTest;
        if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint") || uri.equals("codepoint")) {
            this.defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            this.defaultCollator = null;
        }
        try {
            uriTest = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new XPathException("err:XQST0038: Unknown collation : '" + uri + "'");
        }
        if (uri.startsWith("http://exist-db.org/collation") || uri.startsWith("?") || uriTest.isAbsolute()) {
            this.defaultCollator = Collations.getCollationFromURI(uri);
            this.defaultCollation = uri;
        } else {
            String absUri = this.getBaseURI().getStringValue() + uri;
            this.defaultCollator = Collations.getCollationFromURI(absUri);
            this.defaultCollation = absUri;
        }
    }

    @Override
    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    @Override
    public Collator getCollator(String uri) throws XPathException {
        if (uri == null) {
            return this.defaultCollator;
        }
        return Collations.getCollationFromURI(uri);
    }

    @Override
    public Collator getDefaultCollator() {
        return this.defaultCollator;
    }

    @Override
    public void setStaticallyKnownDocuments(XmldbURI[] docs) {
        this.staticDocumentPaths = docs;
    }

    @Override
    public void setStaticallyKnownDocuments(DocumentSet set) {
        this.staticDocuments = set;
    }

    @Override
    public void setCalendar(XMLGregorianCalendar newCalendar) {
        this.calendar = (XMLGregorianCalendar)newCalendar.clone();
    }

    @Override
    public void setTimeZone(TimeZone newTimeZone) {
        this.implicitTimeZone = newTimeZone;
    }

    @Override
    public XMLGregorianCalendar getCalendar() {
        if (this.calendar == null) {
            try {
                this.calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            }
            catch (DatatypeConfigurationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.calendar;
    }

    @Override
    public TimeZone getImplicitTimeZone() {
        if (this.implicitTimeZone == null) {
            this.implicitTimeZone = TimeZone.getDefault();
            if (this.implicitTimeZone.inDaylightTime(new Date())) {
                this.implicitTimeZone.setRawOffset(this.implicitTimeZone.getRawOffset() + this.implicitTimeZone.getDSTSavings());
            }
        }
        return this.implicitTimeZone;
    }

    @Override
    public DocumentSet getStaticallyKnownDocuments() throws XPathException {
        if (this.staticDocuments != null) {
            return this.staticDocuments;
        }
        if (this.protectedDocuments != null) {
            this.staticDocuments = this.protectedDocuments.toDocumentSet();
            return this.staticDocuments;
        }
        DefaultDocumentSet ndocs = new DefaultDocumentSet(1031);
        if (this.staticDocumentPaths == null) {
            try {
                this.getBroker().getAllXMLResources(ndocs);
            }
            catch (PermissionDeniedException pde) {
                LOG.warn("Permission denied to read resource all resources" + pde.getMessage(), (Throwable)pde);
                throw new XPathException("Permission denied to read resource all resources" + pde.getMessage(), (Throwable)pde);
            }
        } else {
            for (int i = 0; i < this.staticDocumentPaths.length; ++i) {
                try {
                    Collection collection = this.getBroker().getCollection(this.staticDocumentPaths[i]);
                    if (collection != null) {
                        collection.allDocs(this.getBroker(), ndocs, true);
                        continue;
                    }
                    DocumentImpl doc = this.getBroker().getXMLResource(this.staticDocumentPaths[i], Lock.LockMode.READ_LOCK);
                    if (doc == null) continue;
                    if (doc.getPermissions().validate(this.getBroker().getCurrentSubject(), 4)) {
                        ndocs.add(doc);
                    }
                    doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    continue;
                }
                catch (PermissionDeniedException e) {
                    LOG.warn("Permission denied to read resource " + this.staticDocumentPaths[i] + ". Skipping it.");
                }
            }
        }
        this.staticDocuments = ndocs;
        return this.staticDocuments;
    }

    public DocumentSet getStaticDocs() {
        return this.staticDocuments;
    }

    @Override
    public ExtendedXMLStreamReader getXMLStreamReader(NodeValue nv) throws XMLStreamException, IOException {
        ExtendedXMLStreamReader reader;
        if (nv.getImplementationType() == 0) {
            NodeImpl node = (NodeImpl)nv;
            org.exist.dom.memtree.DocumentImpl ownerDoc = node.getNodeType() == 9 ? (org.exist.dom.memtree.DocumentImpl)node : node.getOwnerDocument();
            reader = new InMemoryXMLStreamReader(ownerDoc, ownerDoc);
        } else {
            NodeProxy proxy = (NodeProxy)nv;
            reader = this.getBroker().newXMLStreamReader(new NodeProxy(proxy.getOwnerDocument(), NodeId.DOCUMENT_NODE, proxy.getOwnerDocument().getFirstChildAddress()), false);
        }
        return reader;
    }

    @Override
    public void setProtectedDocs(LockedDocumentMap map) {
        this.protectedDocuments = map;
    }

    @Override
    public LockedDocumentMap getProtectedDocs() {
        return this.protectedDocuments;
    }

    @Override
    public boolean inProtectedMode() {
        return this.protectedDocuments != null;
    }

    @Override
    public boolean lockDocumentsOnLoad() {
        return false;
    }

    @Override
    public void addLockedDocument(DocumentImpl doc) {
    }

    @Override
    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public void addModifiedDoc(DocumentImpl document) {
        if (this.modifiedDocuments == null) {
            this.modifiedDocuments = new DefaultDocumentSet();
        }
        this.modifiedDocuments.add(document);
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    @Override
    public void reset(boolean keepGlobals) {
        this.setRealUser(null);
        if (this.pushedUserFromHttpSession) {
            try {
                this.getBroker().popSubject();
            }
            finally {
                this.pushedUserFromHttpSession = false;
            }
        }
        if (this.modifiedDocuments != null) {
            try {
                Modification.checkFragmentation(this, this.modifiedDocuments);
            }
            catch (EXistException e) {
                LOG.warn("Error while checking modified documents: " + e.getMessage(), (Throwable)e);
            }
            this.modifiedDocuments = null;
        }
        this.calendar = null;
        this.implicitTimeZone = null;
        this.resetDocumentBuilder();
        this.contextSequence = null;
        this.contextItem = Sequence.EMPTY_SEQUENCE;
        if (!keepGlobals) {
            this.staticDocumentPaths = null;
            this.staticDocuments = null;
        }
        if (!this.isShared) {
            this.lastVar = null;
        }
        this.fragmentStack = new Stack();
        this.callStack.clear();
        this.protectedDocuments = null;
        if (!keepGlobals) {
            this.globalVariables.clear();
        }
        if (this.dynamicOptions != null) {
            this.dynamicOptions.clear();
        }
        if (!this.isShared) {
            this.watchdog.reset();
        }
        for (Module module : this.allModules.values()) {
            module.reset(this, keepGlobals);
        }
        if (!keepGlobals) {
            this.mappedModules.clear();
        }
        this.savedState.restore();
        this.XQueryContextVars.clear();
        this.attributes.clear();
        this.clearUpdateListeners();
        this.profiler.reset();
        this.analyzed = false;
    }

    @Override
    public boolean stripWhitespace() {
        return this.stripWhitespace;
    }

    @Override
    public void setStripWhitespace(boolean strip) {
        this.stripWhitespace = strip;
    }

    @Override
    public boolean preserveNamespaces() {
        return this.preserveNamespaces;
    }

    @Override
    public void setPreserveNamespaces(boolean preserve) {
        this.preserveNamespaces = preserve;
    }

    @Override
    public boolean inheritNamespaces() {
        return this.inheritNamespaces;
    }

    @Override
    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    @Override
    public boolean orderEmptyGreatest() {
        return this.orderEmptyGreatest;
    }

    @Override
    public void setOrderEmptyGreatest(boolean order) {
        this.orderEmptyGreatest = order;
    }

    @Override
    public Iterator<Module> getModules() {
        return this.modules.values().iterator();
    }

    @Override
    public Iterator<Module> getRootModules() {
        return this.getAllModules();
    }

    @Override
    public Iterator<Module> getAllModules() {
        return this.allModules.values().iterator();
    }

    @Override
    public Module getModule(String namespaceURI) {
        return this.modules.get(namespaceURI);
    }

    @Override
    public Module getRootModule(String namespaceURI) {
        return this.allModules.get(namespaceURI);
    }

    @Override
    public void setModule(String namespaceURI, Module module) {
        if (module == null) {
            this.modules.remove(namespaceURI);
        } else {
            this.modules.put(namespaceURI, module);
        }
        this.setRootModule(namespaceURI, module);
    }

    protected void setRootModule(String namespaceURI, Module module) {
        if (module == null) {
            this.allModules.remove(namespaceURI);
            return;
        }
        if (this.allModules.get(namespaceURI) != module) {
            this.setModulesChanged();
        }
        this.allModules.put(namespaceURI, module);
    }

    void setModulesChanged() {
        this.modulesChanged = true;
    }

    @Override
    public boolean checkModulesValid() {
        for (Module module : this.allModules.values()) {
            if (module.isInternalModule() || ((ExternalModule)module).moduleIsValid(this.getBroker())) continue;
            LOG.debug("Module with URI " + module.getNamespaceURI() + " has changed and needs to be reloaded");
            return false;
        }
        return true;
    }

    @Override
    public void analyzeAndOptimizeIfModulesChanged(Expression expr) throws XPathException {
        if (this.analyzed) {
            return;
        }
        this.analyzed = true;
        for (Module module : expr.getContext().modules.values()) {
            if (module.isInternalModule()) continue;
            Expression root = ((ExternalModule)module).getRootExpression();
            ((ExternalModule)module).getContext().analyzeAndOptimizeIfModulesChanged(root);
        }
        expr.analyze(new AnalyzeContextInfo());
        if (this.optimizationsEnabled()) {
            Optimizer optimizer = new Optimizer(this);
            expr.accept(optimizer);
            if (optimizer.hasOptimized()) {
                this.reset(true);
                expr.resetState(true);
                expr.analyze(new AnalyzeContextInfo());
            }
        }
        this.modulesChanged = false;
    }

    @Override
    public Module loadBuiltInModule(String namespaceURI, String moduleClass) {
        Module module = null;
        if (namespaceURI != null) {
            module = this.getModule(namespaceURI);
        }
        if (module != null) {
            return module;
        }
        return this.initBuiltInModule(namespaceURI, moduleClass);
    }

    protected Module initBuiltInModule(String namespaceURI, String moduleClass) {
        Module module = null;
        try {
            ClassLoader existClassLoader = this.getBroker().getBrokerPool().getClassLoader();
            Class<Module> mClass = Class.forName(moduleClass, false, existClassLoader);
            if (!Module.class.isAssignableFrom(mClass)) {
                LOG.info("failed to load module. " + moduleClass + " is not an instance of org.exist.xquery.Module.");
                return null;
            }
            module = this.instantiateModule(namespaceURI, mClass, (Map)this.getBroker().getConfiguration().getProperty(PROPERTY_MODULE_PARAMETERS));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("module class " + moduleClass + " not found. Skipping...");
        }
        return module;
    }

    protected Module instantiateModule(String namespaceURI, Class<Module> mClass, Map<String, Map<String, List<? extends Object>>> moduleParameters) {
        Module module = null;
        try {
            Constructor<Module> cnstr = mClass.getConstructor(Map.class);
            module = cnstr.newInstance(moduleParameters.get(namespaceURI));
            if (namespaceURI != null && !module.getNamespaceURI().equals(namespaceURI)) {
                LOG.warn("the module declares a different namespace URI. Expected: " + namespaceURI + " found: " + module.getNamespaceURI());
                return null;
            }
            if (this.getPrefixForURI(module.getNamespaceURI()) == null && module.getDefaultPrefix().length() > 0) {
                this.declareNamespace(module.getDefaultPrefix(), module.getNamespaceURI());
            }
            this.modules.put(module.getNamespaceURI(), module);
            this.allModules.put(module.getNamespaceURI(), module);
        }
        catch (InstantiationException ie) {
            LOG.warn("error while instantiating module class " + mClass.getName(), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            LOG.warn("error while instantiating module class " + mClass.getName(), (Throwable)iae);
        }
        catch (XPathException xpe) {
            LOG.warn("error while instantiating module class " + mClass.getName(), (Throwable)xpe);
        }
        catch (NoSuchMethodException nsme) {
            LOG.warn("error while instantiating module class " + mClass.getName(), (Throwable)nsme);
        }
        catch (InvocationTargetException ite) {
            LOG.warn("error while instantiating module class " + mClass.getName(), (Throwable)ite);
        }
        return module;
    }

    @Override
    public void declareFunction(UserDefinedFunction function) throws XPathException {
        QName name = function.getSignature().getName();
        if ("http://www.w3.org/XML/1998/namespace".equals(name.getNamespaceURI())) {
            throw new XPathException((Expression)function, ErrorCodes.XQST0045, "Function '" + name + "' is in the forbidden namespace '" + "http://www.w3.org/XML/1998/namespace" + "'");
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(name.getNamespaceURI())) {
            throw new XPathException((Expression)function, ErrorCodes.XQST0045, "Function '" + name + "' is in the forbidden namespace '" + "http://www.w3.org/2001/XMLSchema" + "'");
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(name.getNamespaceURI())) {
            throw new XPathException((Expression)function, ErrorCodes.XQST0045, "Function '" + name + "' is in the forbidden namespace '" + "http://www.w3.org/2001/XMLSchema-instance" + "'");
        }
        if ("http://www.w3.org/2005/xpath-functions".equals(name.getNamespaceURI())) {
            throw new XPathException((Expression)function, ErrorCodes.XQST0045, "Function '" + name + "' is in the forbidden namespace '" + "http://www.w3.org/2005/xpath-functions" + "'");
        }
        if ("".equals(name.getNamespaceURI())) {
            throw new XPathException((Expression)function, ErrorCodes.XQST0060, "Every declared function name must have a non-null namespace URI, but function '" + name + "' does not meet this requirement.");
        }
        this.declaredFunctions.put(function.getSignature().getFunctionId(), function);
    }

    @Override
    public UserDefinedFunction resolveFunction(QName name, int argCount) throws XPathException {
        FunctionId id = new FunctionId(name, argCount);
        UserDefinedFunction func = this.declaredFunctions.get(id);
        return func;
    }

    @Override
    public Iterator<FunctionSignature> getSignaturesForFunction(QName name) {
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>(2);
        for (UserDefinedFunction func : this.declaredFunctions.values()) {
            if (!func.getName().equals(name)) continue;
            signatures.add(func.getSignature());
        }
        return signatures.iterator();
    }

    @Override
    public Iterator<UserDefinedFunction> localFunctions() {
        return this.declaredFunctions.values().iterator();
    }

    @Override
    public LocalVariable declareVariableBinding(LocalVariable var) throws XPathException {
        if (this.lastVar == null) {
            this.lastVar = var;
        } else {
            this.lastVar.addAfter(var);
            this.lastVar = var;
        }
        var.setStackPosition(this.getCurrentStackSize());
        return var;
    }

    @Override
    public Variable declareGlobalVariable(Variable var) throws XPathException {
        this.globalVariables.put(var.getQName(), var);
        var.setStackPosition(this.getCurrentStackSize());
        return var;
    }

    @Override
    public void undeclareGlobalVariable(QName name) {
        this.globalVariables.remove(name);
    }

    @Override
    public Variable declareVariable(String qname, Object value) throws XPathException {
        try {
            return this.declareVariable(QName.parse(this, qname, null), value);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix: " + qname);
        }
    }

    @Override
    public Variable declareVariable(QName qn, Object value) throws XPathException {
        Module module = this.getModule(qn.getNamespaceURI());
        if (module != null) {
            Variable var = module.declareVariable(qn, value);
            return var;
        }
        Sequence val = XPathUtil.javaObjectToXPath(value, this);
        Variable var = this.globalVariables.get(qn);
        if (var == null) {
            var = new VariableImpl(qn);
            this.globalVariables.put(qn, var);
        }
        if (var.getSequenceType() != null) {
            int actualCardinality = val.isEmpty() ? 1 : (val.hasMany() ? 4 : 2);
            if (!Cardinality.checkCardinality(var.getSequenceType().getCardinality(), actualCardinality)) {
                throw new XPathException("XPTY0004: Invalid cardinality for variable $" + var.getQName() + ". Expected " + Cardinality.getDescription(var.getSequenceType().getCardinality()) + ", got " + Cardinality.getDescription(actualCardinality));
            }
            if (!Type.subTypeOf(var.getSequenceType().getPrimaryType(), -1) ? !val.isEmpty() && !Type.subTypeOf(val.getItemType(), var.getSequenceType().getPrimaryType()) : !val.isEmpty() && !Type.subTypeOf(val.getItemType(), var.getSequenceType().getPrimaryType())) {
                throw new XPathException("XPTY0004: Invalid type for variable $" + var.getQName() + ". Expected " + Type.getTypeName(var.getSequenceType().getPrimaryType()) + ", got " + Type.getTypeName(val.getItemType()));
            }
        }
        var.setValue(val);
        return var;
    }

    @Override
    public Variable resolveVariable(String name) throws XPathException {
        try {
            QName qn = QName.parse(this, name, null);
            return this.resolveVariable(qn);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + name);
        }
    }

    @Override
    public Variable resolveVariable(QName qname) throws XPathException {
        Module module;
        Variable var = this.resolveLocalVariable(qname);
        if (var == null && (module = this.getModule(qname.getNamespaceURI())) != null) {
            var = module.resolveVariable(qname);
        }
        if (var == null) {
            var = this.globalVariables.get(qname);
        }
        return var;
    }

    protected Variable resolveGlobalVariable(QName qname) {
        return this.globalVariables.get(qname);
    }

    protected Variable resolveLocalVariable(QName qname) throws XPathException {
        LocalVariable end = this.contextStack.isEmpty() ? null : this.contextStack.peek();
        LocalVariable var = this.lastVar;
        while (var != null) {
            if (var == end) {
                return null;
            }
            if (qname.equals(var.getQName())) {
                return var;
            }
            var = var.before;
        }
        return null;
    }

    @Override
    public boolean isVarDeclared(QName qname) {
        Module module = this.getModule(qname.getNamespaceURI());
        if (module != null && module.isVarDeclared(qname)) {
            return true;
        }
        return this.globalVariables.get(qname) != null;
    }

    @Override
    public Map<QName, Variable> getVariables() {
        HashMap<QName, Variable> variables = new HashMap<QName, Variable>();
        variables.putAll(this.globalVariables);
        LocalVariable end = this.contextStack.isEmpty() ? null : this.contextStack.peek();
        LocalVariable var = this.lastVar;
        while (var != null && var != end) {
            variables.put(var.getQName(), var);
            var = var.before;
        }
        return variables;
    }

    @Override
    public Map<QName, Variable> getLocalVariables() {
        HashMap<QName, Variable> variables = new HashMap<QName, Variable>();
        LocalVariable end = this.contextStack.isEmpty() ? null : this.contextStack.peek();
        LocalVariable var = this.lastVar;
        while (var != null && var != end) {
            variables.put(var.getQName(), var);
            var = var.before;
        }
        return variables;
    }

    public List<ClosureVariable> getLocalStack() {
        ArrayList<ClosureVariable> closure = new ArrayList<ClosureVariable>(6);
        LocalVariable end = this.contextStack.isEmpty() ? null : this.contextStack.peek();
        LocalVariable var = this.lastVar;
        while (var != null && var != end) {
            closure.add(new ClosureVariable(var));
            var = var.before;
        }
        return closure;
    }

    @Override
    public Map<QName, Variable> getGlobalVariables() {
        HashMap<QName, Variable> variables = new HashMap<QName, Variable>();
        variables.putAll(this.globalVariables);
        return variables;
    }

    public void restoreStack(List<ClosureVariable> stack) throws XPathException {
        for (int i = stack.size() - 1; i > -1; --i) {
            this.declareVariableBinding(new ClosureVariable(stack.get(i)));
        }
    }

    @Override
    public void setBackwardsCompatibility(boolean backwardsCompatible) {
        this.backwardsCompatible = backwardsCompatible;
    }

    @Override
    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    @Override
    public boolean isRaiseErrorOnFailedRetrieval() {
        return this.raiseErrorOnFailedRetrieval;
    }

    public Database getDatabase() {
        return this.db;
    }

    @Override
    public DBBroker getBroker() {
        return this.db.getActiveBroker();
    }

    public Subject getUser() {
        return this.getSubject();
    }

    @Override
    public Subject getSubject() {
        return this.getBroker().getCurrentSubject();
    }

    public Subject getUserFromHttpSession() {
        JavaObjectValue reqValue;
        RequestModule myModule = (RequestModule)this.getModule("http://exist-db.org/xquery/request");
        if (myModule == null) {
            return null;
        }
        Variable var = null;
        try {
            var = myModule.resolveVariable(RequestModule.REQUEST_VAR);
        }
        catch (XPathException xpe) {
            return null;
        }
        if (var != null && var.getValue() != null && var.getValue().getItemType() == 100 && (reqValue = (JavaObjectValue)var.getValue().itemAt(0)).getObject() instanceof RequestWrapper) {
            RequestWrapper req = (RequestWrapper)reqValue.getObject();
            Object user = req.getAttribute(HTTP_REQ_ATTR_USER);
            Object passAttr = req.getAttribute(HTTP_REQ_ATTR_PASS);
            if (user != null) {
                String password = passAttr == null ? null : passAttr.toString();
                try {
                    return this.getBroker().getBrokerPool().getSecurityManager().authenticate(user.toString(), password);
                }
                catch (AuthenticationException e) {
                    LOG.error("User can not be authenticated: " + user.toString());
                }
            } else if (req.getSession() != null) {
                return (Subject)req.getSession().getAttribute(HTTP_SESSIONVAR_XMLDB_USER);
            }
        }
        return null;
    }

    @Override
    public MemTreeBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            this.documentBuilder = new MemTreeBuilder(this);
            this.documentBuilder.startDocument();
        }
        return this.documentBuilder;
    }

    @Override
    public MemTreeBuilder getDocumentBuilder(boolean explicitCreation) {
        if (this.documentBuilder == null) {
            this.documentBuilder = new MemTreeBuilder(this);
            this.documentBuilder.startDocument(explicitCreation);
        }
        return this.documentBuilder;
    }

    private void resetDocumentBuilder() {
        this.setDocumentBuilder(null);
    }

    private void setDocumentBuilder(MemTreeBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    @Override
    public NamePool getSharedNamePool() {
        if (this.sharedNamePool == null) {
            this.sharedNamePool = new NamePool();
        }
        return this.sharedNamePool;
    }

    @Override
    public XQueryContext getContext() {
        return null;
    }

    @Override
    public void prologEnter(Expression expr) {
        if (this.debuggeeJoint != null) {
            this.debuggeeJoint.prologEnter(expr);
        }
    }

    @Override
    public void expressionStart(Expression expr) throws TerminatedException {
        if (this.debuggeeJoint != null) {
            this.debuggeeJoint.expressionStart(expr);
        }
    }

    @Override
    public void expressionEnd(Expression expr) {
        if (this.debuggeeJoint != null) {
            this.debuggeeJoint.expressionEnd(expr);
        }
    }

    @Override
    public void stackEnter(Expression expr) throws TerminatedException {
        if (this.debuggeeJoint != null) {
            this.debuggeeJoint.stackEnter(expr);
        }
    }

    @Override
    public void stackLeave(Expression expr) {
        if (this.debuggeeJoint != null) {
            this.debuggeeJoint.stackLeave(expr);
        }
    }

    @Override
    public void proceed() throws TerminatedException {
        this.getWatchDog().proceed(null);
    }

    @Override
    public void proceed(Expression expr) throws TerminatedException {
        this.getWatchDog().proceed(expr);
    }

    @Override
    public void proceed(Expression expr, MemTreeBuilder builder) throws TerminatedException {
        this.getWatchDog().proceed(expr, builder);
    }

    @Override
    public void setWatchDog(XQueryWatchDog watchdog) {
        this.watchdog = watchdog;
    }

    @Override
    public XQueryWatchDog getWatchDog() {
        return this.watchdog;
    }

    @Override
    public void pushDocumentContext() {
        this.fragmentStack.push(this.getDocumentBuilder());
        this.resetDocumentBuilder();
    }

    @Override
    public void popDocumentContext() {
        if (!this.fragmentStack.isEmpty()) {
            this.setDocumentBuilder(this.fragmentStack.pop());
        }
    }

    @Override
    public void setBaseURI(AnyURIValue uri) {
        this.setBaseURI(uri, false);
    }

    @Override
    public void setBaseURI(AnyURIValue uri, boolean setInProlog) {
        if (this.baseURISetInProlog) {
            return;
        }
        if (uri == null) {
            this.baseURI = AnyURIValue.EMPTY_URI;
        }
        this.baseURI = uri;
        this.baseURISetInProlog = setInProlog;
    }

    @Override
    public void setModuleLoadPath(String path) {
        this.moduleLoadPath = path;
    }

    @Override
    public String getModuleLoadPath() {
        return this.moduleLoadPath;
    }

    @Override
    public boolean isBaseURIDeclared() {
        return this.baseURI != null && !this.baseURI.equals(AnyURIValue.EMPTY_URI);
    }

    @Override
    public AnyURIValue getBaseURI() throws XPathException {
        if (this.baseURI == null || this.baseURI.equals(AnyURIValue.EMPTY_URI)) {
            // empty if block
        }
        return this.baseURI;
    }

    @Override
    public void setContextSequencePosition(int pos, Sequence sequence) {
        this.contextPosition = pos;
        this.contextSequence = sequence;
    }

    @Override
    public int getContextPosition() {
        return this.contextPosition;
    }

    @Override
    public Sequence getContextSequence() {
        return this.contextSequence;
    }

    @Override
    public void pushInScopeNamespaces() {
        this.pushInScopeNamespaces(true);
    }

    @Override
    public void pushInScopeNamespaces(boolean inherit) {
        HashMap m = (HashMap)this.inScopeNamespaces.clone();
        HashMap p = (HashMap)this.inScopePrefixes.clone();
        this.namespaceStack.push(this.inheritedInScopeNamespaces);
        this.namespaceStack.push(this.inheritedInScopePrefixes);
        this.namespaceStack.push(this.inScopeNamespaces);
        this.namespaceStack.push(this.inScopePrefixes);
        if (inherit) {
            this.inheritedInScopeNamespaces = (HashMap)this.inheritedInScopeNamespaces.clone();
            this.inheritedInScopeNamespaces.putAll(m);
            this.inheritedInScopePrefixes = (HashMap)this.inheritedInScopePrefixes.clone();
            this.inheritedInScopePrefixes.putAll(p);
        } else {
            this.inheritedInScopeNamespaces = new HashMap();
            this.inheritedInScopePrefixes = new HashMap();
        }
        this.inScopeNamespaces = new HashMap();
        this.inScopePrefixes = new HashMap();
    }

    @Override
    public void popInScopeNamespaces() {
        this.inScopePrefixes = this.namespaceStack.pop();
        this.inScopeNamespaces = this.namespaceStack.pop();
        this.inheritedInScopePrefixes = this.namespaceStack.pop();
        this.inheritedInScopeNamespaces = this.namespaceStack.pop();
    }

    @Override
    public void pushNamespaceContext() {
        HashMap m = (HashMap)this.staticNamespaces.clone();
        HashMap p = (HashMap)this.staticPrefixes.clone();
        this.namespaceStack.push(this.staticNamespaces);
        this.namespaceStack.push(this.staticPrefixes);
        this.staticNamespaces = m;
        this.staticPrefixes = p;
    }

    @Override
    public void popNamespaceContext() {
        this.staticPrefixes = this.namespaceStack.pop();
        this.staticNamespaces = this.namespaceStack.pop();
    }

    @Override
    public LocalVariable markLocalVariables(boolean newContext) {
        if (newContext) {
            if (this.lastVar == null) {
                this.lastVar = new LocalVariable(QName.EMPTY_QNAME);
            }
            this.contextStack.push(this.lastVar);
        }
        ++this.variableStackSize;
        return this.lastVar;
    }

    @Override
    public void popLocalVariables(LocalVariable var) {
        this.popLocalVariables(var, null);
    }

    public void popLocalVariables(LocalVariable var, Sequence resultSeq) {
        if (var != null) {
            LocalVariable outOfScope = var.after;
            while (outOfScope != null) {
                if (outOfScope != var && !outOfScope.isClosureVar()) {
                    outOfScope.destroy(this, resultSeq);
                }
                outOfScope = outOfScope.after;
            }
            var.after = null;
            if (!this.contextStack.isEmpty() && var == this.contextStack.peek()) {
                this.contextStack.pop();
            }
        }
        this.lastVar = var;
        --this.variableStackSize;
    }

    @Override
    public int getCurrentStackSize() {
        return this.variableStackSize;
    }

    @Override
    public void functionStart(FunctionSignature signature) {
        this.callStack.push(signature);
    }

    @Override
    public void functionEnd() {
        if (this.callStack.isEmpty()) {
            LOG.warn("Function call stack is empty, but XQueryContext.functionEnd() was called. This could indicate a concurrency issue (shared XQueryContext?)");
        } else {
            this.callStack.pop();
        }
    }

    @Override
    public boolean tailRecursiveCall(FunctionSignature signature) {
        return this.callStack.contains(signature);
    }

    @Override
    public void mapModule(String namespace, XmldbURI uri) {
        this.mappedModules.put(namespace, uri);
    }

    @Override
    public Module importModule(String namespaceURI, String prefix, String location) throws XPathException {
        Module module;
        block30: {
            if (prefix != null && ("xml".equals(prefix) || "xmlns".equals(prefix))) {
                throw new XPathException(ErrorCodes.XQST0070, "The prefix declared for a module import must not be 'xml' or 'xmlns'.");
            }
            if (namespaceURI != null && namespaceURI.isEmpty()) {
                throw new XPathException(ErrorCodes.XQST0088, "The first URILiteral in a module import must be of nonzero length.");
            }
            module = null;
            if (namespaceURI != null) {
                module = this.getRootModule(namespaceURI);
            }
            if (module != null) {
                LOG.debug("Module " + namespaceURI + " already present.");
                this.setModule(namespaceURI, module);
            } else {
                if (location == null && namespaceURI != null) {
                    module = this.resolveInEXPathRepository(namespaceURI, prefix);
                }
                if (module == null) {
                    if (location == null && namespaceURI != null && (location = this.getModuleLocation(namespaceURI)) == null) {
                        location = namespaceURI;
                    }
                    if (this.mappedModules.containsKey(location)) {
                        location = this.mappedModules.get(location).toString();
                    }
                    if (location.startsWith(JAVA_URI_START)) {
                        location = location.substring(JAVA_URI_START.length());
                        module = this.loadBuiltInModule(namespaceURI, location);
                    } else {
                        Source moduleSource;
                        if (location.startsWith("xmldb:") || location.indexOf(58) == -1 && this.moduleLoadPath.startsWith("xmldb:")) {
                            try {
                                XmldbURI locationUri = XmldbURI.xmldbUriFor(location);
                                if (this.moduleLoadPath.startsWith("xmldb:")) {
                                    XmldbURI moduleLoadPathUri = XmldbURI.xmldbUriFor(this.moduleLoadPath);
                                    locationUri = moduleLoadPathUri.resolveCollectionPath(locationUri);
                                }
                                DocumentImpl sourceDoc = null;
                                try {
                                    sourceDoc = this.getBroker().getXMLResource(locationUri.toCollectionPathURI(), Lock.LockMode.READ_LOCK);
                                    if (sourceDoc == null) {
                                        throw this.moduleLoadException("Module location hint URI '" + location + "' does not refer to anything.", location);
                                    }
                                    if (sourceDoc.getResourceType() != 1 || !"application/xquery".equals(sourceDoc.getMetadata().getMimeType())) {
                                        throw this.moduleLoadException("Module location hint URI '" + location + "' does not refer to an XQuery.", location);
                                    }
                                    DBSource moduleSource2 = new DBSource(this.getBroker(), (BinaryDocument)sourceDoc, true);
                                    module = this.compileOrBorrowModule(prefix, namespaceURI, location, moduleSource2);
                                    break block30;
                                }
                                catch (PermissionDeniedException e) {
                                    throw this.moduleLoadException("Permission denied to read module source from location hint URI '" + location + ".", location, e);
                                }
                                finally {
                                    if (sourceDoc != null) {
                                        sourceDoc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                                    }
                                }
                            }
                            catch (URISyntaxException e) {
                                throw this.moduleLoadException("Invalid module location hint URI '" + location + "'.", location, e);
                            }
                        }
                        try {
                            moduleSource = SourceFactory.getSource(this.getBroker(), this.moduleLoadPath, location, true);
                        }
                        catch (MalformedURLException e) {
                            throw this.moduleLoadException("Invalid module location hint URI '" + location + "'.", location, e);
                        }
                        catch (IOException e) {
                            throw this.moduleLoadException("Source for module '" + namespaceURI + "' not found module location hint URI '" + location + "'.", location, e);
                        }
                        catch (PermissionDeniedException e) {
                            throw this.moduleLoadException("Permission denied to read module source from location hint URI '" + location + ".", location, e);
                        }
                        module = this.compileOrBorrowModule(prefix, namespaceURI, location, moduleSource);
                    }
                }
            }
        }
        if (module != null) {
            if (namespaceURI == null) {
                namespaceURI = module.getNamespaceURI();
            }
            if (prefix == null) {
                prefix = module.getDefaultPrefix();
            }
            this.declareNamespace(prefix, namespaceURI);
        }
        return module;
    }

    protected XPathException moduleLoadException(String message, String moduleLocation) throws XPathException {
        return new XPathException(ErrorCodes.XQST0059, message, new ValueSequence(new StringValue(moduleLocation)));
    }

    protected XPathException moduleLoadException(String message, String moduleLocation, Exception e) throws XPathException {
        return new XPathException(ErrorCodes.XQST0059, message, new ValueSequence(new StringValue(moduleLocation)), (Throwable)e);
    }

    @Override
    public String getModuleLocation(String namespaceURI) {
        Map moduleMap = (Map)this.getBroker().getConfiguration().getProperty(PROPERTY_STATIC_MODULE_MAP);
        return (String)moduleMap.get(namespaceURI);
    }

    @Override
    public Iterator<String> getMappedModuleURIs() {
        Map moduleMap = (Map)this.getBroker().getConfiguration().getProperty(PROPERTY_STATIC_MODULE_MAP);
        return moduleMap.keySet().iterator();
    }

    private ExternalModule compileOrBorrowModule(String prefix, String namespaceURI, String location, Source source) throws XPathException {
        ExternalModule module = this.compileModule(prefix, namespaceURI, location, source);
        if (module != null) {
            this.setModule(module.getNamespaceURI(), module);
            this.declareModuleVars(module);
        }
        return module;
    }

    public ExternalModule compileModule(String prefix, String namespaceURI, String location, Source source) throws XPathException {
        Reader reader;
        LOG.debug("Loading module from " + location);
        try {
            reader = source.getReader();
            if (reader == null) {
                throw this.moduleLoadException("failed to load module: '" + namespaceURI + "' from: '" + source + "', location: '" + location + "'. Source not found. ", location);
            }
            if (namespaceURI == null) {
                QName qname = source.isModule();
                if (qname == null) {
                    return null;
                }
                namespaceURI = qname.getNamespaceURI();
            }
        }
        catch (IOException e) {
            throw this.moduleLoadException("IO exception while loading module '" + namespaceURI + "' from '" + source + "'", location, e);
        }
        ExternalModuleImpl modExternal = new ExternalModuleImpl(namespaceURI, prefix);
        this.setModule(namespaceURI, modExternal);
        ModuleContext modContext = new ModuleContext(this, prefix, namespaceURI, location);
        modExternal.setContext(modContext);
        XQueryLexer lexer = new XQueryLexer(modContext, reader);
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser astParser = new XQueryTreeParser(modContext, modExternal);
        try {
            parser.xpath();
            if (parser.foundErrors()) {
                LOG.debug(parser.getErrorMessage());
                throw new XPathException("error found while loading module from " + location + ": " + parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            PathExpr path = new PathExpr(modContext);
            astParser.xpath(ast, path);
            if (astParser.foundErrors()) {
                throw new XPathException("error found while loading module from " + location + ": " + astParser.getErrorMessage(), (Throwable)astParser.getLastException());
            }
            modExternal.setRootExpression(path);
            if (namespaceURI != null && !modExternal.getNamespaceURI().equals(namespaceURI)) {
                throw new XPathException("namespace URI declared by module (" + modExternal.getNamespaceURI() + ") does not match namespace URI in import statement, which was: " + namespaceURI);
            }
            modExternal.setSource(source);
            modContext.setSource(source);
            modExternal.setIsReady(true);
            ExternalModuleImpl externalModuleImpl = modExternal;
            return externalModuleImpl;
        }
        catch (RecognitionException e) {
            throw new XPathException(e.getLine(), e.getColumn(), "error found while loading module from " + location + ": " + e.getMessage());
        }
        catch (TokenStreamException e) {
            throw new XPathException("error found while loading module from " + location + ": " + e.getMessage(), (Throwable)e);
        }
        catch (XPathException e) {
            e.prependMessage("Error while loading module " + location + ": ");
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XPathException("Internal error while loading module: " + location, (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Error while closing module source: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void declareModuleVars(Module module) {
        String moduleNS = module.getNamespaceURI();
        Iterator<Variable> i = this.globalVariables.values().iterator();
        while (i.hasNext()) {
            Variable var = i.next();
            if (!moduleNS.equals(var.getQName().getNamespaceURI())) continue;
            module.declareVariable(var);
            i.remove();
        }
    }

    @Override
    public void addForwardReference(FunctionCall call) {
        this.forwardReferences.add(call);
    }

    @Override
    public void resolveForwardReferences() throws XPathException {
        while (!this.forwardReferences.isEmpty()) {
            FunctionCall call = this.forwardReferences.pop();
            UserDefinedFunction func = call.getContext().resolveFunction(call.getQName(), call.getArgumentCount());
            if (func == null) {
                throw new XPathException((Expression)call, ErrorCodes.XPST0017, "Call to undeclared function: " + call.getQName().getStringValue());
            }
            call.resolveForwardReference(func);
        }
    }

    public Map<String, String> getEnvironmentVariables() {
        if (this.envs == null) {
            this.envs = System.getenv();
        }
        return this.envs;
    }

    public Subject getEffectiveUser() {
        return this.getBroker().getCurrentSubject();
    }

    public Subject getRealUser() {
        return this.realUser;
    }

    protected void setRealUser(Subject realUser) {
        this.realUser = realUser;
    }

    public void saveState() {
        this.savedState.save();
    }

    @Override
    public boolean optimizationsEnabled() {
        return this.enableOptimizer;
    }

    @Override
    public void addOption(String qnameString, String contents) throws XPathException {
        if (this.staticOptions == null) {
            this.staticOptions = new ArrayList<Option>();
        }
        this.addOption(this.staticOptions, qnameString, contents);
    }

    @Override
    public void addDynamicOption(String qnameString, String contents) throws XPathException {
        if (this.dynamicOptions == null) {
            this.dynamicOptions = new ArrayList<Option>();
        }
        this.addOption(this.dynamicOptions, qnameString, contents);
    }

    private void addOption(List<Option> options, String qnameString, String contents) throws XPathException {
        QName qn;
        try {
            qn = QName.parse(this, qnameString, this.defaultFunctionNamespace);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + qnameString);
        }
        Option option = new Option(qn, contents);
        for (int i = 0; i < options.size(); ++i) {
            if (!options.get(i).equals(option)) continue;
            options.remove(i);
            break;
        }
        options.add(option);
        if (Option.PROFILE_QNAME.compareTo(qn) == 0) {
            this.profiler.configure(option);
        } else if (Option.TIMEOUT_QNAME.compareTo(qn) == 0) {
            this.watchdog.setTimeoutFromOption(option);
        } else if (Option.OUTPUT_SIZE_QNAME.compareTo(qn) == 0) {
            this.watchdog.setMaxNodesFromOption(option);
        } else if (Option.OPTIMIZE_QNAME.compareTo(qn) == 0) {
            String[] param;
            String[] params = option.tokenizeContents();
            if (params.length > 0 && (param = Option.parseKeyValuePair(params[0])) != null && "enable".equals(param[0])) {
                this.enableOptimizer = "yes".equals(param[1]);
            }
        } else if (Option.OPTIMIZE_IMPLICIT_TIMEZONE.compareTo(qn) == 0) {
            Duration duration = TimeUtils.getInstance().newDuration(option.getContents());
            this.implicitTimeZone = new SimpleTimeZone((int)duration.getTimeInMillis(new Date()), "XQuery context");
        } else if (Option.CURRENT_DATETIME.compareTo(qn) == 0) {
            DateTimeValue dtv = new DateTimeValue(option.getContents());
            this.calendar = (XMLGregorianCalendar)dtv.calendar.clone();
        }
    }

    @Override
    public Option getOption(QName qname) {
        if (this.dynamicOptions != null) {
            for (Option option : this.dynamicOptions) {
                if (qname.compareTo(option.getQName()) != 0) continue;
                return option;
            }
        }
        if (this.staticOptions != null) {
            for (Option option : this.staticOptions) {
                if (qname.compareTo(option.getQName()) != 0) continue;
                return option;
            }
        }
        return null;
    }

    @Override
    public Pragma getPragma(String name, String contents) throws XPathException {
        QName qname;
        try {
            qname = QName.parse(this, name);
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException(ErrorCodes.XPST0081, "No namespace defined for prefix " + name);
        }
        if ("".equals(qname.getNamespaceURI())) {
            throw new XPathException("XPST0081: pragma's ('" + name + "') namespace URI is empty");
        }
        if ("http://exist.sourceforge.net/NS/exist".equals(qname.getNamespaceURI())) {
            contents = StringValue.trimWhitespace(contents);
            if (TimerPragma.TIMER_PRAGMA.equals(qname)) {
                return new TimerPragma(qname, contents);
            }
            if (Optimize.OPTIMIZE_PRAGMA.equals(qname)) {
                return new Optimize(this, qname, contents, true);
            }
            if (ForceIndexUse.EXCEPTION_IF_INDEX_NOT_USED_PRAGMA.equals(qname)) {
                return new ForceIndexUse(qname, contents);
            }
            if (ProfilePragma.PROFILING_PRAGMA.equals(qname)) {
                return new ProfilePragma(qname, contents);
            }
            if (NoIndexPragma.NO_INDEX_PRAGMA.equals(qname)) {
                return new NoIndexPragma(qname, contents);
            }
        }
        return null;
    }

    @Override
    public DocumentImpl storeTemporaryDoc(org.exist.dom.memtree.DocumentImpl doc) throws XPathException {
        try {
            DocumentImpl targetDoc = this.getBroker().storeTempResource(doc);
            if (targetDoc == null) {
                throw new XPathException("Internal error: failed to store temporary doc fragment");
            }
            LOG.warn("Stored: " + targetDoc.getDocId() + ": " + targetDoc.getURI(), new Throwable());
            return targetDoc;
        }
        catch (EXistException e) {
            throw new XPathException(TEMP_STORE_ERROR, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException(TEMP_STORE_ERROR, (Throwable)e);
        }
        catch (LockException e) {
            throw new XPathException(TEMP_STORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void setAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void setXQueryContextVar(String name, Object XQvar) {
        this.XQueryContextVars.put(name, XQvar);
    }

    @Override
    public Object getXQueryContextVar(String name) {
        return this.XQueryContextVars.get(name);
    }

    protected void loadDefaults(Configuration config) {
        this.watchdog = new XQueryWatchDog(this);
        this.loadDefaultNS();
        Object param = config.getProperty(PROPERTY_ENABLE_QUERY_REWRITING);
        this.enableOptimizer = param != null && "yes".equals(param.toString());
        param = config.getProperty(PROPERTY_XQUERY_BACKWARD_COMPATIBLE);
        this.backwardsCompatible = param == null || "yes".equals(param.toString());
        Boolean option = (Boolean)config.getProperty(PROPERTY_XQUERY_RAISE_ERROR_ON_FAILED_RETRIEVAL);
        this.raiseErrorOnFailedRetrieval = option != null && option != false;
        Map builtInModules = (Map)config.getProperty(PROPERTY_BUILT_IN_MODULES);
        if (builtInModules != null) {
            for (Map.Entry entry : builtInModules.entrySet()) {
                String namespaceURI = (String)entry.getKey();
                Class moduleClass = (Class)entry.getValue();
                Module module = this.getModule(namespaceURI);
                if (module == null) {
                    this.instantiateModule(namespaceURI, moduleClass, (Map)config.getProperty(PROPERTY_MODULE_PARAMETERS));
                    continue;
                }
                if (this.getPrefixForURI(module.getNamespaceURI()) != null || module.getDefaultPrefix().length() <= 0) continue;
                try {
                    this.declareNamespace(module.getDefaultPrefix(), module.getNamespaceURI());
                }
                catch (XPathException e) {
                    LOG.warn("Internal error while loading default modules: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void loadDefaultNS() {
        try {
            this.staticNamespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
            this.staticPrefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
            this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.declareNamespace("xdt", "http://www.w3.org/2003/05/xpath-datatypes");
            this.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
            this.declareNamespace("local", "http://www.w3.org/2005/xquery-local-functions");
            this.declareNamespace("err", "http://www.w3.org/2005/xqt-errors");
            this.declareNamespace("exist", "http://exist.sourceforge.net/NS/exist");
            this.declareNamespace("java", "http://exist.sourceforge.net/NS/exist/java-binding");
            this.declareNamespace("exerr", "http://www.exist-db.org/xqt-errors/");
            this.declareNamespace("dbgp", "http://www.xdebug.org/");
        }
        catch (XPathException e) {
            LOG.debug((Object)e);
        }
    }

    @Override
    public void registerUpdateListener(UpdateListener listener) {
        if (this.updateListener == null) {
            this.updateListener = new ContextUpdateListener();
            DBBroker broker = this.getBroker();
            broker.getBrokerPool().getNotificationService().subscribe(this.updateListener);
        }
        this.updateListener.addListener(listener);
    }

    protected void clearUpdateListeners() {
        if (this.updateListener != null) {
            DBBroker broker = this.getBroker();
            broker.getBrokerPool().getNotificationService().unsubscribe(this.updateListener);
        }
        this.updateListener = null;
    }

    @Override
    public void checkOptions(Properties properties) throws XPathException {
        this.checkLegacyOptions(properties);
        if (this.dynamicOptions != null) {
            for (Option option : this.dynamicOptions) {
                if (!"http://www.w3.org/2010/xslt-xquery-serialization".equals(option.getQName().getNamespaceURI())) continue;
                properties.put(option.getQName().getLocalPart(), option.getContents());
            }
        }
        if (this.staticOptions != null) {
            for (Option option : this.staticOptions) {
                if (!"http://www.w3.org/2010/xslt-xquery-serialization".equals(option.getQName().getNamespaceURI()) || properties.containsKey(option.getQName().getLocalPart())) continue;
                properties.put(option.getQName().getLocalPart(), option.getContents());
            }
        }
    }

    private void checkLegacyOptions(Properties properties) throws XPathException {
        Option pragma = this.getOption(Option.SERIALIZE_QNAME);
        if (pragma == null) {
            return;
        }
        String[] contents = pragma.tokenizeContents();
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Option.parseKeyValuePair(contents[i]);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().getStringValue() + ": '" + contents[i] + "'");
            }
            LOG.debug("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]);
            properties.setProperty(pair[0], pair[1]);
        }
    }

    @Override
    public void setDebuggeeJoint(DebuggeeJoint joint) {
        this.debuggeeJoint = joint;
    }

    @Override
    public DebuggeeJoint getDebuggeeJoint() {
        return this.debuggeeJoint;
    }

    @Override
    public boolean isDebugMode() {
        return this.debuggeeJoint != null && this.isVarDeclared(Debuggee.SESSION);
    }

    @Override
    public boolean requireDebugMode() {
        return this.isVarDeclared(Debuggee.SESSION);
    }

    public void enterEnclosedExpr() {
        if (this.binaryValueInstances != null) {
            Iterator<BinaryValue> it = this.binaryValueInstances.descendingIterator();
            while (it.hasNext()) {
                it.next().incrementSharedReferences();
            }
        }
    }

    public void exitEnclosedExpr() {
        if (this.binaryValueInstances != null) {
            Iterator<BinaryValue> it = this.binaryValueInstances.iterator();
            ArrayList<BinaryValue> destroyable = null;
            while (it.hasNext()) {
                try {
                    BinaryValue bv = it.next();
                    bv.close();
                    if (!bv.isClosed()) continue;
                    if (destroyable == null) {
                        destroyable = new ArrayList<BinaryValue>();
                    }
                    destroyable.add(bv);
                }
                catch (IOException e) {
                    LOG.warn("Unable to close binary reference on exiting enclosed expression: " + e.getMessage(), (Throwable)e);
                }
            }
            if (destroyable != null) {
                for (BinaryValue bvd : destroyable) {
                    this.binaryValueInstances.remove(bvd);
                }
            }
        }
    }

    @Override
    public void registerBinaryValueInstance(BinaryValue binaryValue) {
        if (this.binaryValueInstances == null) {
            this.binaryValueInstances = new ArrayDeque<BinaryValue>();
        }
        if (this.cleanupTasks.isEmpty() || !this.cleanupTasks.stream().filter(ct -> ct instanceof BinaryValueCleanupTask).findFirst().isPresent()) {
            this.cleanupTasks.add(new BinaryValueCleanupTask());
        }
        this.binaryValueInstances.push(binaryValue);
    }

    @Override
    public String getCacheClass() {
        return (String)this.getBroker().getConfiguration().getProperty("binary.cache.class");
    }

    public void destroyBinaryValue(BinaryValue value) {
        if (this.binaryValueInstances != null && this.binaryValueInstances.contains(value)) {
            this.binaryValueInstances.remove(value);
        }
    }

    public void setXQueryVersion(int version) {
        this.xqueryVersion = version;
    }

    public int getXQueryVersion() {
        return this.xqueryVersion;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public void setSource(Source source) {
        this.source = source;
    }

    public void registerCleanupTask(CleanupTask cleanupTask) {
        this.cleanupTasks.add(cleanupTask);
    }

    @Override
    public void runCleanupTasks(Predicate<Object> predicate) {
        for (CleanupTask cleanupTask : this.cleanupTasks) {
            try {
                cleanupTask.cleanup(this, predicate);
            }
            catch (Throwable t) {
                LOG.error("Cleaning up XQueryContext: Ignoring: " + t.getMessage(), t);
            }
        }
        this.cleanupTasks.clear();
    }

    public static interface CleanupTask {
        public void cleanup(XQueryContext var1, Predicate<Object> var2);
    }

    private static class ContextUpdateListener
    implements UpdateListener {
        private List<UpdateListener> listeners = new ArrayList<UpdateListener>();

        private ContextUpdateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(UpdateListener listener) {
            List<UpdateListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void documentUpdated(DocumentImpl document, int event) {
            List<UpdateListener> list = this.listeners;
            synchronized (list) {
                for (UpdateListener listener : this.listeners) {
                    if (listener == null) continue;
                    listener.documentUpdated(document, event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsubscribe() {
            List<UpdateListener> list = this.listeners;
            synchronized (list) {
                for (UpdateListener listener : this.listeners) {
                    if (listener == null) continue;
                    listener.unsubscribe();
                }
                this.listeners.clear();
            }
        }

        @Override
        public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
            for (UpdateListener listener : this.listeners) {
                listener.nodeMoved(oldNodeId, newNode);
            }
        }

        @Override
        public void debug() {
            LOG.debug(String.format("XQueryContext: %s document update listeners", this.listeners.size()));
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).debug();
            }
        }
    }

    public static class BinaryValueCleanupTask
    implements CleanupTask {
        @Override
        public void cleanup(XQueryContext context, Predicate<Object> predicate) {
            if (context.binaryValueInstances != null) {
                ArrayList<BinaryValue> removable = null;
                for (BinaryValue bv : context.binaryValueInstances) {
                    try {
                        if (!predicate.test(bv)) continue;
                        bv.close();
                        if (removable == null) {
                            removable = new ArrayList<BinaryValue>();
                        }
                        removable.add(bv);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to close binary value: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (removable != null) {
                    for (BinaryValue bv : removable) {
                        context.binaryValueInstances.remove(bv);
                    }
                }
            }
        }
    }

    private class SavedState {
        private HashMap<String, Module> modulesSaved = null;
        private HashMap<String, Module> allModulesSaved = null;
        private HashMap<String, String> staticNamespacesSaved = null;
        private HashMap<String, String> staticPrefixesSaved = null;

        private SavedState() {
        }

        void save() {
            if (this.modulesSaved == null) {
                this.modulesSaved = (HashMap)XQueryContext.this.modules.clone();
                this.allModulesSaved = (HashMap)XQueryContext.this.allModules.clone();
                this.staticNamespacesSaved = (HashMap)XQueryContext.this.staticNamespaces.clone();
                this.staticPrefixesSaved = (HashMap)XQueryContext.this.staticPrefixes.clone();
            }
        }

        void restore() {
            if (this.modulesSaved != null) {
                XQueryContext.this.modules = this.modulesSaved;
                this.modulesSaved = null;
                XQueryContext.this.allModules = this.allModulesSaved;
                this.allModulesSaved = null;
                XQueryContext.this.staticNamespaces = this.staticNamespacesSaved;
                this.staticNamespacesSaved = null;
                XQueryContext.this.staticPrefixes = this.staticPrefixesSaved;
                this.staticPrefixesSaved = null;
            }
        }
    }
}

